/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderEntity;
import com.ejianc.business.outrmat.order.mapper.OutRmatOrderMapper;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatOrderService")
public class OutRmatOrderServiceImpl
extends BaseServiceImpl<OutRmatOrderMapper, OutRmatOrderEntity>
implements IOutRmatOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderDetailService detailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOutRmatContractService outRmatContractService;
    @Autowired
    private IOutRmatDeliveryService outRmatDeliveryService;
    @Autowired
    private IOutRmatOrderDeliveryService outRmatOrderDeliveryService;
    @Autowired
    private IReceiptsApi receiptsApi;
    private final String FILE_TYPE = "outRmatOrder";
    private static final String OPERATE = "ORDER_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u79df\u51fa\u8ba2\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u79df\u51fa\u8ba2\u5355.getName();

    @Override
    public void saveOrder(OutRmatOrderVO saveOrUpdateVO) {
        OutRmatContractEntity outRmatContractEntity;
        this.logger.info("\u8fdb\u5165\u8ba2\u5355\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)saveOrUpdateVO);
        OutRmatOrderEntity entity = (OutRmatOrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatOrderEntity.class));
        if (CollectionUtils.isEmpty(entity.getOrderDetailList())) {
            throw new BusinessException("\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OutRmatOrderEntity orderEntity = (OutRmatOrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (null != orderEntity) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)orderEntity)));
        }
        entity.setDisableState("0");
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveState("0");
        CommonResponse copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(saveOrUpdateVO.getId().toString(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId().toString(), BILL_TYPE, "outRmatOrder");
        if (!copyContractFileResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{saveOrUpdateVO.getId(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId(), BILL_TYPE, "outRmatOrder", copyContractFileResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg());
        }
        if (null == (outRmatContractEntity = (OutRmatContractEntity)((Object)this.outRmatContractService.selectById(entity.getContractId())))) {
            throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5931\u8d25\uff01");
        }
        entity.setOutOrgId(outRmatContractEntity.getOutOrgId());
        entity.setOutOrgCode(outRmatContractEntity.getOutOrgCode());
        entity.setOutOrgName(outRmatContractEntity.getOutOrgName());
        List collect = entity.getOrderDetailList().stream().map(item -> item.getMaterialId()).collect(Collectors.toList());
        CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(collect);
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7269\u8d44\u6863\u6848\u5931\u8d25\uff01");
        }
        Map data = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (v1, v2) -> v2));
        for (OutRmatOrderDetailEntity outRmatOrderDetailEntity : entity.getOrderDetailList()) {
            if (!data.containsKey(outRmatOrderDetailEntity.getMaterialId())) continue;
            outRmatOrderDetailEntity.setUnitMId(((MaterialVO)data.get(outRmatOrderDetailEntity.getMaterialId())).getUnitId());
            outRmatOrderDetailEntity.setUnitMName(((MaterialVO)data.get(outRmatOrderDetailEntity.getMaterialId())).getUnitName());
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        if (!flag) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u8ba2\u5355\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    @Override
    public void deleteOrder(OutRmatOrderVO vo) {
        boolean flag;
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OutRmatOrderEntity orderEntity = (OutRmatOrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (null == orderEntity) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!"0".equals(orderEntity.getReceiveState())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5904\u7406\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(orderEntity.getId(), BILL_TYPE, "outRmatOrder", null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean bl = flag = ((OutRmatOrderMapper)this.baseMapper).deleteOrder(vo.getId()) != false && this.detailService.deleteOrderDetailByOrderId(vo.getId()) != false;
        if (!flag) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01");
        }
        this.logger.info("\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<");
    }

    @Override
    public String updateOrderCloseFlag(OutRmatOrderVO vo) {
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OutRmatOrderEntity orderEntity = (OutRmatOrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if ("1".equals(orderEntity.getDeliverState())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5173\u95ed\uff01");
        }
        StringBuilder errorBillCode = new StringBuilder();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("eq", (Object)orderEntity.getId()));
        List orderDeliveryEntities = this.outRmatOrderDeliveryService.queryList(queryParam);
        Map<Long, List<OutRmatOrderDeliveryEntity>> collect = orderDeliveryEntities.stream().collect(Collectors.groupingBy(OutRmatOrderDeliveryEntity::getDeliveryId));
        if (MapUtils.isNotEmpty(collect)) {
            Set<Long> longs = collect.keySet();
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.add(1);
            integers.add(3);
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", longs));
            param.getParams().put("billState", new Parameter("ne", integers));
            List outRmatDeliveryEntities = this.outRmatDeliveryService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)outRmatDeliveryEntities)) {
                errorBillCode.append("\u53d1\u8d27\u5355[");
                this.logger.error("\u5b58\u5728\u672a\u751f\u6548\u7684\u9001\u8d27\u5355\uff0c\u9001\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)outRmatDeliveryEntities));
                for (OutRmatDeliveryEntity outRmatDeliveryEntity : outRmatDeliveryEntities) {
                    errorBillCode.append(outRmatDeliveryEntity.getBillCode()).append(",");
                }
                errorBillCode.delete(errorBillCode.length() - 1, errorBillCode.length());
                errorBillCode.append("]\u8fd8\u672a\u5b8c\u6210\u9a8c\u6536\u6216\u5173\u95ed\uff0c\u4e0d\u80fd\u5173\u95ed\u8ba2\u5355");
            }
        }
        orderEntity.setDisableState("1");
        boolean b = super.saveOrUpdate((Object)orderEntity, false);
        if (!b) {
            throw new BusinessException("\u8ba2\u5355\u5173\u95ed\u5f02\u5e38\uff01");
        }
        this.logger.info("\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u6210\u529f>>>>>>>>>>>>>>>>>>>");
        return errorBillCode.toString();
    }

    @Override
    public OutRmatOrderVO saveOrUpdate(OutRmatOrderVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (saveOrUpdateVO.getReceiveState() == null || CommonConstant.ORDER_RECEIVE_STATE.get(saveOrUpdateVO.getReceiveState()) == null) {
            throw new BusinessException("\u63a5\u6536\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        OutRmatOrderEntity entity = (OutRmatOrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        entity.setDenialReason(saveOrUpdateVO.getDenialReason());
        entity.setReceiveState(saveOrUpdateVO.getReceiveState());
        if (!"3".equals(saveOrUpdateVO.getReceiveState()) && CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getOrderDetailList())) {
            throw new BusinessException("\u6e05\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<Long, BigDecimal> voReceiveMap = new HashMap<Long, BigDecimal>();
        for (OutRmatOrderDetailVO detailVO : saveOrUpdateVO.getOrderDetailList()) {
            voReceiveMap.put(detailVO.getId(), detailVO.getReceiveNumsSum());
        }
        if (CollectionUtils.isNotEmpty(entity.getOrderDetailList())) {
            for (OutRmatOrderDetailEntity detail : entity.getOrderDetailList()) {
                if ("1".equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(detail.getPlanNumsSum());
                } else if ("2".equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(ComputeUtil.safeAdd((BigDecimal)((BigDecimal)voReceiveMap.get(detail.getId())), (BigDecimal)BigDecimal.ZERO));
                } else if ("3".equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(BigDecimal.ZERO);
                }
                detail.setNotDeliveredNumsSum(detail.getReceiveNumsSum());
                detail.setDeliveredNumsSum(BigDecimal.ZERO);
            }
            entity.setDeliverState("1");
        }
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        OutRmatOrderVO vo = new OutRmatOrderVO();
        vo.setId(entity.getId());
        vo.setReceiveState(entity.getReceiveState());
        ArrayList<OutRmatOrderDetailVO> detailList = new ArrayList<OutRmatOrderDetailVO>();
        for (OutRmatOrderDetailEntity detail : entity.getOrderDetailList()) {
            OutRmatOrderDetailVO detailVO = new OutRmatOrderDetailVO();
            detailVO.setId(detail.getId());
            detailVO.setOrderId(detail.getOrderId());
            detailVO.setReceiveNumsSum(detail.getReceiveNumsSum());
            detailList.add(detailVO);
        }
        vo.setOrderDetailList(detailList);
        CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)vo), ReceiptsEnum.\u79df\u8d41\u8ba2\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        super.saveOrUpdate((Object)entity, false);
        OutRmatOrderVO orderVO = (OutRmatOrderVO)BeanMapper.map((Object)((Object)entity), OutRmatOrderVO.class);
        return orderVO;
    }
}

