/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.lose.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.SupplierSignStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractDailyRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractMonthRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractNumRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"outRmatLose"})
public class OutRmatLoseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FLZX_ZCYSD_CODE";
    @Autowired
    private IOutRmatLoseService service;
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;
    @Autowired
    private IOutRmatContractNumRentService outRmatNumRentService;
    @Autowired
    private IOutRmatContractDailyRentService outRmatDailyRentService;
    @Autowired
    private IOutRmatContractMonthRentService outRmatMonthRentService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRmatFlowService flowService;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/assistrmat/outRmatLose/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatLoseVO> saveOrUpdate(@RequestBody OutRmatLoseVO saveOrUpdateVO) {
        this.outRmatMaterialService.validateContract(saveOrUpdateVO.getContractId(), "\u9057\u5931\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.service.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatLoseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getLoseDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)entity, false);
        OutRmatLoseVO vo = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String validateNum(OutRmatLoseVO outRmatLoseVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)outRmatLoseVO.getContractId()));
        List<MaterialVO> list = this.outRmatMaterialService.queryCheckList(param, "lose");
        Map map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getUseStatus() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        for (OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()) {
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
            if (!map.containsKey(key) || vo.getLoseNum().compareTo(((MaterialVO)map.get(key)).getRefNum()) <= 0) continue;
            throw new BusinessException("\u5b50\u8868\u6570\u91cf\u5927\u4e8e\u53ef\u53c2\u7167\u6570\u91cf");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatLoseVO> queryDetail(Long id) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(id));
        OutRmatLoseVO vo = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatLoseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatLoseVO outRmatLoseVO : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRmatLoseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("outOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else if (((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List outRmatLoseVOS = BeanMapper.mapList((Iterable)page.getRecords(), OutRmatLoseVO.class);
        outRmatLoseVOS.forEach(e -> {
            if (e.getSupplierSignStatus() == 1) {
                e.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                e.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
        });
        pageData.setRecords(outRmatLoseVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List outRmatLoseVOS = BeanMapper.mapList((Iterable)list, OutRmatLoseVO.class);
        outRmatLoseVOS.forEach(e -> {
            if (e.getSupplierSignStatus() == 1) {
                e.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                e.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", outRmatLoseVOS);
        ExcelExport.getInstance().export("OutRmatLose-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLoseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatLoseVO>> refLoseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatLoseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/getLosePrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getLosePrice(@RequestBody List<MaterialVO> vos) {
        ArrayList list = new ArrayList();
        vos.forEach(e -> {
            if ("0".equals(e.getRentCalculationType())) {
                QueryWrapper query = new QueryWrapper();
                query.select(new String[]{"material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice"});
                query.eq((Object)"dr", (Object)0);
                query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                query.eq((Object)"material_id", (Object)e.getMaterialId());
                List map = this.outRmatDailyRentService.listMaps((Wrapper)query);
                list.addAll(map);
            } else if ("1".equals(e.getRentCalculationType())) {
                QueryWrapper query = new QueryWrapper();
                query.select(new String[]{"material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice"});
                query.eq((Object)"dr", (Object)0);
                query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                query.eq((Object)"material_id", (Object)e.getMaterialId());
                List map = this.outRmatMonthRentService.listMaps((Wrapper)query);
                list.addAll(map);
            } else {
                QueryWrapper query = new QueryWrapper();
                query.select(new String[]{"material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice"});
                query.eq((Object)"dr", (Object)0);
                query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                query.eq((Object)"material_id", (Object)e.getMaterialId());
                List map = this.outRmatNumRentService.listMaps((Wrapper)query);
                list.addAll(map);
            }
        });
        return CommonResponse.success(list);
    }

    @GetMapping(value={"/testPushBill"})
    public CommonResponse<String> testPushBill(Long id) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(id));
        this.service.pushBillToSupCenter(entity);
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getBillShareLink"})
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode(), entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/assistrmat/outRmatLose/card", null);
    }
}

