package com.ejianc.business.outrmat.restitute.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.rmat.vo.RestituteDetailVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseDetailEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteDetailVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outrmat.restitute.mapper.OutRmatRestituteMapper;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * out-退赔单
 * 
 * @author generator
 * 
 */
@Service("outRmatRestituteService")
public class OutRmatRestituteServiceImpl extends BaseServiceImpl<OutRmatRestituteMapper, OutRmatRestituteEntity> implements IOutRmatRestituteService{


    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "out-rmat-restitute";//此处需要根据实际修改

    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;


    @Autowired
    private IRmatFlowService flowService;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private StoreManageService storeManageService;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.租出退赔单.getCode();
    private static final String BILL_NAME = BillTypeEnum.租出退赔单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/outRmatRestitute/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/outRmatRestitute/billDel";


    @Override
    public List<StoreManageVO> getStoreManageVOList(OutRmatRestituteVO vo , Boolean outEffectiveON) {
        List<StoreManageVO> storeManageVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(vo.getRestituteDetailList())) {
            Map<Long, List<OutRmatRestituteDetailVO>> detailMap = vo.getRestituteDetailList().stream().filter(t->null!=t.getStoreId()).collect(Collectors.groupingBy(OutRmatRestituteDetailVO::getStoreId));
            if(MapUtils.isNotEmpty(detailMap)){
                for (Long storeId : detailMap.keySet()) {//材料来源,0-自购,1-租赁
                    List<OutRmatRestituteDetailVO> detailVOList = detailMap.get(storeId).stream().filter(t -> "0".equals(t.getSourceType())).collect(Collectors.toList());
                    //调用库存
                    if(CollectionUtils.isNotEmpty(detailVOList)){
                        StoreManageVO storeManageVO = new StoreManageVO();
                        storeManageVO.setStoreId(storeId);
                        storeManageVO.setSourceId(vo.getId());
                        storeManageVO.setInOutTypeEnum(InOutTypeEnum.辅料中心租出退赔);
                        storeManageVO.setOutEffectiveON(outEffectiveON);
                        ArrayList<FlowVO> flowVOS = new ArrayList<>();
                        //删除的数据
                        detailVOList.forEach(t->{
                            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.辅料中心租出退赔, 0);
                            flowVO.setStoreId(t.getStoreId());
                            flowVO.setStoreName(t.getStoreName());
                            flowVO.setProjectId(vo.getProjectId());
                            flowVO.setProjectName(vo.getProjectName());
                            flowVO.setOrgId(vo.getOrgId());
                            flowVO.setOrgName(vo.getOrgName());
                            flowVO.setParentOrgId(vo.getParentOrgId());
                            flowVO.setParentOrgName(vo.getParentOrgName());
                            flowVO.setEmployeeId(vo.getEmployeeId());
                            flowVO.setEmployeeName(vo.getEmployeeName());
                            flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                            flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                            flowVO.setMaterialId(t.getMaterialId());
                            flowVO.setMaterialName(t.getMaterialName());
                            flowVO.setMaterialSpec(t.getSpec());
                            flowVO.setMaterialUnitId(t.getUnitMId());
                            flowVO.setMaterialUnitName(t.getUnitMName());
                            flowVO.setSourceBillDetailRemark(t.getMemo());
                            flowVO.setTaxPrice(BigDecimal.ZERO);
                            flowVO.setPrice(BigDecimal.ZERO);
                            flowVO.setNum(ComputeUtil.safeDiv(t.getScrapNum(), t.getTransScale()));//报废数量
                            flowVO.setTaxMny(BigDecimal.ZERO);
                            flowVO.setMny(BigDecimal.ZERO);
                            flowVO.setTax(BigDecimal.ZERO);

                            flowVO.setTenantId(t.getTenantId());
                            flowVO.setSourceId(vo.getId());
                            flowVO.setSourceDetailId(t.getId());
                            flowVO.setSourceBillCode(vo.getBillCode());
                            flowVO.setSourceBillDate(vo.getRestituteDate());
                            flowVO.setRowState(t.getRowState());
                            flowVO.setSourceBillRemark(vo.getMemo());
//                                flowVO.setPurchasePrice(t.getOriginalValuePrice());
//                                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                            flowVOS.add(flowVO);
                        });
                        storeManageVO.setFlowVOList(flowVOS);
                        storeManageVOList.add(storeManageVO);
                    }
                }
            }
        }
        return storeManageVOList;
    }


    @Override
    public OutRmatRestituteVO saveOrUpdate(OutRmatRestituteVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        outRmatMaterialService.validateContract(saveOrUpdateVO.getContractId(), OutRmatConstant.退赔单, saveOrUpdateVO.getId(), OutRmatConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, OutRmatConstant.保存);
        //校验数量
        validateNum(saveOrUpdateVO);
        OutRmatRestituteEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatRestituteEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 汇总材料分类
        List<OutRmatRestituteDetailVO> detailList = saveOrUpdateVO.getRestituteDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        boolean b = super.saveOrUpdate(entity, false);
        // 推送流水未生效
        OutRmatRestituteVO map = BeanMapper.map(entity, OutRmatRestituteVO.class);
        List<OutRmatRestituteDetailVO> detailVOS = saveOrUpdateVO.getRestituteDetailList().stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(detailVOS)){
            map.getRestituteDetailList().addAll(detailVOS);
        }
        if(!flowService.insertRestFlow(BeanMapper.map(map, OutRmatRestituteEntity.class), BillTypeEnum.租出退赔单.getCode(), RmatCommonConsts.NO)){
            throw new BusinessException("单据推送流水失败！");
        }
        //材料来源为自购 推送库存未生效
        if (b) {
            List<StoreManageVO> storeManageVOList = getStoreManageVOList(map, false);
            if(CollectionUtils.isNotEmpty(storeManageVOList)){
                logger.info("库存所有入参："+JSONObject.toJSONString(storeManageVOList));
                for (StoreManageVO storeManageVO : storeManageVOList) {
                    logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
                    CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
                    if(!response.isSuccess()) {
                        throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                    }
                }
            }
        }
        OutRmatRestituteVO vo = BeanMapper.map(entity, OutRmatRestituteVO.class);
        return vo;
    }

    @Override
    public void delete(List<OutRmatRestituteVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatRestituteVO vo : vos) {
                OutRmatRestituteEntity entity = super.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(entity.getRestituteDetailList())){
                    Map<Long, List<OutRmatRestituteDetailEntity>> detailMap = entity.getRestituteDetailList().stream().filter(t->null!=t.getStoreId()).collect(Collectors.groupingBy(OutRmatRestituteDetailEntity::getStoreId));
                    if(MapUtils.isNotEmpty(detailMap)) {
                        for (Long storeId : detailMap.keySet()) {//材料来源,0-自购,1-租赁
                            List<OutRmatRestituteDetailEntity> detailVOList = detailMap.get(storeId).stream().filter(t -> "0".equals(t.getSourceType())).collect(Collectors.toList());
                            //调用库存
                            if (CollectionUtils.isNotEmpty(detailVOList)) {
                                StoreManageVO storeManageVO = new StoreManageVO();
                                storeManageVO.setStoreId(storeId);
                                storeManageVO.setSourceId(entity.getId());
                                storeManageVO.setInOutTypeEnum(InOutTypeEnum.辅料中心租出退赔);
                                storeManageVO.setOutEffectiveON(false);
                                ArrayList<Long> longs = new ArrayList<>();
                                longs.add(entity.getId());
                                storeManageVO.setSourceIdsForRollBack(longs);
                                logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
                                CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
                                if(!response.isSuccess()) {
                                    throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                                }

                            }
                        }
                    }
                }
            }
        }
        List<Long> ids = vos.stream().map(OutRmatRestituteVO::getId).collect(Collectors.toList());
        // 删除流水
        if(!flowService.delFlow(ids, BillTypeEnum.租出退赔单.getCode())){
            throw new BusinessException("单据删除流水失败！");
        }
        super.removeByIds(ids,true);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatRestituteEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的退赔单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param  OutRmatRestituteVO
     * @return
     */
    @Override
    public String validateTime(OutRmatRestituteVO restituteVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", restituteVO.getContractId());
        if(restituteVO.getId() != null){
            params.put("billType", MaterialConstant.退赔单);
            params.put("billId", restituteVO.getId());
        }
        Date lastDate = outRmatMaterialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = outRmatMaterialService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(restituteVO.getStopDate(), lastDate, maxTimeMap,restituteVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(restituteVO.getStopDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(OutRmatRestituteDetailVO vo : restituteVO.getRestituteDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatRestituteEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatRestituteEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                OutRmatRestituteEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatRestituteEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public String updateBillSupSignSync(Map<String,String> map) {
        String billId = map.get("billId");
        OutRmatRestituteEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutRmatRestituteEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }

    /**
     * 校验数量不能大于可参照数量
     * @param restituteVO
     * @return
     */
    private String validateNum(OutRmatRestituteVO restituteVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, restituteVO.getContractId()));
        List<MaterialVO> list = outRmatMaterialService.queryCheckList(param, "rest");
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getUseStatus() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        BigDecimal num = BigDecimal.ZERO;
        for(OutRmatRestituteDetailVO vo : restituteVO.getRestituteDetailList()){
            num = ComputeUtil.safeSub(vo.getFullNum(), vo.getMaintainNum(), vo.getScrapNum());
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
            if(map.containsKey(key) && num.compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }
}
