package com.ejianc.business.outrmat.proxy.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.outrmat.proxy.bean.ProxyContractDetailEntity;
/**
 * 辅料中心-周转材租出-合同授权委托书
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outrmat_proxy_contract")
public class ProxyContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 委托编码
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="proxy_org_id")
    private Long proxyOrgId; // 被委托方组织id
    @TableField(value="proxy_org_name")
    private String proxyOrgName; // 
    @TableField(value="proxy_org_code")
    private String proxyOrgCode; // 被委托方组织编码
    @TableField(value="proxy_parent_org_id")
    private Long proxyParentOrgId; // 被委托方父级组织
    @TableField(value="proxy_parent_org_code")
    private String proxyParentOrgCode; // 被委托方父级组织编码
    @TableField(value="proxy_parent_org_name")
    private String proxyParentOrgName; // 
    @TableField(value="proxy_employee_id")
    private Long proxyEmployeeId; // 委托代理人id
    @TableField(value="proxy_employee_name")
    private String proxyEmployeeName; // 委托代理人名称
    @TableField(value="proxy_id_card")
    private String proxyIdCard; // 代理人身份证号
    @TableField(value="proxy_sex")
    private Integer proxySex; // 代理人性别(1-男，2-女)
    @TableField(value="employee_id")
    private Long employeeId; // 办理人
    @TableField(value="employee_name")
    private String employeeName; // 办理人名称
    @TableField(value="dept_id")
    private Long deptId; // 办理人部门
    @TableField(value="dept_name")
    private String deptName; // 办理人部门名称
    @TableField(value="proxy_date")
    private Date proxyDate; // 办理日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="sign_status")
    private Integer signStatus; // 合同签订状态：1-未签订，2-已签订
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="proxyContractDetailService", pidName = "proxyId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProxyContractDetailEntity> proxyContractDetailList = new ArrayList<>(); // 辅料中心-周转材租出-委托书明细

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProxyOrgId() {
        return proxyOrgId;
    }

    public void setProxyOrgId(Long proxyOrgId) {
        this.proxyOrgId = proxyOrgId;
    }
    public String getProxyOrgName() {
        return proxyOrgName;
    }

    public void setProxyOrgName(String proxyOrgName) {
        this.proxyOrgName = proxyOrgName;
    }
    public String getProxyOrgCode() {
        return proxyOrgCode;
    }

    public void setProxyOrgCode(String proxyOrgCode) {
        this.proxyOrgCode = proxyOrgCode;
    }
    public Long getProxyParentOrgId() {
        return proxyParentOrgId;
    }

    public void setProxyParentOrgId(Long proxyParentOrgId) {
        this.proxyParentOrgId = proxyParentOrgId;
    }
    public String getProxyParentOrgCode() {
        return proxyParentOrgCode;
    }

    public void setProxyParentOrgCode(String proxyParentOrgCode) {
        this.proxyParentOrgCode = proxyParentOrgCode;
    }
    public String getProxyParentOrgName() {
        return proxyParentOrgName;
    }

    public void setProxyParentOrgName(String proxyParentOrgName) {
        this.proxyParentOrgName = proxyParentOrgName;
    }
    public Long getProxyEmployeeId() {
        return proxyEmployeeId;
    }

    public void setProxyEmployeeId(Long proxyEmployeeId) {
        this.proxyEmployeeId = proxyEmployeeId;
    }
    public String getProxyEmployeeName() {
        return proxyEmployeeName;
    }

    public void setProxyEmployeeName(String proxyEmployeeName) {
        this.proxyEmployeeName = proxyEmployeeName;
    }
    public String getProxyIdCard() {
        return proxyIdCard;
    }

    public void setProxyIdCard(String proxyIdCard) {
        this.proxyIdCard = proxyIdCard;
    }
    public Integer getProxySex() {
        return proxySex;
    }

    public void setProxySex(Integer proxySex) {
        this.proxySex = proxySex;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getProxyDate() {
        return proxyDate;
    }

    public void setProxyDate(Date proxyDate) {
        this.proxyDate = proxyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    
    public List<ProxyContractDetailEntity> getProxyContractDetailList() {
        return proxyContractDetailList;
    }

    public void setProxyContractDetailList(List<ProxyContractDetailEntity> proxyContractDetailList) {
        this.proxyContractDetailList = proxyContractDetailList;
    }
}
