package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialSettleDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialSettleEntity;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.service.IMaterialCheckService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IMaterialSettleService;
import com.ejianc.business.assist.material.vo.MaterialSettleVO;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("materialSettle") 
public class MaterialSettleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IMaterialSettleService service;

	@Autowired
	private SessionManager sessionManager;
	
	@Autowired
	private IMaterialContractService contractService;

	@Autowired
	private IMaterialCheckService checkService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		MaterialSettleEntity settleEntity = service.selectById(billId);

		UserContext userContext = sessionManager.getUserContext();

		LambdaUpdateWrapper<MaterialSettleEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(MaterialSettleEntity::getCommitDate, new Date());
		wrapper.set(MaterialSettleEntity::getCommitUserCode, userContext.getUserCode());
		wrapper.set(MaterialSettleEntity::getCommitUserName, userContext.getUserName());


		MaterialContractEntity contractEntity = contractService.getById(settleEntity.getContractId());

		if (Objects.equals(settleEntity.getSettleType(), "1")) {
			// 最终结算回写合同状态为已终止
			contractEntity.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
			contractService.saveOrUpdate(contractEntity);
		}

		// 回写引用单据结算状态
		writeSettleFlag(settleEntity, 1);

		// 推送结算池
		Boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, MaterialSettleVO.class));
		wrapper.set(MaterialSettleEntity::getPushPoolFlag, poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());
		
		// 推送供方
		Boolean pushResult = service.pushBillToSupCenter(settleEntity);
		if(pushResult) {
			wrapper.set(MaterialSettleEntity::getBillPushFlag, BillPushStatusEnum.推送成功.getStatus());
		}else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.辅料中心采购合同结算单.getName(), billId);
			wrapper.set(MaterialSettleEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		}

		// 更新合同池操作
//		Boolean pushResult = service.pushContract(BeanMapper.map(settleEntity, SettleVO.class), UpdateLevelEnum.更新非空字段.getLevelCode());
//		if(pushResult) {
//			updateWrapper.eq(ContractEntity::getPushPoolFlag, BillPushStatusEnum.推送成功.getStatus());
//		} else {
//			updateWrapper.eq(ContractEntity::getPushPoolFlag, BillPushStatusEnum.未成功推送.getStatus());
//		}
//		contractService.update(updateWrapper);

		service.update(wrapper);

		return CommonResponse.success();
		
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		MaterialSettleEntity entity = service.selectById(billId);

		LambdaQueryWrapper<MaterialSettleEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(MaterialSettleEntity::getContractId, entity.getContractId());
		wrapper.orderByDesc(MaterialSettleEntity::getCreateTime);
		List<MaterialSettleEntity> list = service.list(wrapper);

		long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
		if (count > 0) {
			throw new BusinessException("当前单据存在非审批通过的单据，不能撤回/弃审！");
		}

		if (ListUtil.isNotEmpty(list)) {
			if (!Objects.equals(list.get(0).getId(), billId)) {
				throw new BusinessException("只能撤回/弃审最新一期的结算单！");
			}
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		// 结算单是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		MaterialSettleEntity entity = service.selectById(billId);

		// 回写合同状态
		LambdaUpdateWrapper<MaterialContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(MaterialContractEntity::getPerformanceStatus, PerformanceStatusEnum.履约中.getCode());
		updateWrapper.eq(MaterialContractEntity::getId, entity.getContractId());
		contractService.update(updateWrapper);

		// 回写引用单据结算状态
		writeSettleFlag(entity, 0);

		// 从结算池中删除数据
		boolean unPushRes = service.delSettleFromPool(entity.getId());
		if (!unPushRes) {
			entity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		}

		// 将推送至供方的单据作废
		if (BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
			boolean pushResult = service.delPushBill(entity);
			if (!pushResult) {
				return CommonResponse.error("弃审后回调失败，单据作废协同服务失败！");
			} else {
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}
		}

		service.saveOrUpdate(entity);

		return CommonResponse.success();
	}

	public void writeSettleFlag(MaterialSettleEntity entity, Integer settleFlag) {
		// 回写租金计算单结算状态
		List<Long> checkIdsList = new ArrayList<>();
		List<MaterialSettleDetailEntity> detailList = entity.getDetailList();
		if (ListUtil.isNotEmpty(detailList)) {
			checkIdsList.addAll(detailList.stream().map(MaterialSettleDetailEntity::getCheckId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(checkIdsList)) {
			LambdaUpdateWrapper<MaterialCheckEntity> checkWrapper = new LambdaUpdateWrapper<>();
			checkWrapper.set(MaterialCheckEntity::getSettleFlag, settleFlag);
			checkWrapper.in(MaterialCheckEntity::getId, checkIdsList);
			checkService.update(checkWrapper);
		}
		
	}
	
	
}
