/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.ProcessMapper;
import com.ejianc.business.assist.store.mapper.ProcessProductMapper;
import com.ejianc.business.assist.store.mapper.ProcessRawMapper;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="processService")
public class ProcessServiceImpl
extends BaseServiceImpl<ProcessMapper, ProcessEntity>
implements IProcessService {
    @Autowired
    private ProcessRawMapper processRawMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ProcessProductMapper processProductMapper;

    @Override
    public CommonResponse saveCheckProcess(ProcessEntity entity) {
        if (null != entity.getId()) {
            this.processRawMapper.delByProcessId(entity.getId());
        }
        ArrayList<ProcessRawEntity> delRawList = new ArrayList<ProcessRawEntity>();
        for (ProcessRawEntity e : entity.getProcessRawList()) {
            if (!"del".equals(e.getRowState())) continue;
            delRawList.add(e);
            break;
        }
        if (delRawList.size() > 0) {
            ArrayList<Long> delIds = new ArrayList<Long>();
            delIds.add(entity.getId());
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setStoreId(((ProcessRawEntity)((Object)delRawList.get(0))).getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(delIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<ProcessRawEntity> rawList = new ArrayList<ProcessRawEntity>();
        List<ProcessRawEntity> proceeRawList = entity.getProcessRawList();
        ArrayList<Long> storeList = new ArrayList<Long>();
        for (ProcessRawEntity detailEntity : proceeRawList) {
            if (detailEntity.getRawNum() == null || detailEntity.getRawNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            rawList.add(detailEntity);
            storeList.add(detailEntity.getStoreId());
        }
        if (rawList.size() > 0) {
            for (Long storeId : storeList) {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
                ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
                storeManageVO.setStoreId(storeId);
                for (ProcessRawEntity item : rawList) {
                    if (storeId != item.getStoreId()) continue;
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93, (Integer)0);
                    flowVO.setStoreId(item.getStoreId());
                    flowVO.setStoreName(item.getStoreName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgCode(entity.getParentOrgCode());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(item.getMaterialTypeId());
                    flowVO.setMaterialCategoryName(item.getMaterialTypeName());
                    flowVO.setMaterialId(item.getMaterialId());
                    flowVO.setMaterialCode(item.getMaterialCode());
                    flowVO.setMaterialName(item.getMaterialName());
                    flowVO.setMaterialSpec(item.getSpec());
                    flowVO.setMaterialUnitId(item.getUnitId());
                    flowVO.setMaterialUnitName(item.getUnitName());
                    flowVO.setOutNetMny(item.getNetWorthMny());
                    flowVO.setOutNetTaxMny(item.getNetWorthTaxMny());
                    flowVO.setPurchasePrice(item.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(item.getOriginalValueTaxPrice());
                    flowVO.setNum(item.getRawNum());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(item.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getProcessDate());
                    flowVOS.add(flowVO);
                }
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setFlowVOList(flowVOS);
                CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
                if (commonResponse.isSuccess()) continue;
                return commonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.processInOut(ids, false);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse processInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            ProcessEntity entity = (ProcessEntity)((Object)super.selectById((Serializable)item));
            Boolean checkFlag = false;
            ArrayList<Long> storeList = new ArrayList<Long>();
            List<ProcessRawEntity> processRawList = entity.getProcessRawList();
            for (Object t : processRawList) {
                if (t.getRawNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                storeList.add(t.getStoreId());
            }
            List storeIds = storeList.stream().distinct().collect(Collectors.toList());
            if (!checkFlag.booleanValue()) continue;
            if (outEffectiveON.booleanValue()) {
                Object t;
                t = storeIds.iterator();
                while (t.hasNext()) {
                    Long storeId = (Long)t.next();
                    SourceIds.clear();
                    SourceIds.add(entity.getId());
                    storeManageVO.setSourceId(item);
                    storeManageVO.setStoreId(storeId);
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
                    storeManageVO.setSourceIdsForRollBack(SourceIds);
                    storeManageVO.setOutEffectiveON(outEffectiveON);
                    CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
                    if (commonResponse.isSuccess()) continue;
                    return commonResponse;
                }
                continue;
            }
            SourceIds.clear();
            SourceIds.add(entity.getId());
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId((Long)storeIds.get(0));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (commonResponse.isSuccess()) continue;
            return commonResponse;
        }
        return CommonResponse.success();
    }
}

