package com.ejianc.business.outrmat.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.enums.RequireFlagEnum;
import com.ejianc.business.outrmat.delivery.enums.WeighFlagEnum;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("outRmatDelivery") 
public class OutRmatDeliveryBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IOutRmatDeliveryService service;
	@Autowired
	private IReceiptsApi receiptsApi;
	@Autowired
	private IRmatFlowService flowService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatDeliveryEntity outRmatDeliveryEntity = service.selectById(billId);
		if (outRmatDeliveryEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
			if (outRmatDeliveryEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
				return CommonResponse.error("地磅称重不符合要求,无法提交");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (state == 0){
			OutRmatDeliveryEntity outRmatDeliveryEntity = service.selectById(billId);
			if (outRmatDeliveryEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
				if (outRmatDeliveryEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
					return CommonResponse.error("地磅称重不符合要求,无法提交");
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//推送供方验收单
		OutRmatDeliveryEntity outRmatDeliveryEntity = service.selectById(billId);
		// 推送流水生效
		if(!flowService.insertCheckFlow(outRmatDeliveryEntity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(outRmatDeliveryEntity.getRentType())){
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(outRmatDeliveryEntity), ReceiptsEnum.验收单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatDeliveryEntity outRmatDeliveryEntity = service.selectById(billId);
		// 推送流水未生效
		if(!flowService.insertCheckFlow(outRmatDeliveryEntity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("弃审前回调失败，单据推送流水失败！");
		}
		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(outRmatDeliveryEntity.getRentType())) {
			CommonResponse<String> response = receiptsApi.delReceipts(outRmatDeliveryEntity.getId(), ReceiptsEnum.验收单.getName());
			if (!response.isSuccess()) {
				throw new BusinessException(response.getMsg());
			}
		}
		return CommonResponse.success();
	}

}
