package com.ejianc.business.outrmat.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.settle.bean.*;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("outRmatSettle")
public class OutRmatSettleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IOutRmatSettleService service;

	@Autowired
	private SessionManager sessionManager;
//TODO 待修改成租出线  租金计算
//	@Autowired
//	private IRentCalculateService calculateService;
	
	@Autowired
	private IOutRmatRestituteService outRmatRestituteService;

	@Autowired
	private IOutRmatLoseService outRmatLoseService;

	@Autowired
	private IOutRmatContractService outRmatContractService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		
		OutRmatSettleEntity outRmatSettleEntity = service.selectById(billId);

		UserContext userContext = sessionManager.getUserContext();

		LambdaUpdateWrapper<OutRmatSettleEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(OutRmatSettleEntity::getCommitDate, new Date());
		wrapper.set(OutRmatSettleEntity::getCommitUserCode, userContext.getUserCode());
		wrapper.set(OutRmatSettleEntity::getCommitUserName, userContext.getUserName());

		
		OutRmatContractEntity outRmatContractEntity = outRmatContractService.getById(outRmatSettleEntity.getContractId());

		if (Objects.equals(outRmatSettleEntity.getSettleType(), "1")) {
			// 最终结算回写合同状态为已终止
			outRmatContractEntity.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
			outRmatContractService.saveOrUpdate(outRmatContractEntity);
		}
		
		// 回写引用单据结算状态
		writeSettleFlag(outRmatSettleEntity, 1);

		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(outRmatSettleEntity.getRentType())){
			Boolean pushResult = service.pushBillToSupCenter(outRmatSettleEntity);
			if(pushResult) {
				wrapper.set(OutRmatSettleEntity::getBillPushFlag, BillPushStatusEnum.推送成功.getStatus());
			}else {
				logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.辅料中心租出合同结算单.getName(), billId);
				wrapper.set(OutRmatSettleEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
			}
		}
		service.update(wrapper);
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		OutRmatSettleEntity entity = service.selectById(billId);

		LambdaQueryWrapper<OutRmatSettleEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(OutRmatSettleEntity::getContractId, entity.getContractId());
		wrapper.orderByDesc(OutRmatSettleEntity::getCreateTime);
		List<OutRmatSettleEntity> list = service.list(wrapper);

		long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
		if (count > 0) {
			throw new BusinessException("当前单据存在非审批通过的单据，不能撤回/弃审！");
		}

		if (ListUtil.isNotEmpty(list)) {
			if (!Objects.equals(list.get(0).getId(), billId)) {
				throw new BusinessException("只能撤回/弃审最新一期的结算单！");
			}
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		
		// 结算单是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		OutRmatSettleEntity entity = service.selectById(billId);
		
		// 回写合同状态
		LambdaUpdateWrapper<OutRmatContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(OutRmatContractEntity::getPerformanceStatus, PerformanceStatusEnum.履约中.getCode());
		updateWrapper.eq(OutRmatContractEntity::getId, entity.getContractId());
		outRmatContractService.update(updateWrapper);
		
		// 回写引用单据结算状态
		writeSettleFlag(entity, 0);

		// 将推送至供方的单据作废
		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(entity.getRentType())){
			if (BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
				boolean pushResult = service.delPushBill(entity);
				if (!pushResult) {
					return CommonResponse.error("弃审前回调失败，单据作废协同服务失败！");
				} else {
					entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
					service.saveOrUpdate(entity, false);
				}
			}
		}
		service.saveOrUpdate(entity);
		
		return CommonResponse.success();
	}
	
	public void writeSettleFlag(OutRmatSettleEntity entity, Integer settleFlag) {
		// 回写租金计算单结算状态
		List<Long> leaseIdsList = new ArrayList<>();
		List<OutRmatSettleLeaseEntity> leaseList = entity.getLeaseList();
		if (ListUtil.isNotEmpty(leaseList)) {
			leaseIdsList.addAll(leaseList.stream().map(OutRmatSettleLeaseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(leaseIdsList)) {
//			LambdaUpdateWrapper<RentCalculateEntity> leaseWrapper = new LambdaUpdateWrapper<>();
//			leaseWrapper.set(RentCalculateEntity::getSettleFlag, settleFlag);
//			leaseWrapper.in(RentCalculateEntity::getId, leaseIdsList);
//			calculateService.update(leaseWrapper);
		}

		// 回写退赔单、结算单 结算状态
		List<Long> restituteIdsList = new ArrayList<>();
		List<OutRmatSettleRepairEntity> repairList = entity.getRepairList();
		if (ListUtil.isNotEmpty(repairList)) {
			restituteIdsList.addAll(repairList.stream().map(OutRmatSettleRepairEntity::getSourceId).collect(Collectors.toList()));
		}
		List<OutRmatSettleScrapEntity> scrapList = entity.getScrapList();
		if (ListUtil.isNotEmpty(scrapList)) {
			restituteIdsList.addAll(scrapList.stream().map(OutRmatSettleScrapEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(restituteIdsList)) {
			LambdaUpdateWrapper<OutRmatRestituteEntity> restituteWrapper = new LambdaUpdateWrapper<>();
			restituteWrapper.set(OutRmatRestituteEntity::getSettleFlag, settleFlag);
			restituteWrapper.in(OutRmatRestituteEntity::getId, restituteIdsList);
			outRmatRestituteService.update(restituteWrapper);
		}

		// 回写遗失单结算状态
		List<OutRmatSettleLoseEntity> loseList = entity.getLoseList();
		List<Long> loseIdsList = new ArrayList<>();
		if (ListUtil.isNotEmpty(loseList)) {
			loseIdsList.addAll(loseList.stream().map(OutRmatSettleLoseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(loseIdsList)) {
			LambdaUpdateWrapper<OutRmatLoseEntity> loseWrapper = new LambdaUpdateWrapper<>();
			loseWrapper.set(OutRmatLoseEntity::getSettleFlag, settleFlag);
			loseWrapper.in(OutRmatLoseEntity::getId, loseIdsList);
			outRmatLoseService.update(loseWrapper);
		}
		
	}
	
}
