package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.consts.FlowTypeEnum;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.mapper.RmatFlowMapper;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.vo.RmatFlowVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseDetailEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.controller.OutRmatLoseController;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.start.bean.OutRmatStartDetailEntity;
import com.ejianc.business.outrmat.start.bean.OutRmatStartEntity;
import com.ejianc.business.outrmat.start.vo.OutRmatStartDetailVO;
import com.ejianc.business.outrmat.start.vo.OutRmatStartVO;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopDetailEntity;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.stop.vo.OutRmatStopDetailVO;
import com.ejianc.business.outrmat.stop.vo.OutRmatStopVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租赁流水表
 * 
 * @author generator
 * 
 */
@Service("rmatFlowService")
public class RmatFlowServiceImpl extends BaseServiceImpl<RmatFlowMapper, RmatFlowEntity> implements IRmatFlowService{

    @Override
    public Boolean insertFlow(List<RmatFlowVO> vos) {
        List<RmatFlowVO> addList = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for(RmatFlowVO vo : vos){
            vo.setId(vo.getSourceDetailId());// 默认主键为子表主键
            if(!"del".equals(vo.getRowState())){
                addList.add(vo);
            } else {
                delIds.add(vo.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(addList)){
            List<RmatFlowEntity> list = BeanMapper.mapList(addList, RmatFlowEntity.class);
            super.saveOrUpdateBatch(list);
        }
        if(CollectionUtils.isNotEmpty(delIds)){
            super.removeByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertCheckFlow(CheckEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<CheckDetailEntity> detailList = entity.getCheckDetailList();
        for(CheckDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 上级组织作为仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getCheckDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.验收.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getCheckNumsSum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }
//租出出库
    @Override
    public Boolean insertCheckFlow(OutRmatDeliveryEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<OutRmatDeliveryDetailEntity> detailList = entity.getOutRmatDeliveryDetailList();
        for(OutRmatDeliveryDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            if(null==entity.getStoreId()){
                vo.setStoreId(entity.getParentOrgId());// 仓库
            }else {
                vo.setStoreId(entity.getStoreId());// 仓库
            }
            if(null==entity.getStoreName()){
                vo.setStoreName(entity.getParentOrgName());
            }else {
                vo.setStoreName(entity.getStoreName());
            }
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getRentId());// 供应商
            vo.setSupplierName(entity.getRentName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getOutstoreDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.验收.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getCalculateUnitId());// 主单位
            vo.setUnitName(detail.getCalculateUnitName());
            vo.setNum(detail.getCalculateNum());// 主数量
            vo.setAssistUnitId(detail.getRentUnitId());// 辅单位
            vo.setAssistUnitName(detail.getRentUnitName());
            vo.setAssistNum(detail.getRentNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(String.valueOf(detail.getRentCalculationType()));// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(entity.getRentType()));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            vo.setSourceType(entity.getSourceType());
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for(StopDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.停用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));// 停用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    //租出停用单
    @Override
    public Boolean insertOutRmatStopFlow(OutRmatStopEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<OutRmatStopDetailEntity> detailList = entity.getDetailList();
        for(OutRmatStopDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            if(null==detail.getStoreId()){
                vo.setStoreId(entity.getParentOrgId());// 仓库
            }else {
                vo.setStoreId(detail.getStoreId());// 仓库
            }
            if(null==detail.getStoreName()){
                vo.setStoreName(entity.getParentOrgName());
            }else {
                vo.setStoreName(detail.getStoreName());
            }
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.停用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));// 停用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(entity.getRentType());// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }


    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StartDetailEntity> detailList = entity.getDetailList();
        for(StartDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStartTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.启用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    //租出启用单
    @Override
    public Boolean insertOutRmatStartFlow(OutRmatStartEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<OutRmatStartDetailEntity> detailList = entity.getDetailList();
        for(OutRmatStartDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            if(null==detail.getStoreId()){
                vo.setStoreId(entity.getParentOrgId());// 仓库
            }else {
                vo.setStoreId(detail.getStoreId());// 仓库
            }
            if(null==detail.getStoreName()){
                vo.setStoreName(entity.getParentOrgName());
            }else {
                vo.setStoreName(detail.getStoreName());
            }
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStartTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.启用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(entity.getRentType());// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertRestFlow(RestituteEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<RestituteDetailEntity> detailList = entity.getRestituteDetailList();
        for(RestituteDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.退赔.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum()));// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }
//租出退赔
    @Override
    public Boolean insertRestFlow(OutRmatRestituteEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<OutRmatRestituteDetailEntity> detailList = entity.getRestituteDetailList();
        for(OutRmatRestituteDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            if(null==detail.getStoreId()){
                vo.setStoreId(entity.getParentOrgId());// 仓库
            }else {
                vo.setStoreId(detail.getStoreId());// 仓库
            }
            if(null==detail.getStoreName()){
                vo.setStoreName(entity.getParentOrgName());
            }else {
                vo.setStoreName(detail.getStoreName());
            }
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.退赔.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(ComputeUtil.safeSub(detail.getNumM(),ComputeUtil.safeDiv(detail.getScrapNum(), detail.getTransScale())) );// 主数量 完好+维修
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum()));// 辅数量  完好+维修
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(entity.getRentType());// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            vo.setSourceType(vo.getSourceType());// 材料来源,0-自购,1-租赁，为空的租赁，不为空的租出
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertLoseFlow(LoseEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<LoseDetailEntity> detailList = entity.getLoseDetailList();
        for(LoseDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.遗失.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getLoseNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }
    //租出遗失
    @Override
    public Boolean insertLoseFlow(OutRmatLoseEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<OutRmatLoseDetailEntity> detailList = entity.getLoseDetailList();
        for(OutRmatLoseDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            if(null==detail.getStoreId()){
                vo.setStoreId(entity.getParentOrgId());// 仓库
            }else {
                vo.setStoreId(detail.getStoreId());// 仓库
            }
            if(null==detail.getStoreName()){
                vo.setStoreName(entity.getParentOrgName());
            }else {
                vo.setStoreName(detail.getStoreName());
            }
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.遗失.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getLoseNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(entity.getRentType());// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            vo.setSourceType(vo.getSourceType());// 材料来源,0-自购,1-租赁，为空的租赁，不为空的租出
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in("source_id", sourceIds);
        ew.eq("bill_type_code", billTypeCode);
        return super.remove(ew);
    }


}
