package com.ejianc.business.outrmat.delivery.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.mapper.MaterialMapper;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.enums.SignStatusEnum;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryDetailService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import com.ejianc.business.outrmat.order.service.impl.OutRmatOrderDeliveryServiceImpl;
import com.ejianc.business.outrmat.proxy.bean.ProxyContractEntity;
import com.ejianc.business.outrmat.proxy.service.IProxyContractService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.omg.CORBA.portable.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;

import static org.codehaus.groovy.runtime.DefaultGroovyMethods.collect;

/**
 * out-出库单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatDelivery")
public class OutRmatDeliveryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "out-rmat-delivery";//此处需要根据实际修改

    @Autowired
    private IOutRmatDeliveryService service;
    @Autowired
    private IOutRmatOrderDeliveryService outRmatOrderDeliveryService;
    @Autowired
    private IOutRmatDeliveryDetailService outRmatDeliveryDetailService;


    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProxyContractService proxyContractService;
    @Autowired
    private IRmatFlowService flowService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatDeliveryVO> saveOrUpdate(@RequestBody OutRmatDeliveryVO saveOrUpdateVO) {
        // 校验必须大于最大单据日期
        service.validateTime(saveOrUpdateVO);
    	OutRmatDeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatDeliveryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //库存可用数量：取计租数量，根据库存的计量数量X转换系数  实时计算；如没有转换系数，显示【未设置转换系数】，如子表存在材料未设置转换系数，单据不可保存；
        List<OutRmatDeliveryDetailEntity> delDetail  = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entity.getOutRmatDeliveryDetailList())){
            List<OutRmatDeliveryDetailEntity> outRmatDeliveryDetailList = entity.getOutRmatDeliveryDetailList();
            delDetail = outRmatDeliveryDetailList.stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
            if(null==delDetail){
                delDetail  = new ArrayList<>();
            }
            outRmatOrderDeliveryService.delete(delDetail,null);//订单删除回写
            boolean b = outRmatDeliveryDetailList.stream().anyMatch(e -> e.getTransScale() == null);
            if (b){
                throw new BusinessException("部分材料未设置转换系数,不能保存");
            }
        }
        entity.setSupplierSignStatus(SignStatusEnum.未签字.getCode());
    	//设置委托代理人id
        if(null!=entity.getProxyContractId()){
            ProxyContractEntity proxyContractEntity = proxyContractService.selectById(entity.getProxyContractId());
            entity.setProxyEmployeeId(proxyContractEntity.getProxyEmployeeId());
            entity.setProxyEmployeeName(proxyContractEntity.getProxyEmployeeName());
        }
    	service.saveOrUpdate(entity, false);
    	//订单新增修改回写
        outRmatOrderDeliveryService.saveOrUpdate(entity.getOutRmatDeliveryDetailList(),entity.getContractId());
        OutRmatDeliveryEntity map = BeanMapper.map(entity, OutRmatDeliveryEntity.class);
        map.getOutRmatDeliveryDetailList().addAll(delDetail);
        logger.info("流水数据："+JSONObject.toJSONString(map));
        if(!flowService.insertCheckFlow(map, BillTypeEnum.租出出库单.getCode(), RmatCommonConsts.NO)){
            return CommonResponse.error("审批回调失败，单据推送流水失败！");
        }

    	OutRmatDeliveryVO vo = BeanMapper.map(entity, OutRmatDeliveryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatDeliveryVO> queryDetail(Long id) {
    	OutRmatDeliveryEntity entity = service.selectById(id);
    	OutRmatDeliveryVO vo = BeanMapper.map(entity, OutRmatDeliveryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatDeliveryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatDeliveryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        //回写订单
        List<Long> ids = vos.stream().map(OutRmatDeliveryVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<OutRmatDeliveryDetailEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.in(OutRmatDeliveryDetailEntity::getDeliveryId, ids);
        List<OutRmatDeliveryDetailEntity> outRmatDeliveryDetailEntities = outRmatDeliveryDetailService.list(listWrapper);
        outRmatOrderDeliveryService.delete(outRmatDeliveryDetailEntities,null);
        // 删除流水
        if(!flowService.delFlow(ids, BillTypeEnum.租出出库单.getCode())){
            throw new BusinessException("单据删除流水失败！");
        }
        service.removeByIds(vos.stream().map(OutRmatDeliveryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRmatDeliveryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        param.getParams().put("org_id",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutRmatDeliveryEntity> page = service.queryPage(param,false);
        IPage<OutRmatDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatDeliveryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("rentName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutRmatDeliveryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OutRmatDeliveryVO> outRmatDeliveryVOS = BeanMapper.mapList(list, OutRmatDeliveryVO.class);
        if (CollectionUtils.isNotEmpty(list)) {
            outRmatDeliveryVOS = BeanMapper.mapList(list, OutRmatDeliveryVO.class);
            outRmatDeliveryVOS.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
//                入库方式，0-收料入库，1-直入直出
                vo.setRentTypeName((vo.getRentType() == 0 ? "外租" : "内租"));
                vo.setSupplierSignStatusName(((null==vo.getSupplierSignStatus() || vo.getSupplierSignStatus() == 0 )? "未签字" : "已签字"));
            });
        }

        beans.put("records", outRmatDeliveryVOS);
        ExcelExport.getInstance().export("outRmatDelivery-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutRmatDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatDeliveryVO>> refOutRmatDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutRmatDeliveryEntity> page = service.queryPage(param,false);
        IPage<OutRmatDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatDeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
