/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.OwnEntity;
import com.ejianc.business.assist.material.service.IOwnService;
import com.ejianc.business.assist.material.vo.OwnDetailVO;
import com.ejianc.business.assist.material.vo.OwnVO;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="own")
public class OwnBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IOwnService ownService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OwnVO ownVO = this.ownService.queryDetail(billId);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(OwnEntity::getEffectTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.ownService.update((Wrapper)lambd);
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getOrgId());
        vo.setOutEffectiveON(Boolean.valueOf(true));
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        try {
            lastShareDate = sdf.parse(ownVO.getAmortizationCycle());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty((Collection)ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);
        CommonResponse<StoreManageVO> commonResponse = this.storeManageService.updateShareMny(vo);
        this.logger.info("\u66f4\u65b0\u644a\u9500\u91d1\u989d\u5ba1\u6279\u901a\u8fc7\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString(commonResponse));
        if (commonResponse.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OwnVO ownVO = this.ownService.queryDetail(billId);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(OwnEntity::getEffectTime, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.ownService.update((Wrapper)lambd);
        StoreManageVO vo = new StoreManageVO();
        vo.setStoreId(ownVO.getOrgId());
        vo.setOutEffectiveON(Boolean.valueOf(false));
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        String lastAmortizationCycle = this.ownService.getLastAmortizationCycle(ownVO.getProjectId(), ownVO.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date lastShareDate = null;
        if (lastAmortizationCycle != null && lastAmortizationCycle.length() > 0) {
            try {
                lastShareDate = sdf.parse(lastAmortizationCycle);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ownVO.getOwnDetailList())) {
            for (OwnDetailVO detailVO : ownVO.getOwnDetailList()) {
                FlowVO flowVO = new FlowVO();
                flowVO.setSourceId(detailVO.getFlowSourceId());
                flowVO.setSourceDetailId(detailVO.getFlowSourceDetailId());
                flowVO.setShareMny(detailVO.getAmortizationMny());
                flowVO.setShareTaxMny(detailVO.getAmortizationMnyTax());
                flowVO.setLastShareDate(lastShareDate);
                flowVOList.add(flowVO);
            }
        }
        vo.setFlowVOList(flowVOList);
        CommonResponse<StoreManageVO> commonResponse = this.storeManageService.updateShareMny(vo);
        if (commonResponse.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

