/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.calculate.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRmatCalculate"})
public class OutRmatCalculateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutRmatCalculateService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> saveOrUpdate(@RequestBody OutRmatCalculateVO saveOrUpdateVO) {
        OutRmatCalculateVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> queryDetail(Long id) {
        OutRmatCalculateEntity entity = (OutRmatCalculateEntity)((Object)this.service.selectById(id));
        OutRmatCalculateVO vo = (OutRmatCalculateVO)BeanMapper.map((Object)((Object)entity), OutRmatCalculateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatCalculateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRmatCalculateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatCalculateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, OutRmatCalculateVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            if (new Integer("0").equals(e.getSettleFlag())) {
                e.setSettleFlagName("\u672a\u7ed3\u7b97");
            } else if (new Integer("1").equals(e.getSettleFlag())) {
                e.setSettleFlagName("\u5df2\u7ed3\u7b97");
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("OutRmatCalculate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentCalculateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatCalculateVO>> refRentCalculateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("settleFlag", new Parameter("ne", (Object)"1"));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                projectId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("settleDate")) {
                String settleDate = conditionMap.get("settleDate").toString();
                if (null == conditionMap.get("lastSettleDate")) {
                    param.getParams().put("rent_date", new Parameter("le", (Object)settleDate));
                } else {
                    String lastSettleDate = conditionMap.get("lastSettleDate").toString();
                    param.getParams().put("rent_date", new Parameter("between", (Object)(lastSettleDate + "," + settleDate)));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatCalculateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/autoCalculate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> autoCalculate(@RequestBody OutRmatCalculateVO vo) {
        return CommonResponse.success((String)"\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u6210\u529f\uff01", (Object)this.service.automaticRental(vo));
    }
}

