package com.ejianc.business.outrmat.lose.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractDailyRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractMonthRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractNumRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseDetailEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.mapper.OutRmatLoseMapper;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.outrmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
@Service("outRmatLoseService")
public class OutRmatLoseServiceImpl extends BaseServiceImpl<OutRmatLoseMapper, OutRmatLoseEntity> implements IOutRmatLoseService {
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;

    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IReceiptsApi receiptsApi;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.租出遗失单.getCode();
    private static final String BILL_NAME = BillTypeEnum.租出遗失单.getName();

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FLZX_ZCYSD_CODE";//此处需要根据实际修改

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private IRmatFlowService flowService;

    @Override
    public List<StoreManageVO> getStoreManageVOList(OutRmatLoseVO vo , Boolean outEffectiveON) {
        List<StoreManageVO> storeManageVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(vo.getLoseDetailList())) {
            Map<Long, List<OutRmatLoseDetailVO>> detailMap = vo.getLoseDetailList().stream().filter(t->null!=t.getStoreId()).collect(Collectors.groupingBy(OutRmatLoseDetailVO::getStoreId));
            if(MapUtils.isNotEmpty(detailMap)){
                for (Long storeId : detailMap.keySet()) {//材料来源,0-自购,1-租赁
                    List<OutRmatLoseDetailVO> detailVOList = detailMap.get(storeId).stream().filter(t ->null!= t.getSourceType() && 0== t.getSourceType() ).collect(Collectors.toList());
                    //调用库存
                    if(CollectionUtils.isNotEmpty(detailVOList)){
                        StoreManageVO storeManageVO = new StoreManageVO();
                        storeManageVO.setStoreId(storeId);
                        storeManageVO.setSourceId(vo.getId());
                        storeManageVO.setInOutTypeEnum(InOutTypeEnum.辅料中心租出遗失);
                        storeManageVO.setOutEffectiveON(outEffectiveON);
                        ArrayList<FlowVO> flowVOS = new ArrayList<>();
                        //删除的数据
                        detailVOList.forEach(t->{
                            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.辅料中心租出遗失, 0);
                            flowVO.setStoreId(t.getStoreId());
                            flowVO.setStoreName(t.getStoreName());
                            flowVO.setProjectId(vo.getProjectId());
                            flowVO.setProjectName(vo.getProjectName());
                            flowVO.setOrgId(vo.getOrgId());
                            flowVO.setOrgName(vo.getOrgName());
                            flowVO.setParentOrgId(vo.getParentOrgId());
                            flowVO.setParentOrgName(vo.getParentOrgName());
                            flowVO.setEmployeeId(vo.getEmployeeId());
                            flowVO.setEmployeeName(vo.getEmployeeName());
                            flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                            flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                            flowVO.setMaterialId(t.getMaterialId());
                            flowVO.setMaterialName(t.getMaterialName());
                            flowVO.setMaterialSpec(t.getSpec());
                            flowVO.setMaterialUnitId(t.getUnitMId());
                            flowVO.setMaterialUnitName(t.getUnitMName());
                            flowVO.setSourceBillDetailRemark(t.getMemo());
                            flowVO.setTaxPrice(BigDecimal.ZERO);
                            flowVO.setPrice(BigDecimal.ZERO);
                            flowVO.setNum(t.getNumM());
                            flowVO.setTaxMny(BigDecimal.ZERO);
                            flowVO.setMny(BigDecimal.ZERO);
                            flowVO.setTax(BigDecimal.ZERO);

                            flowVO.setTenantId(t.getTenantId());
                            flowVO.setSourceId(vo.getId());
                            flowVO.setSourceDetailId(t.getId());
                            flowVO.setSourceBillCode(vo.getBillCode());
                            flowVO.setSourceBillDate(vo.getBillDate());
                            flowVO.setRowState(t.getRowState());
                            flowVO.setSourceBillRemark(vo.getMemo());
//                                flowVO.setPurchasePrice(t.getOriginalValuePrice());
//                                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                            flowVOS.add(flowVO);
                        });
                        storeManageVO.setFlowVOList(flowVOS);
                        storeManageVOList.add(storeManageVO);
                    }
                }
            }
        }
        return storeManageVOList;
    }

    @Override
    public OutRmatLoseVO saveOrUpdate(OutRmatLoseVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        outRmatMaterialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), OutRmatConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, OutRmatConstant.保存);
        validateNum(saveOrUpdateVO);
        OutRmatLoseEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatLoseEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 汇总材料分类
        List<OutRmatLoseDetailVO> detailList = saveOrUpdateVO.getLoseDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        boolean b = super.saveOrUpdate(entity, false);
        // 推送流水未生效
        OutRmatLoseVO map = BeanMapper.map(entity, OutRmatLoseVO.class);
        List<OutRmatLoseDetailVO> detailVOS = saveOrUpdateVO.getLoseDetailList().stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(detailVOS)){
            map.getLoseDetailList().addAll(detailVOS);
        }
        if(!flowService.insertLoseFlow(BeanMapper.map(map,OutRmatLoseEntity.class), BillTypeEnum.租出遗失单.getCode(), RmatCommonConsts.NO)){
            throw new BusinessException("单据推送流水失败！");
        }
        //材料来源为自购 推送库存未生效
        if (b) {
            List<StoreManageVO> storeManageVOList = getStoreManageVOList(map, false);
            if(CollectionUtils.isNotEmpty(storeManageVOList)){
                logger.info("库存所有入参："+JSONObject.toJSONString(storeManageVOList));
                for (StoreManageVO storeManageVO : storeManageVOList) {
                    logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
                    CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
                    if(!response.isSuccess()) {
                        throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                    }
                }
            }
        }
        OutRmatLoseVO vo = BeanMapper.map(entity, OutRmatLoseVO.class);
        return vo;
    }

    @Override
    public void delete(List<OutRmatLoseVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatLoseVO vo : vos) {
                OutRmatLoseEntity outRmatLoseEntity = super.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(outRmatLoseEntity.getLoseDetailList())){
                    Map<Long, List<OutRmatLoseDetailEntity>> detailMap = outRmatLoseEntity.getLoseDetailList().stream().filter(t->null!=t.getStoreId()).collect(Collectors.groupingBy(OutRmatLoseDetailEntity::getStoreId));
                    if(MapUtils.isNotEmpty(detailMap)) {
                        for (Long storeId : detailMap.keySet()) {//材料来源,0-自购,1-租赁
                            List<OutRmatLoseDetailEntity> detailVOList = detailMap.get(storeId).stream().filter(t -> null!= t.getSourceType() && 0== t.getSourceType() ).collect(Collectors.toList());
                            //调用库存
                            if (CollectionUtils.isNotEmpty(detailVOList)) {
                                StoreManageVO storeManageVO = new StoreManageVO();
                                storeManageVO.setStoreId(storeId);
                                storeManageVO.setSourceId(outRmatLoseEntity.getId());
                                storeManageVO.setInOutTypeEnum(InOutTypeEnum.辅料中心租出遗失);
                                storeManageVO.setOutEffectiveON(false);
                                ArrayList<Long> longs = new ArrayList<>();
                                longs.add(outRmatLoseEntity.getId());
                                storeManageVO.setSourceIdsForRollBack(longs);
                                logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
                                CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
                                if(!response.isSuccess()) {
                                    throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                                }

                            }
                        }
                    }
                }
            }
        }
        List<Long> ids = vos.stream().map(OutRmatLoseVO::getId).collect(Collectors.toList());
        //   删除流水
        if(!flowService.delFlow(ids, BillTypeEnum.租出遗失单.getCode())){
            throw new BusinessException("单据删除流水失败！");
        }
        super.removeByIds(ids,true);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatLoseEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param  outRmatLoseVO
     * @return
     */
    @Override
    public String validateTime(OutRmatLoseVO outRmatLoseVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", outRmatLoseVO.getContractId());
        if(outRmatLoseVO.getId() != null){
            params.put("billType", BILL_NAME);
            params.put("billId", outRmatLoseVO.getId());
        }
        Date lastDate = outRmatMaterialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = outRmatMaterialService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(outRmatLoseVO.getStopDate(), lastDate, maxTimeMap,outRmatLoseVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(outRmatLoseVO.getStopDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatLoseEntity entity) {
        CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(entity), ReceiptsEnum.遗失单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(Map<String,String> map) {
        String billId = map.get("billId");
        OutRmatLoseEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutRmatLoseEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatLoseEntity entity) {
        CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.遗失单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    /**
     * 校验数量不能大于可参照数量
     * @param outRmatLoseVO
     * @return
     */
    private String validateNum(OutRmatLoseVO outRmatLoseVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, outRmatLoseVO.getContractId()));
        List<MaterialVO> list = outRmatMaterialService.queryCheckList(param, "lose");
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getUseStatus() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        for(OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()){
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
            if(map.containsKey(key) && vo.getLoseNum().compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }

}
