package com.ejianc.business.assist.store.controller.api;

import com.ejianc.business.assist.store.service.IAllotInService;
import com.ejianc.business.assist.store.service.IAllotOutService;

import com.ejianc.business.assist.store.vo.AllotInVO;
import com.ejianc.business.assist.store.vo.AllotOutVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 调拨出入库api
 */

@RestController()
@RequestMapping("/api/amAllot/")
public class AmAllotApi {

    @Autowired
    private IAllotOutService outService;

    @Autowired
    private IAllotInService inService;

    @PostMapping("amCreateAllotIn")
    public CommonResponse<String> amCreateAllotIn(@RequestBody AllotOutVO allotOutVO){
        String allotIn = outService.amCreateAllotIn(allotOutVO);
        return CommonResponse.success(allotIn);
    }

    @PostMapping("amSureToReceive")
    public CommonResponse<String> amSureToReceive(@RequestBody AllotInVO allotInVO){
        String allotIn = inService.amSureToReceive(allotInVO);
        return CommonResponse.success(allotIn);
    }

    @PostMapping("amSureToReturn")
    public CommonResponse<String> amSureToReturn(@RequestBody AllotInVO allotInVO){
        String allotIn = inService.amSureToReturn(allotInVO);
        return CommonResponse.success(allotIn);
    }

}
