package com.ejianc.business.assist.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.material.vo.record.MaterialSupplementRecordVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 辅料中心采购合同
 * 
 * @author generator
 * 
 */
public interface IMaterialContractService extends IBaseService<MaterialContractEntity> {

    MaterialContractVO saveOrUpdate(MaterialContractVO saveOrUpdateVO,String authority);

    MaterialContractVO queryDetail(Long id);

    String delete(List<MaterialContractVO> vos);

    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    Boolean pushContract(MaterialContractVO vo);

    Boolean delContractFromPool(Long id);
    
    String validateContract(Long contractId, String billType, Long billId, String type);

    MaterialSupplementRecordVO querySupplementRecord(Long id);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

}
