package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.store.bean.PickReturnEntity;
import com.ejianc.business.assist.store.mapper.PickReturnMapper;
import com.ejianc.business.assist.store.service.IPickReturnService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.PickReturnVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
@Service("pickReturnService")
public class PickReturnServiceImpl extends BaseServiceImpl<PickReturnMapper, PickReturnEntity> implements IPickReturnService{

    @Autowired
    private PickReturnMapper pickReturnMapper;

    @Autowired
    private StoreManageService storeManageService;

    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity entity = pickReturnMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }
}
