package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.store.bean.ReturnGoodsEntity;
import com.ejianc.business.assist.store.mapper.ReturnGoodsMapper;
import com.ejianc.business.assist.store.service.IReturnGoodsService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.ReturnGoodsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 材料退货表
 * 
 * @author generator
 * 
 */
@Service("returnGoodsService")
public class ReturnGoodsServiceImpl extends BaseServiceImpl<ReturnGoodsMapper, ReturnGoodsEntity> implements IReturnGoodsService{

    @Autowired
    private ReturnGoodsMapper returnGoodsMapper;
    @Autowired
    private StoreManageService storeManageService;

    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public ReturnGoodsVO queryByContractId(Long contractId) {
        ReturnGoodsVO resp = null;
        QueryWrapper<ReturnGoodsEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ReturnGoodsEntity entity = returnGoodsMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, ReturnGoodsVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }
}
