package com.ejianc.business.outrmat.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IClauseSettingApi;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractClauseEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractClauseService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractClauseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同-合同条款
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatContractClause")
public class OutRmatContractClauseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOutRmatContractClauseService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IClauseSettingApi clauseSettingApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatContractClauseVO> saveOrUpdate(@RequestBody OutRmatContractClauseVO saveOrUpdateVO) {
    	OutRmatContractClauseEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatContractClauseEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OutRmatContractClauseVO vo = BeanMapper.map(entity, OutRmatContractClauseVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatContractClauseVO> queryDetail(Long id) {
    	OutRmatContractClauseEntity entity = service.selectById(id);
    	OutRmatContractClauseVO vo = BeanMapper.map(entity, OutRmatContractClauseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatContractClauseVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRmatContractClauseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutRmatContractClauseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractClauseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

       

        IPage<OutRmatContractClauseEntity> page = service.queryPage(param,false);
        IPage<OutRmatContractClauseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatContractClauseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据合同分类属性查询合同下条款列表信息
     *
     * @return
     */
    @GetMapping("getContractClauses")
    @ResponseBody
    public CommonResponse<JSONObject> getContractClauses() {
        JSONObject resp = new JSONObject();
        List<JSONObject> attrs = new ArrayList<>();
        resp.put("bo_code", "ContractClause");
        resp.put("bo_name", "合同条款");
        resp.put("bo_attrs", attrs);

        CommonResponse<List<ClauseSettingVO>> clauseResp = clauseSettingApi.getListByCategoryProperty("arriRmat");

        if(!clauseResp.isSuccess()) {
            logger.error("查询合同条款列表失败, {} ", clauseResp.getMsg());
            return CommonResponse.error("查询合同条款列表失败！");
        }else {
            logger.info("查询合同条款列表成功");
        }
        
        List<ClauseSettingVO> clauseList = clauseResp.getData();
        JSONObject tmp = null;
        for(ClauseSettingVO clause : clauseList) {
            tmp = new JSONObject();
            tmp.put("id", clause.getId());
            tmp.put("code", "::clauseNameId$clauseContent$"+clause.getId());
            tmp.put("fieldname", "::clauseNameId$clauseContent$"+clause.getId());
            tmp.put("clauseCode", clause.getCode());
            tmp.put("name", clause.getClauseName());
            tmp.put("type", "attr");
            tmp.put("fieldtype", "text");

            attrs.add(tmp);
        }
        return CommonResponse.success("查询成功！", resp);
    }
    
    
}
