package com.ejianc.business.outrmat.order.service;

import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;

import java.util.List;

/**
 * 租出订单-发货流水表
 * 
 * @author generator
 * 
 */
public interface IOutRmatOrderDeliveryService extends IBaseService<OutRmatOrderDeliveryEntity> {

    /**
     * 发货占用/释放订单接口  保存之前调用
     *  @param  detailVOS 出库占用的子表/释放 明细id:必有
     *  @param  contractId:合同id
     * @return 保存结果
     */
    void saveOrUpdate(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId);
    void delete(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId);
}
