package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.store.bean.AllotInDetailEntity;
import com.ejianc.business.assist.store.bean.AllotInEntity;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocatEnum;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.NoticeEnum;
import com.ejianc.business.assist.store.mapper.AllotOutMapper;
import com.ejianc.business.assist.store.service.AllotInMessageService;
import com.ejianc.business.assist.store.service.IAllotInService;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调拨出库
 *
 * @author generator
 */
@Service("allotOutService")
public class AllotOutServiceImpl extends BaseServiceImpl<AllotOutMapper, AllotOutEntity> implements IAllotOutService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String NOT_CHANGE = "材料出库明细数量没有变化,仓库无需处理!";

    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_ALLOT_OUT";//此处需要根据实际修改
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAllotInService allotInService;
    @Autowired
    private AllotInMessageService allotInMessageService;
    private static final String IN_BILL_CODE = "STORE_ALLOT_IN";//此处需要根据实际修改



    @Override
    public CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
        CommonResponse<StoreManageVO> commonResponse = storeManageService.turnSurplusMaterialPrice(storeManageVO);

        if (commonResponse.isSuccess()&&commonResponse.getData()!=null){
            return CommonResponse.success("原值单价、净值金额获取成功",commonResponse.getData().getUseMaterialPriceVOList().get(0));
        }
        if (NOT_CHANGE.equals(commonResponse.getMsg())){
            return CommonResponse.success();
        }
        return CommonResponse.error(commonResponse.getMsg());
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {

        //保存修改
        AllotOutEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOutEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean b = service.saveOrUpdate(entity, false);
        ////生成出库流水 生成
        if (b) {
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
                //调用库存
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨出库);
                storeManageVO.setOutEffectiveON(false);
                ArrayList<FlowVO> flowVOS = new ArrayList<>();
                //删除的数据
                saveOrUpdateVO.getAllotOutDetailList().forEach(t->{
                    if("del".equals(t.getRowState())){
                        FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库, 0);
                        flowVO.setStoreId(entity.getStoreId());
                        flowVO.setStoreName(entity.getStoreName());
                        flowVO.setProjectId(entity.getProjectId());
                        flowVO.setProjectName(entity.getProjectName());
                        flowVO.setOrgId(entity.getOrgId());
                        flowVO.setOrgName(entity.getOrgName());
                        flowVO.setParentOrgId(entity.getParentOrgId());
                        flowVO.setParentOrgName(entity.getParentOrgName());
                        flowVO.setEmployeeId(entity.getEmployeeId());
                        flowVO.setEmployeeName(entity.getEmployeeName());
                        flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                        flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                        flowVO.setMaterialId(t.getMaterialId());
                        flowVO.setMaterialName(t.getMaterialName());
                        flowVO.setMaterialCode(t.getMaterialCode());
                        flowVO.setMaterialSpec(t.getMaterialSpec());
                        flowVO.setMaterialUnitId(t.getMaterialUnitId());
                        flowVO.setMaterialUnitName(t.getMaterialUnit());
                        flowVO.setSourceBillDetailRemark(t.getMemo());
                        flowVO.setTaxPrice(t.getAllocatTaxPrice());
                        flowVO.setPrice(t.getAllocatPrice());
                        flowVO.setNum(t.getAllocatNum());
                        flowVO.setTaxMny(t.getAllocatTaxMny());
                        flowVO.setMny(t.getAllocatMny());
                        flowVO.setTax(t.getAllocatTax());

                        flowVO.setTenantId(t.getTenantId());
                        flowVO.setSourceId(entity.getId());
                        flowVO.setSourceDetailId(t.getId());
                        flowVO.setSourceBillCode(entity.getBillCode());
                        flowVO.setSourceBillDate(entity.getOutDate());
                        flowVO.setRowState(t.getRowState());
                        flowVO.setSourceBillRemark(entity.getMemo());
                        flowVO.setPurchasePrice(t.getOriginalValuePrice());
                        flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                        flowVOS.add(flowVO);
                    }
                });
                //新增修改的数据
                entity.getAllotOutDetailList().forEach(t->{
                    FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库,0);
                    flowVO.setStoreId(entity.getStoreId());
                    flowVO.setStoreName(entity.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialCode(t.getMaterialCode());
                    flowVO.setMaterialSpec(t.getMaterialSpec());
                    flowVO.setMaterialUnitId(t.getMaterialUnitId());
                    flowVO.setMaterialUnitName(t.getMaterialUnit());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getAllocatTaxPrice());
                    flowVO.setPrice(t.getAllocatPrice());
                    flowVO.setNum(t.getAllocatNum());
                    flowVO.setTaxMny(t.getAllocatTaxMny());
                    flowVO.setMny(t.getAllocatMny());
                    flowVO.setTax(t.getAllocatTax());

                    flowVO.setTenantId(t.getTenantId());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getOutDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getMemo());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                });
                storeManageVO.setFlowVOList(flowVOS);

                CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
                if(!response.isSuccess()) {
                    throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                }
            }
        }
        AllotOutVO vo = BeanMapper.map(entity, AllotOutVO.class);
        return CommonResponse.success("保存修改成功", vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {

        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = service.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(allotOutEntity.getStoreId());
                    storeManageVO.setSourceId(allotOutEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨出库);
                    storeManageVO.setOutEffectiveON(false);
                    ArrayList<Long> longs = new ArrayList<>();
                    longs.add(allotOutEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
                    if(!response.isSuccess()) {
                        throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
                    }
                }
            }
        }

        boolean b = service.removeByIds(vos.stream().map(AllotOutVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotOutEntity> list = service.queryList(param);
        List<AllotOutExportVO> allotOutVos = BeanMapper.mapList(list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }

    @Override
    public String amCreateAllotIn(AllotOutVO allotOutVO){

        AllotOutEntity allotOutEntity = BeanMapper.map(allotOutVO,AllotOutEntity.class);

        //生成调拨入库
        AllotInEntity allotInEntity = new AllotInEntity();
        allotInEntity.setInUnitName(allotOutEntity.getInUnitName()); //调入单位名称呼
        //出库信息
        allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
        allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
        allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
        allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
        allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
        //入库信息
        allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
        allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
        allotInEntity.setStoreId(allotOutEntity.getInStoreId());
        allotInEntity.setStoreName(allotOutEntity.getInStoreName());
        allotInEntity.setProjectId(allotOutEntity.getInProjectId());
        allotInEntity.setProjectName(allotOutEntity.getInProjectName());
        allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
        allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
        allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
        allotInEntity.setOrgId(allotOutEntity.getInOrgId());
        allotInEntity.setOrgName(allotOutEntity.getInOrgName());
        allotInEntity.setAllotOutId(allotOutEntity.getId());
        allotInEntity.setOutMny(allotOutEntity.getOutMny());
        allotInEntity.setOutDate(allotOutEntity.getOutDate());
        allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
        allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
        allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
        allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
        allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
        allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
        allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
        allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
        allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
        allotInEntity.setMemo(allotOutEntity.getMemo());
        allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
        allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
        long id = IdWorker.getId();
        if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
            List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
            allotInDetailEntitys.forEach(item->{
                item.setId(null);
                item.setAllocatId(id);
            });
            allotInEntity.setAllotInDetailList(allotInDetailEntitys);
            logger.info("子表信息："+allotInDetailEntitys.toString());
        }
        AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build(IN_BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            return "网络异常， 编码生成失败， 请稍后再试";
        }
        allotInEntity.setId(id);
        boolean b = allotInService.saveOrUpdate(allotInEntity,false);
        if (b){
            AllotInEntity allot = allotInService.selectById(id);
            if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){
                //通知收料人收料
                String[] notifyReceive = {String.valueOf(allot.getNotifyReceiverId())};
                allotInMessageService.sendMsg(allot,notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
            }
        }

        return null;
    }


}
