/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractFreezeEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractNumRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRelieveEntity;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.ChangeStatusEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SettleEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractChangeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFreezeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSupplementRecordVO;
import com.ejianc.business.outrmat.proxy.bean.ProxyContractEntity;
import com.ejianc.business.outrmat.proxy.service.IProxyContractService;
import com.ejianc.business.outrmat.utils.ListCallable;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.api.IPrormatContractApi;
import com.ejianc.business.pro.rmat.enums.ContractSyncTypeEnum;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="outRmatContractService")
public class OutRmatContractServiceImpl
extends BaseServiceImpl<OutRmatContractMapper, OutRmatContractEntity>
implements IOutRmatContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE_OUT = "OUT_RMAT_CONTRACT_OUT";
    private static final String BILL_CODE_IN = "OUT_RMAT_CONTRACT_IN";
    private static final String PURCHASE_CONTRACT_YNJT_OUT = "OUT_RMAT_CONTRACT_YNJT_OUT";
    private static final String PURCHASE_CONTRACT_YNJT_IN = "OUT_RMAT_CONTRACT_YNJT_IN";
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billDel";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITenderRmatApi tenderRmatApi;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IOutRmatContractService service;
    @Autowired
    private IOutRmatContractChangeService changeService;
    @Autowired
    private IOutRmatContractRelieveService relieveService;
    @Autowired
    private IOutRmatContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IProxyContractService proxyContractService;
    @Autowired
    private IPrormatContractApi prormatContractApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public OutRmatContractVO saveOrUpdate(OutRmatContractVO saveOrUpdateVO, String authority) {
        OutRmatContractEntity contract;
        OutRmatContractEntity entity;
        CommonResponse orgResponse;
        if (saveOrUpdateVO.getOrgId() != null && (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) || com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    saveOrUpdateVO.setParentOrgId(parentOrgVO.getId());
                    saveOrUpdateVO.setParentOrgCode(parentOrgVO.getCode());
                    saveOrUpdateVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                saveOrUpdateVO.setParentOrgId(saveOrUpdateVO.getOrgId());
                saveOrUpdateVO.setParentOrgCode(saveOrUpdateVO.getOrgCode());
                saveOrUpdateVO.setParentOrgName(saveOrUpdateVO.getOrgName());
            }
        }
        if ((entity = (OutRmatContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatContractEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            if (entity.getSupplementFlag() == 1) {
                Boolean flag = this.addSupplementFlag(saveOrUpdateVO.getMainContractId());
                if (!flag.booleanValue()) {
                    throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
                }
            } else {
                entity.setMainContractCreateDate(new Date());
            }
            if (entity.getTargetResultId() != null) {
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
            }
        } else {
            OutRmatContractEntity oldContractEntity = (OutRmatContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())) {
                this.tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                List dailyIdsList = oldContractEntity.getDailyRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (Object dailyRentEntity : entity.getDailyRentList()) {
                    if (!dailyIdsList.contains(dailyRentEntity.getId())) continue;
                    dailyRentEntity.setRowState("del");
                }
                List monthIdsList = oldContractEntity.getMonthRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (OutRmatContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
                    if (!monthIdsList.contains(monthRentEntity.getId())) continue;
                    monthRentEntity.setRowState("del");
                }
                List numIdsList = oldContractEntity.getNumRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (OutRmatContractNumRentEntity numRentEntity : entity.getNumRentList()) {
                    if (!numIdsList.contains(numRentEntity.getId())) continue;
                    numRentEntity.setRowState("del");
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(saveOrUpdateVO));
        }
        if (entity.getSupplementFlag() == 1) {
            this.validateContract(saveOrUpdateVO.getMainContractId(), "\u8865\u5145\u534f\u8bae", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        this.updateProxyContractByContract(saveOrUpdateVO);
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBaseMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        for (OutRmatContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (OutRmatContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (OutRmatContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }
        if (!(entity.getContractFileId() == null || (contract = (OutRmatContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        this.saveOrUpdate((Object)entity, false);
        OutRmatContractVO outRmatContractVO = this.queryDetail(entity.getId());
        return outRmatContractVO;
    }

    @Override
    public OutRmatContractVO queryDetail(Long id) {
        OutRmatContractEntity entity = (OutRmatContractEntity)((Object)this.selectById(id));
        OutRmatContractVO vo = (OutRmatContractVO)BeanMapper.map((Object)((Object)entity), OutRmatContractVO.class);
        this.setRowState(vo);
        return vo;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.baseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public String delete(List<OutRmatContractVO> vos) {
        CommonResponse response;
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatContractVO vo : vos) {
                ExecutionVO executionVO = this.targetCost((OutRmatContractVO)BeanMapper.map((Object)this.getById(vo.getId()), OutRmatContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.getById(vo.getId()));
                if (null != outRmatContractEntity.getTargetResultId()) {
                    CommonResponse tender = this.tenderRmatApi.updateById(outRmatContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                    this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
                }
                if (!"1".equals(outRmatContractEntity.getRentType()) || outRmatContractEntity.getProxyContractId() == null) continue;
                this.updateProxyContract(outRmatContractEntity.getProxyContractId(), 1);
            }
        }
        if (!(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
        }
        this.removeByIds(vos.stream().map(OutRmatContractVO::getId).collect(Collectors.toList()), true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("outOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OutRmatContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OutRmatContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(OutRmatContractEntity::getMainContractId, (Object)id);
        lambda.eq(OutRmatContractEntity::getSupplementFlag, (Object)OutRmatContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(OutRmatContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(OutRmatContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(OutRmatContractEntity::getPerformanceStatus, (Object)String.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public OutRmatContractSupplementRecordVO querySupplementRecord(Long id) {
        OutRmatContractEntity entity = (OutRmatContractEntity)((Object)this.selectById(id));
        OutRmatContractSupplementRecordVO vo = new OutRmatContractSupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatContractEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(OutRmatContractEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(OutRmatContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(OutRmatContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(Integer.valueOf(supplementList.size()));
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getSupplementToalTaxMny(), (BigDecimal)vo.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, OutRmatContractVO.class));
        return vo;
    }

    public void setRowState(OutRmatContractVO vo) {
        if (ListUtil.isNotEmpty((List)vo.getDailyRentList())) {
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getMonthRentList())) {
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getNumRentList())) {
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getRepairList())) {
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getScrapList())) {
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getOtherList())) {
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getPaymentList())) {
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getClauseList())) {
            vo.getClauseList().forEach(e -> e.setRowState("edit"));
        }
    }

    public ExecutionVO targetCost(OutRmatContractVO outRmatContractVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(outRmatContractVO.getId());
        totalVO.setTenantId(outRmatContractVO.getTenantId());
        totalVO.setBillCode(outRmatContractVO.getBillCode());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(outRmatContractVO.getProjectId());
        totalVO.setOrgId(outRmatContractVO.getOrgId());
        totalVO.setMoney(outRmatContractVO.getContractMny());
        totalVO.setTaxMoney(outRmatContractVO.getContractTaxMny());
        totalVO.setLinkUrl(this.baseHost + "ejc-assistrmat-frontend/#/contract/card?id=" + outRmatContractVO.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Boolean pushBillToSupCenter(OutRmatContractEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public Boolean delPushBill(OutRmatContractEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public Boolean pushContract(OutRmatContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-assistrmat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus() : "/ejc-assistrmat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            data.setPcCardUrl(url);
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_status", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam), (IBaseService)this.service);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.changeService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.relieveService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3), (IBaseService)this.freezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), OutRmatContractEntity.class);
            changeList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), OutRmatContractChangeEntity.class);
            relieveList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), OutRmatContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), OutRmatContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    private String getContractBillCode(OutRmatContractVO outRmatContractVO) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        if (Objects.equals(outRmatContractVO.getSupplementFlag(), OutRmatContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OutRmatContractEntity::getMainContractId, (Object)outRmatContractVO.getMainContractId());
            wrapper.in(OutRmatContractEntity::getBillState, Arrays.asList(1, 3));
            List list = this.list((Wrapper)wrapper);
            String supplementNum = "";
            supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
            contractBillCode = outRmatContractVO.getMainContractCode() + "-2-" + supplementNum;
        } else {
            switch (this.GenerateBillCodeType) {
                case "common": {
                    BillCodeParam billCodeParam;
                    CommonResponse billCode;
                    String billCodeStr = BILL_CODE_OUT;
                    if ("1".equals(outRmatContractVO.getRentType())) {
                        billCodeStr = BILL_CODE_IN;
                    }
                    if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outRmatContractVO))).isSuccess()) {
                        contractBillCode = (String)billCode.getData();
                        break;
                    }
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                case "ynjt": {
                    BillCodeParam billCodeParamYnjt;
                    CommonResponse billCodeFirstPart;
                    String billCodeStr = PURCHASE_CONTRACT_YNJT_OUT;
                    if ("1".equals(outRmatContractVO.getRentType())) {
                        billCodeStr = PURCHASE_CONTRACT_YNJT_IN;
                    }
                    if (!(billCodeFirstPart = this.billCodeApi.generateBillCode(billCodeParamYnjt = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outRmatContractVO))).isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    String orgSub = outRmatContractVO.getParentOrgCode().substring(outRmatContractVO.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(Integer.valueOf(4));
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(orgSub);
                    commonSNVO.setSourceType("YNJTZCHT");
                    CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    contractBillCode = (String)billCodeFirstPart.getData() + orgSub + (String)snResp.getData();
                    break;
                }
                default: {
                    throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
                }
            }
        }
        return contractBillCode;
    }

    private void updateProxyContractByContract(OutRmatContractVO outRmatContractVO) {
        OutRmatContractEntity contractEntity;
        if ("0".equals(outRmatContractVO.getRentType())) {
            return;
        }
        if (outRmatContractVO.getProxyContractId() == null) {
            throw new BusinessException("\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outRmatContractVO.getId() != null && (contractEntity = (OutRmatContractEntity)((Object)super.selectById((Serializable)outRmatContractVO.getId()))).getProxyContractId() != null) {
            this.logger.info("\u91ca\u653e\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66id\uff1a{}", (Object)contractEntity.getProxyContractId());
            this.updateProxyContract(contractEntity.getProxyContractId(), 1);
        }
        this.logger.info("\u5360\u7528\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66id\uff1a{}", (Object)outRmatContractVO.getProxyContractId());
        this.updateProxyContract(outRmatContractVO.getProxyContractId(), 2);
    }

    @Override
    public void updateProxyContract(Long proxyId, Integer signState) {
        ProxyContractEntity proxyEntity = (ProxyContractEntity)((Object)this.proxyContractService.selectById(proxyId));
        if (proxyEntity != null) {
            proxyEntity.setSignStatus(signState);
        }
        this.proxyContractService.saveOrUpdate((Object)proxyEntity);
    }

    @Override
    public void pushContractToRmat(JSONObject vo, Integer optType, String optBill, String rentType) {
        String type;
        if ("0".equals(rentType)) {
            return;
        }
        String jsonStr = JSONObject.toJSONString((Object)vo);
        this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u5230\u5468\u8f6c\u6750\uff0c\u63a8\u9001\u7c7b\u578b\uff1a{}\uff0c\u63a8\u9001\u5355\u636e\uff1a{}\uff0c\u63a8\u9001\u6570\u636e\uff1a{}", new Object[]{optType, optBill, jsonStr});
        switch (optBill) {
            case "contract": {
                type = ContractSyncTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getName();
                break;
            }
            case "contractChange": {
                type = ContractSyncTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u53d8\u66f4.getName();
                break;
            }
            case "contractRelieve": {
                type = ContractSyncTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u89e3\u9664.getName();
                break;
            }
            case "contractFreeze": {
                type = ContractSyncTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u51bb\u7ed3.getName();
                break;
            }
            case "contractChangeUpdate": {
                type = ContractSyncTypeEnum.\u53d8\u66f4\u66f4\u65b0\u5408\u540c\u72b6\u6001.getName();
                break;
            }
            default: {
                throw new BusinessException("\u64cd\u4f5c\u5355\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
        }
        CommonResponse response = OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD.equals(optType) ? this.prormatContractApi.contractSync(JSONObject.parseObject((String)jsonStr), type) : this.prormatContractApi.delContract(vo.getLong("id"), type);
        this.logger.info("\u63a8\u9001\u5468\u8f6c\u6750\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
    }
}

