/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.RmatFlowEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.MaterialStateEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.vo.CheckDetailVO;
import com.ejianc.business.assist.rmat.vo.CheckVO;
import com.ejianc.business.assist.rmat.vo.MaterialFlowVO;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.rmat.vo.MaxTimeVO;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.contract.mapper.OutRmatMaterialMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.start.bean.OutRmatStartEntity;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.stop.service.IOutRmatStopService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatMaterialService")
public class OutRmatMaterialServiceImpl
implements IOutRmatMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatDeliveryService outRmatDeliveryService;
    @Autowired
    private IOutRmatStartService outRmatStartService;
    @Autowired
    private IOutRmatStopService outRmatStopService;
    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;
    @Autowired
    private IOutRmatLoseService outRmatLoseService;
    @Autowired
    private IOutRmatCalculateService rentService;
    @Autowired
    private OutRmatMaterialMapper baseMapper;
    @Autowired
    private IRmatFlowService flowService;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        MaterialVO vo;
        int i;
        if ("report".equals(type)) {
            param.getFuzzyFields().add("contractName");
            param.getFuzzyFields().add("supplierName");
            param.getFuzzyFields().add("billCode");
        }
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List flowList = this.flowService.queryList(param, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> tempRestList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> tempLoseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : flowList) {
            if (RmatCommonConsts.YES.equals(flow.getEffectiveState())) {
                if (BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getCode().equals(flow.getBillTypeCode())) {
                    checkList.add(flow);
                }
                if (BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    stopList.add(flow);
                }
                if (BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    startList.add(flow);
                }
                if (BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode().equals(flow.getBillTypeCode())) {
                    restList.add(flow);
                }
                if (BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode().equals(flow.getBillTypeCode())) {
                    loseList.add(flow);
                }
            }
            if (!RmatCommonConsts.NO.equals(flow.getEffectiveState())) continue;
            if (BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode().equals(flow.getBillTypeCode())) {
                tempRestList.add(flow);
            }
            if (!BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            tempLoseList.add(flow);
        }
        HashMap<String, MaterialVO> map = new HashMap<String, MaterialVO>();
        String key = null;
        for (RmatFlowEntity detail : checkList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                vo = new MaterialVO();
                if (!map.containsKey(key)) {
                    vo.setId(key);
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = (MaterialVO)map.get(key);
                }
                vo.setCheckedNum(ComputeUtil.safeAdd((BigDecimal)vo.getCheckedNum(), (BigDecimal)detail.getNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                if (i == 1) {
                    vo.setAssistNum(ComputeUtil.safeAdd((BigDecimal)vo.getAssistNum(), (BigDecimal)detail.getAssistNum()));
                }
                map.put(key, vo);
            }
        }
        for (RmatFlowEntity detail : startList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    vo.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo.getAssistNum(), (BigDecimal)detail.getAssistNum()));
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                vo.setAssistNum(ComputeUtil.safeAdd((BigDecimal)vo.getAssistNum(), (BigDecimal)detail.getAssistNum()));
            }
        }
        for (RmatFlowEntity detail : stopList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    vo.setAssistNum(ComputeUtil.safeAdd((BigDecimal)vo.getAssistNum(), (BigDecimal)detail.getAssistNum()));
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                vo.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo.getAssistNum(), (BigDecimal)detail.getAssistNum()));
            }
        }
        for (RmatFlowEntity detail : restList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo2 = (MaterialVO)map.get(key);
            vo2.setRestitutedNum(ComputeUtil.safeAdd((BigDecimal)vo2.getRestitutedNum(), (BigDecimal)detail.getNum()));
            vo2.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo2.getAssistNum(), (BigDecimal)detail.getAssistNum()));
        }
        for (RmatFlowEntity detail : loseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo3 = (MaterialVO)map.get(key);
            vo3.setLosedNum(ComputeUtil.safeAdd((BigDecimal)vo3.getLosedNum(), (BigDecimal)detail.getNum()));
            vo3.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo3.getAssistNum(), (BigDecimal)detail.getAssistNum()));
        }
        for (RmatFlowEntity detail : tempRestList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo4 = (MaterialVO)map.get(key);
            vo4.setTempRestNum(ComputeUtil.safeAdd((BigDecimal)vo4.getTempRestNum(), (BigDecimal)detail.getNum()));
            if (!"lose".equals(type)) continue;
            vo4.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo4.getAssistNum(), (BigDecimal)detail.getAssistNum()));
        }
        for (RmatFlowEntity detail : tempLoseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo5 = (MaterialVO)map.get(key);
            vo5.setTempLoseNum(ComputeUtil.safeAdd((BigDecimal)vo5.getTempLoseNum(), (BigDecimal)detail.getNum()));
            if (!"rest".equals(type)) continue;
            vo5.setAssistNum(ComputeUtil.safeSub((BigDecimal)vo5.getAssistNum(), (BigDecimal)detail.getAssistNum()));
        }
        Iterator it = map.values().iterator();
        block27: while (it.hasNext()) {
            MaterialVO vo6 = (MaterialVO)it.next();
            switch (type) {
                case "start": {
                    if ("1".equals(vo6.getUseStatus())) {
                        it.remove();
                        continue block27;
                    }
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "stop": {
                    if ("0".equals(vo6.getUseStatus())) {
                        it.remove();
                        continue block27;
                    }
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "rest": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()}));
                    break;
                }
                case "lose": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempRestNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempRestNum()}));
                    break;
                }
                case "report": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "restNoUse": {
                    BigDecimal refNum;
                    if ("0".equals(vo6.getUseStatus())) {
                        refNum = ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()});
                        key = vo6.getContractId() + "|" + vo6.getMaterialId() + "|" + vo6.getRentCalculationType() + "|" + 1 + "|" + vo6.getTransScale();
                        if (map.containsKey(key)) {
                            MaterialVO data = (MaterialVO)map.get(key);
                            data.setRefNum(ComputeUtil.safeAdd((BigDecimal)data.getRefNum(), (BigDecimal)refNum));
                        }
                        it.remove();
                        continue block27;
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    refNum = ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()});
                    vo6.setRefNum(ComputeUtil.safeAdd((BigDecimal)vo6.getRefNum(), (BigDecimal)refNum));
                    vo6.setUseStatus(null);
                    break;
                }
            }
            vo6.setNumM(vo6.getRefNum());
            if (!"report".equals(type)) {
                vo6.setRefNum(vo6.getAssistNum());
            }
            if (vo6.getRefNum() != null && vo6.getRefNum().compareTo(BigDecimal.ZERO) > 0) continue;
            it.remove();
        }
        return new ArrayList<MaterialVO>(map.values());
    }

    @Override
    public List<MaterialVO> queryCalculateList(Long contractId, Date startDate, Date endDate) {
        Date date;
        MaterialVO vo;
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("createTime", "asc");
        Parameter parameter = new Parameter("le", (Object)DateUtil.formatSeconds((Date)endDate));
        param.getParams().put("billDate", parameter);
        List rmatFlowList = this.flowService.queryList(param, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : rmatFlowList) {
            if (!RmatCommonConsts.YES.equals(flow.getEffectiveState())) continue;
            if (BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getCode().equals(flow.getBillTypeCode())) {
                checkList.add(flow);
            }
            if (BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                stopList.add(flow);
            }
            if (BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                startList.add(flow);
            }
            if (BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode().equals(flow.getBillTypeCode())) {
                restList.add(flow);
            }
            if (!BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            loseList.add(flow);
        }
        HashMap<String, MaterialVO> map = new HashMap<String, MaterialVO>();
        String key = null;
        HashMap<Date, List<Date>> dateMap = new HashMap<Date, List<Date>>();
        HashMap<Date, List<Date>> cdateMap = new HashMap<Date, List<Date>>();
        for (RmatFlowEntity detail : checkList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("1");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate((Date)startDate, (Date)date) > 0) {
                vo.setCheckedNum(ComputeUtil.safeAdd((BigDecimal)vo.getCheckedNum(), (BigDecimal)detail.getAssistNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getAssistNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u542f\u7528, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : startList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("1");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate((Date)startDate, (Date)date) > 0) {
                vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getAssistNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getAssistNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u542f\u7528, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : stopList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("0");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate((Date)startDate, (Date)date) > 0) {
                vo.setStopedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getAssistNum()));
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getAssistNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u505c\u7528, date, detail.getId(), detail.getAssistNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : restList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            vo = (MaterialVO)map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate((Date)startDate, (Date)date) > 0) {
                vo.setRestitutedNum(ComputeUtil.safeAdd((BigDecimal)vo.getRestitutedNum(), (BigDecimal)detail.getAssistNum()));
                if ("0".equals(vo.getUseStatus())) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getAssistNum()));
                }
                if (!"1".equals(vo.getUseStatus())) continue;
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getAssistNum()));
                continue;
            }
            this.addFlowVO(vo, MaterialStateEnum.\u9000\u573a, date, detail.getId(), detail.getAssistNum());
        }
        for (RmatFlowEntity detail : loseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getTransScale();
            if (!map.containsKey(key)) continue;
            vo = (MaterialVO)map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate((Date)startDate, (Date)date) > 0) {
                vo.setLosedNum(ComputeUtil.safeAdd((BigDecimal)vo.getLosedNum(), (BigDecimal)detail.getAssistNum()));
                if ("0".equals(vo.getUseStatus())) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getAssistNum()));
                }
                if (!"1".equals(vo.getUseStatus())) continue;
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getAssistNum()));
                continue;
            }
            this.addFlowVO(vo, MaterialStateEnum.\u9000\u573a, date, detail.getId(), detail.getAssistNum());
        }
        for (String keys : map.keySet()) {
            List flowList;
            vo = (MaterialVO)map.get(keys);
            if ("0".equals(vo.getUseStatus())) {
                vo.setRefNum(vo.getStopedNum());
            }
            if ("1".equals(vo.getUseStatus())) {
                vo.setRefNum(vo.getStartedNum());
            }
            if (ComputeUtil.isGreaterThan((BigDecimal)vo.getStopedNum(), (BigDecimal)BigDecimal.ZERO)) {
                vo.setUseStatus("0");
                this.addBeginVO(vo, MaterialStateEnum.\u505c\u7528, startDate, IdWorker.getId(), vo.getStopedNum());
            }
            if (ComputeUtil.isGreaterThan((BigDecimal)vo.getStartedNum(), (BigDecimal)BigDecimal.ZERO)) {
                vo.setUseStatus("1");
                this.addBeginVO(vo, MaterialStateEnum.\u542f\u7528, startDate, IdWorker.getId(), vo.getStartedNum());
            }
            if (CollectionUtils.isNotEmpty((Collection)(flowList = vo.getFlowList()))) {
                flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            }
            vo.setFlowList(flowList);
        }
        return new ArrayList<MaterialVO>(map.values());
    }

    private Date getMaxDate(Map<Date, List<Date>> dateMap, Map<Date, List<Date>> cdateMap, Date billDate, Date createTime) {
        Date date = DateUtil.concatDate((Date)billDate, (Date)createTime);
        List<Object> list = new ArrayList<Date>();
        List<Object> clist = new ArrayList<Date>();
        Date day = DateUtil.parseDate((String)DateUtil.formatSeconds((Date)date).substring(0, 10));
        if (dateMap.containsKey(day)) {
            list = dateMap.get(day);
            Date maxDate = list.stream().max(Comparator.comparing(x -> x)).orElse(null);
            clist = cdateMap.get(day);
            Date cmaxDate = clist.stream().max(Comparator.comparing(x -> x)).orElse(null);
            if (DateUtil.compareDate((Date)date, (Date)maxDate) < 0 && DateUtil.compareDate((Date)createTime, (Date)cmaxDate) > 0 && DateUtil.compareDate((Date)(date = DateUtil.addSeconds((Date)maxDate, (int)1)), (Date)DateUtil.endOfDate((Date)date)) > 0) {
                date = DateUtil.endOfDate((Date)date);
            }
        }
        list.add(date);
        dateMap.put(day, list);
        clist.add(createTime);
        cdateMap.put(day, clist);
        return date;
    }

    private void addFlowVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        flowVO.setId(id);
        List flowList = vo.getFlowList() != null ? vo.getFlowList() : new ArrayList();
        flowList.add(flowVO);
        vo.setFlowList(flowList);
    }

    private void addBeginVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setId(id);
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        List beginList = vo.getBeginList() != null ? vo.getBeginList() : new ArrayList();
        beginList.add(flowVO);
        vo.setBeginList(beginList);
    }

    private void transferVO(RmatFlowEntity detail, MaterialVO vo) {
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setStoreId(detail.getStoreId());
        vo.setStoreName(detail.getStoreName());
        vo.setSourceType(detail.getSourceType());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgCode(detail.getOrgCode());
        vo.setOrgName(detail.getOrgName());
        vo.setParentOrgId(detail.getParentOrgId());
        vo.setParentOrgCode(detail.getParentOrgCode());
        vo.setParentOrgName(detail.getParentOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());
        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setAssistUnitId(detail.getAssistUnitId());
        vo.setAssistUnitName(detail.getAssistUnitName());
        vo.setTransScale(detail.getTransScale());
        vo.setRentCalculationType(detail.getRentCalculationType());
        vo.setRentTypeName("2".equals(detail.getRentCalculationType()) ? "\u5de5\u7a0b\u91cf\u79df" : ("1".equals(detail.getRentCalculationType()) ? "\u6708\u79df" : ("0".equals(detail.getRentCalculationType()) ? "\u65e5\u79df" : null)));
        vo.setContractRmatMethod(detail.getContractRmatMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        QueryParam param = (QueryParam)Utils.deepCopy((Object)queryParam);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.outRmatDeliveryService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u542f\u7528\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.outRmatStartService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u505c\u7528\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.outRmatStopService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.outRmatRestituteService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.outRmatLoseService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)(BillTypeEnum.\u79df\u51fa\u79df\u91d1\u8ba1\u7b97\u5355.getName().equals(billType) ? param : queryParam), (IBaseService)this.rentService);
        List checkList = new ArrayList();
        List startList = new ArrayList();
        List stopList = new ArrayList();
        List restList = new ArrayList();
        List loseList = new ArrayList();
        List rentList = new ArrayList();
        try {
            checkList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), OutRmatDeliveryEntity.class);
            startList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), OutRmatStartEntity.class);
            stopList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), OutRmatStopEntity.class);
            restList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), OutRmatRestituteEntity.class);
            loseList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), OutRmatLoseEntity.class);
            rentList = JSONObject.parseArray((String)((JSONArray)future6.get()).toJSONString(), OutRmatCalculateEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (CollectionUtils.isNotEmpty(checkList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51fa\u5e93\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(startList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u542f\u7528\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(stopList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u505c\u7528\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(restList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9000\u8d54\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(loseList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9057\u5931\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(rentList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return this.baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = this.baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Date, Date>();
        }
        return list.stream().filter(x -> x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String type = "report";
        Parameter useStatusParameter = (Parameter)param.getParams().get("useStatus");
        List<Object> useStatusList = new ArrayList();
        if (useStatusParameter != null && useStatusParameter.getValue() != null) {
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        Parameter contractRmatMethodParameter = (Parameter)param.getParams().get("contractRmatMethod");
        List<Object> contractRmatMethodList = new ArrayList();
        if (contractRmatMethodParameter != null && contractRmatMethodParameter.getValue() != null) {
            String contractRmatMethod = (String)contractRmatMethodParameter.getValue();
            String[] split = contractRmatMethod.split(",");
            contractRmatMethodList = Arrays.asList(split);
            param.getParams().remove("contractRmatMethod");
        }
        Parameter rentCalculationTypeParameter = (Parameter)param.getParams().get("rentCalculationType");
        List<Object> rentCalculationTypeList = new ArrayList();
        if (rentCalculationTypeParameter != null && rentCalculationTypeParameter.getValue() != null) {
            String rentCalculationType = (String)rentCalculationTypeParameter.getValue();
            String[] split = rentCalculationType.split(",");
            rentCalculationTypeList = Arrays.asList(split);
            param.getParams().remove("rentCalculationType");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);
        ArrayList<MaterialVO> resList = new ArrayList<MaterialVO>();
        for (MaterialVO vo2 : list) {
            boolean flag = false;
            if (useStatusList.size() > 0 && !useStatusList.contains(vo2.getUseStatus())) {
                flag = true;
            }
            if (contractRmatMethodList.size() > 0 && !contractRmatMethodList.contains(vo2.getContractRmatMethod())) {
                flag = true;
            }
            if (rentCalculationTypeList.size() > 0 && !rentCalculationTypeList.contains(vo2.getRentCalculationType())) {
                flag = true;
            }
            if (flag) continue;
            resList.add(vo2);
        }
        resList.forEach(vo -> {
            if (null != vo.getContractRmatMethod()) {
                if ("0".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("\u5916\u79df");
                } else if ("1".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("\u5185\u79df");
                }
            } else {
                vo.setContractRmatMethodName("");
            }
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("\u505c\u7528");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("\u542f\u7528");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }

    @Override
    public String validateCheckDetail(CheckVO vo) {
        List detailList = vo.getCheckDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Boolean checkNumsSum = true;
            Boolean transScale = true;
            Boolean transScaleSecond = true;
            Boolean passMuster = true;
            for (CheckDetailVO detailVO : detailList) {
                if (null == detailVO.getCheckNumsSum()) {
                    checkNumsSum = false;
                }
                if (null == detailVO.getTransScale()) {
                    transScale = false;
                }
                if ("1".equals(vo.getLoadometerWeight())) {
                    if (null == detailVO.getTransScaleSecond()) {
                        transScaleSecond = false;
                    }
                    if ("0".equals(detailVO.getPassMuster())) {
                        passMuster = false;
                    }
                }
                if (!checkNumsSum.booleanValue()) {
                    throw new BusinessException("\u3010" + detailVO.getMaterialName() + "\u3011\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!transScale.booleanValue()) {
                    throw new BusinessException("\u3010" + detailVO.getMaterialName() + "\u3011\u8f6c\u6362\u7cfb\u6570\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8ba1\u91cf\u6570\u91cf\uff01");
                }
                if (!transScaleSecond.booleanValue()) {
                    throw new BusinessException("\u3010" + detailVO.getMaterialName() + "\u3011\u8f6c\u6362\u7cfb\u6570\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u8ba1\u7b97\u7406\u8bba\u91cd\u91cf\uff01");
                }
                if (passMuster.booleanValue()) continue;
                throw new BusinessException("\u3010" + detailVO.getMaterialName() + "\u3011\u51c0\u503c\u4e0e\u7406\u8bba\u91cd\u91cf\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
            }
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

