/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.store.bean.StoreCheckDetailEntity;
import com.ejianc.business.assist.store.bean.StoreCheckEntity;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.vo.StoreCheckDetailVO;
import com.ejianc.business.assist.store.vo.StoreCheckVO;
import com.ejianc.business.assist.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"storeCheck"})
public class StoreCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ASSIST_STORE_CHECK_CODE";
    @Autowired
    private IStoreCheckService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreCheckVO> saveOrUpdate(@RequestBody StoreCheckVO saveOrUpdateVO) {
        CommonResponse commonResponse;
        StoreCheckEntity entity = (StoreCheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StoreCheckEntity.class));
        if (!ListUtil.isEmpty((List)saveOrUpdateVO.getCheckSubList())) {
            entity.setCheckSubList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getCheckSubList(), StoreCheckDetailEntity.class));
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(commonResponse = this.service.saveCheckStore(entity)).isSuccess()) {
            return commonResponse;
        }
        StoreCheckVO vo = (StoreCheckVO)BeanMapper.map((Object)commonResponse.getData(), StoreCheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreCheckVO> queryDetail(Long id) {
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.service.selectById(id));
        StoreCheckVO vo = (StoreCheckVO)BeanMapper.map((Object)((Object)entity), StoreCheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StoreCheckVO storeCheckVO : vos) {
            }
        }
        this.service.myRemoveByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkByDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        return this.service.checkByDate(storeId, checkDate);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreCheckVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        List list = this.service.queryList(param);
        List storeCheckVOVos = BeanMapper.mapList((Iterable)list, StoreCheckVO.class);
        storeCheckVOVos.forEach(item -> item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", storeCheckVOVos);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody StoreCheckVO storeCheckVO, HttpServletResponse response) {
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.service.selectById(storeCheckVO.getId()));
        DecimalFormat df = new DecimalFormat("#,##0.00");
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<StoreCheckDetailEntity> data = entity.getCheckSubList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                StoreCheckDetailVO vo = (StoreCheckDetailVO)BeanMapper.map((Object)item, StoreCheckDetailVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("checkDetailExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreCheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/turnSurplusMaterialPrice"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(@RequestBody StoreCheckVO saveOrUpdateVO) {
        CommonResponse<UseMaterialPriceVO> commonResponse = this.service.turnSurplusMaterialPrice(saveOrUpdateVO);
        return commonResponse;
    }
}

