package com.ejianc.business.outrmat.calculate.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租金计算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatCalculate")
public class OutRmatCalculateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOutRmatCalculateService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> saveOrUpdate(@RequestBody OutRmatCalculateVO saveOrUpdateVO) {
        OutRmatCalculateVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> queryDetail(Long id) {
    	OutRmatCalculateEntity entity = service.selectById(id);
        OutRmatCalculateVO vo = BeanMapper.map(entity, OutRmatCalculateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatCalculateVO> vos) {
        service.removeByIds(vos.stream().map(OutRmatCalculateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRmatCalculateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<OutRmatCalculateEntity> page = service.queryPage(param,false);
        IPage<OutRmatCalculateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatCalculateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        List<OutRmatCalculateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OutRmatCalculateVO> voList = BeanMapper.mapList(list, OutRmatCalculateVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            if(new Integer("0").equals(e.getSettleFlag())){
                e.setSettleFlagName("未结算");
            } else if(new Integer("1").equals(e.getSettleFlag())){
                e.setSettleFlagName("已结算");
            }
            if("1".equals(e.getRentType())){
                e.setRentTypeName("内租");
            } else {
                e.setRentTypeName("外租");
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("OutRmatCalculate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentCalculateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatCalculateVO>> refRentCalculateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 生效
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        // 过滤已结算
        param.getParams().put("settleFlag", new Parameter(QueryParam.NE, "1"));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long projectId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("settleDate")) {
                String settleDate = conditionMap.get("settleDate").toString();

                if (null == conditionMap.get("lastSettleDate")) {
                    param.getParams().put("rent_date", new Parameter(QueryParam.LE, settleDate));
                }else {
                    String lastSettleDate = conditionMap.get("lastSettleDate").toString();
                    param.getParams().put("rent_date", new Parameter(QueryParam.BETWEEN, lastSettleDate + "," + settleDate));
                }
            }
        }

        IPage<OutRmatCalculateEntity> page = service.queryPage(param,false);
        IPage<OutRmatCalculateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRmatCalculateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 租金自动计算
     *
     * @param vo 参数 contractId、rentDate
     * @return 计算结果
     */
    @RequestMapping(value = "/autoCalculate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatCalculateVO> autoCalculate(@RequestBody OutRmatCalculateVO vo) {
        return CommonResponse.success("租金自动计算成功！", service.automaticRental(vo));
    }

}
