package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractChangeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFileService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractSignatureService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;

@Service("outRmatContractSignatureService")
public class OutRmatContractSignatureServiceImpl implements IOutRmatContractSignatureService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRmatContractService contractService;

    @Autowired
    private IOutRmatContractChangeService changeService;

    @Autowired
    private IOutRmatContractFileService contractFileService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";

    /**
     * 签章流程
     * 单据签章状态修改逻辑
     * 1.主合同若签章状态为已签章，则修改主合同签章状态和合同状态以及生效时间，否则只修改签章状态
     * 2.变更合同
     * 若签章状态为已签章则将变更信息回写主合同，生成变更记录，改变变更合同签章状态
     * 否则改变变更合同签章状态，修改主合同的变更合同签章状态
     *
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, Integer signatureStatus, String refCode) {
        logger.info("进入签章状态修改流程------------->");
        // signatureStatus - 1 是因为分包的签章状态是1234，签章服务传递的参数也是固定的1234，但这边是0123，需要-1
//        signatureStatus = signatureStatus - 1;
        if (CommonConstant.OUT_RMAT_CONTRACT_REFCODE.equals(refCode)) {//主合同
            OutRmatContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null) {
                if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus)) {
                    contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                    contractEntity.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
                    contractEntity.setFilingRef(0);
//                    contractEntity.setEffectiveDate(new Date());
                }
                else {
                    contractEntity.setSignatureStatus(signatureStatus);
                }
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()) {
                    //查询参数判断是否需要更新合同签订日期，
                    CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                    if(!response.isSuccess()) {
                        logger.error("查询电中签章合同-【id-{}】是否更新合同签订日期参数失败，暂不更新合同签订日期: {}", id, JSONObject.toJSONString(response));
                    }
                    if(null != response.getData() && "1".equals(response.getData().getValueData())) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        //更新合同签订日期
                        logger.info("合同【id-{}，原签订日期：{}, 根据电子签章合同更新合同签订日期参数:{}，将合同签订日期改为当前签章完成日期:{}】",id,
                                sdf.format(contractEntity.getSignDate()), JSONObject.toJSONString(response.getData()), sdf.format(new Date()));
                        contractEntity.setSignDate(new Date());
                    }
                }
                contractService.saveOrUpdate(contractEntity, false);
                if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus)) {
                    //更新合同的 签章文件id - signFieldId
                    contractFileService.getSignedFileInfo(id, "contract");
                }
                if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus)) {
                    // 推送合同到周转材项目
                    contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(contractEntity)),
                            OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT,contractEntity.getRentType());
                }
                logger.info("主合同签章状态已修改---------------->");
            }
            else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }
        else if (CommonConstant.OUT_RMAT_CONTRACT_REFCODE_CHANGE.equals(refCode)) {//变更合同
            OutRmatContractChangeEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null) {
                if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus)) {
                    // 推送变更状态到周转材
                    OutRmatContractEntity outRmatContractEntity = contractService.selectById(changeEntity.getContractId());
                    contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(changeEntity)),
                            OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE_U,outRmatContractEntity.getRentType());
                    return changeService.effectiveSaveWriteContract(id, changeEntity.getBillCode(), false, true);
                }
                else {
                    changeEntity.setSignatureStatus(signatureStatus);
                    changeService.saveOrUpdate(changeEntity);
                    logger.info("变更合同签章状态已修改---------------->");
                    //回写主合同（变更合同签章状态，主合同变更状态）
//                    LambdaUpdateWrapper<OutRmatContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//                    updateWrapper.eq(OutRmatContractEntity::getId, changeEntity.getContractId());
//                    updateWrapper.set(OutRmatContractEntity::getChangeContractSignatureStatus, changeEntity.getSignatureStatus());
//                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                    OutRmatContractEntity outRmatContractEntity = contractService.selectById(changeEntity.getContractId());
                    outRmatContractEntity.setChangeContractSignatureStatus(changeEntity.getSignatureStatus().toString());
                    contractService.saveOrUpdate(outRmatContractEntity);
                    // 推送变更状态到周转材
                    contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(changeEntity)),
                            OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE_U,outRmatContractEntity.getRentType());

                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
            }
            else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }
        else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
