/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.assist.material.bean.MaterialChangeEntity;
import com.ejianc.business.assist.material.bean.MaterialContractDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractFreezeEntity;
import com.ejianc.business.assist.material.bean.MaterialContractRelieveEntity;
import com.ejianc.business.assist.material.mapper.MaterialContractMapper;
import com.ejianc.business.assist.material.service.IMaterialChangeService;
import com.ejianc.business.assist.material.service.IMaterialContractFreezeService;
import com.ejianc.business.assist.material.service.IMaterialContractRelieveService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.material.vo.record.MaterialSupplementRecordVO;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialContractService")
public class MaterialContractServiceImpl
extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity>
implements IMaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSISTMATERIAL_CONTRACT";
    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billDel";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITenderRmatApi tenderRmatApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IMaterialContractService service;
    @Autowired
    private IMaterialChangeService changeService;
    @Autowired
    private IMaterialContractRelieveService relieveService;
    @Autowired
    private IMaterialContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public MaterialContractVO saveOrUpdate(MaterialContractVO saveOrUpdateVO, String authority) {
        MaterialContractEntity contract;
        MaterialContractEntity entity;
        CommonResponse orgResponse;
        if (saveOrUpdateVO.getOrgId() != null && (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) || StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    saveOrUpdateVO.setParentOrgId(parentOrgVO.getId());
                    saveOrUpdateVO.setParentOrgCode(parentOrgVO.getCode());
                    saveOrUpdateVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                saveOrUpdateVO.setParentOrgId(saveOrUpdateVO.getOrgId());
                saveOrUpdateVO.setParentOrgCode(saveOrUpdateVO.getOrgCode());
                saveOrUpdateVO.setParentOrgName(saveOrUpdateVO.getOrgName());
            }
        }
        if ((entity = (MaterialContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialContractEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setBillCode(this.getContractBillCode(saveOrUpdateVO));
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            if (entity.getSupplementFlag() != 1) {
                entity.setMainContractCreateDate(new Date());
            }
            if (entity.getTargetResultId() != null) {
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
            }
        } else {
            MaterialContractEntity oldContractEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())) {
                this.tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                List idsList = oldContractEntity.getDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (MaterialContractDetailEntity detailEntity : entity.getDetailList()) {
                    if (!idsList.contains(detailEntity.getId())) continue;
                    detailEntity.setRowState("del");
                }
            }
        }
        if (entity.getSupplementFlag() == 1) {
            this.validateContract(saveOrUpdateVO.getMainContractId(), "\u8865\u5145\u534f\u8bae", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        }
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBaseMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        if (!(entity.getContractFileId() == null || (contract = (MaterialContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        this.saveOrUpdate((Object)entity, false);
        MaterialContractVO contractVO = this.queryDetail(entity.getId());
        return contractVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.baseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public MaterialContractVO queryDetail(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.selectById(id));
        MaterialContractVO vo = (MaterialContractVO)BeanMapper.map((Object)((Object)entity), MaterialContractVO.class);
        if (ListUtil.isNotEmpty((List)vo.getDetailList())) {
            vo.getDetailList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getOtherList())) {
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        return vo;
    }

    @Override
    public String delete(List<MaterialContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialContractVO vo : vos) {
                MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.getById(vo.getId()));
                if (null == contractEntity.getTargetResultId()) continue;
                CommonResponse tender = this.tenderRmatApi.updateById(contractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        }
        this.removeByIds(vos.stream().map(MaterialContractVO::getId).collect(Collectors.toList()), true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = MaterialContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Boolean pushContract(MaterialContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_status", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam), (IBaseService)this.service);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.changeService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.relieveService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3), (IBaseService)this.freezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), MaterialContractEntity.class);
            changeList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), MaterialChangeEntity.class);
            relieveList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), MaterialContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), MaterialContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (ListUtil.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (ListUtil.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (ListUtil.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public MaterialSupplementRecordVO querySupplementRecord(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.selectById(id));
        MaterialSupplementRecordVO vo = new MaterialSupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialContractEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(MaterialContractEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(MaterialContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(MaterialContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(Integer.valueOf(supplementList.size()));
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getSupplementToalTaxMny(), (BigDecimal)vo.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, MaterialContractVO.class));
        return vo;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    private String getContractBillCode(MaterialContractVO contractVo) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        if (Objects.equals(contractVo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(MaterialContractEntity::getMainContractId, (Object)contractVo.getMainContractId());
            wrapper.in(MaterialContractEntity::getBillState, Arrays.asList(1, 3));
            List list = this.list((Wrapper)wrapper);
            String supplementNum = "";
            supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
            contractBillCode = contractVo.getMainContractCode() + "-2-" + supplementNum;
        } else {
            switch (this.GenerateBillCodeType) {
                case "common": {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        contractBillCode = (String)billCode.getData();
                        break;
                    }
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                case "ynjt": {
                    BillCodeParam billCodeParamYnjt = BillCodeParam.build((String)PURCHASE_CONTRACT_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(billCodeParamYnjt);
                    if (!billCodeFirstPart.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(Integer.valueOf(4));
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(orgSub);
                    commonSNVO.setSourceType("YNJTCLCG");
                    CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    contractBillCode = (String)billCodeFirstPart.getData() + orgSub + (String)snResp.getData();
                    break;
                }
                default: {
                    throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
                }
            }
        }
        return contractBillCode;
    }
}

