/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeClauseEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeNumRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeOtherEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangePaymentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeRepairEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeScrapEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractClauseEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractNumRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractOtherEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractPaymentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordClauseEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordNumRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordOtherEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordPaymentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordRepairEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordScrapEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRepairEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractScrapEntity;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.ChangeStatusEnum;
import com.ejianc.business.outrmat.contract.enums.DraftTypeEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SettleEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractChangeMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractChangeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractClauseService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractDailyRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFileService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractMonthRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractNumRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractOtherService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractPaymentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRecordService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRepairService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractScrapService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeClauseVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeCompareVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeDailyRentVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeMonthRentVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeNumRentVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeOtherVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangePaymentVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeRepairVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeScrapVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractChangeRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="outRmatContractChangeService")
public class OutRmatContractChangeServiceImpl
extends BaseServiceImpl<OutRmatContractChangeMapper, OutRmatContractChangeEntity>
implements IOutRmatContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_CNAHGE";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutRmatContractService contractService;
    @Autowired
    private IOutRmatContractRecordService recordService;
    @Autowired
    private IOutRmatContractChangeService changeService;
    @Autowired
    private IOutRmatContractDailyRentService dailyRentService;
    @Autowired
    private IOutRmatContractMonthRentService monthRentService;
    @Autowired
    private IOutRmatContractNumRentService numRentService;
    @Autowired
    private IOutRmatContractRepairService repairService;
    @Autowired
    private IOutRmatContractScrapService scrapService;
    @Autowired
    private IOutRmatContractOtherService otherService;
    @Autowired
    private IOutRmatContractPaymentService paymentService;
    @Autowired
    private IOutRmatContractClauseService clauseService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IOutRmatContractFileService contractFileService;

    @Override
    public OutRmatContractChangeVO saveOrUpdate(OutRmatContractChangeVO saveOrUpdateVO) {
        OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(saveOrUpdateVO.getMainContractId()));
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getAttachIds()) && null != outRmatContractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(outRmatContractEntity.getContractFileId());
        }
        OutRmatContractChangeEntity entity = (OutRmatContractChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatContractChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(OutRmatContractChangeEntity::getContractId, (Object)saveOrUpdateVO.getMainContractId());
        if (saveOrUpdateVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(OutRmatContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(OutRmatContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            if (entity.getChangeVersion() < 10) {
                entity.setBillCode(entity.getMainContractCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }
            this.clearDetailList(entity);
            this.deleteOldCost((OutRmatContractChangeVO)BeanMapper.map((Object)((Object)outRmatContractEntity), OutRmatContractChangeVO.class));
        }
        this.contractService.validateContract(saveOrUpdateVO.getMainContractId(), "\u53d8\u66f4\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OutRmatContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(OutRmatContractEntity::getChangingMny, (Object)entity.getContractMny());
        updateWrapper.set(OutRmatContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
        updateWrapper.set(OutRmatContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.set(OutRmatContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
        updateWrapper.set(OutRmatContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(OutRmatContractEntity::getChangeDate, (Object)entity.getChangeDate());
        updateWrapper.set(OutRmatContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
        updateWrapper.set(OutRmatContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureStatus());
        updateWrapper.set(OutRmatContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
        updateWrapper.set(OutRmatContractEntity::getChangeContractName, (Object)entity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
        this.contractService.update((Wrapper)updateWrapper);
        OutRmatContractEntity queryOutRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(entity.getMainContractId()));
        this.contractService.pushContractToRmat(JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)entity))), OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, "contractChange", queryOutRmatContractEntity.getRentType());
        OutRmatContractChangeVO vo = (OutRmatContractChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), OutRmatContractChangeVO.class);
        return (OutRmatContractChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), OutRmatContractChangeVO.class);
    }

    @Override
    public OutRmatContractChangeRecordVO queryChangeRecord(Long id) {
        OutRmatContractEntity entity = (OutRmatContractEntity)((Object)this.contractService.selectById(id));
        OutRmatContractChangeRecordVO vo = new OutRmatContractChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatContractChangeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List changeList = super.list((Wrapper)wrapper);
        vo.setTotalChangeMny(ComputeUtil.safeSub((BigDecimal)vo.getContractMny(), (BigDecimal)vo.getBaseMny()));
        vo.setTotalChangeTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getBaseTaxMny()));
        vo.setTotalChangeNum(Integer.valueOf(changeList.size()));
        vo.setTotalChangeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalChangeMny(), (BigDecimal)vo.getBaseTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)changeList, OutRmatContractChangeVO.class));
        return vo;
    }

    @Override
    public OutRmatContractChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatContractRecordEntity::getChangeId, (Object)id);
        List list = this.recordService.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return (OutRmatContractChangeVO)BeanMapper.map((Object)this.recordService.selectById(((OutRmatContractRecordEntity)((Object)list.get(0))).getId()), OutRmatContractChangeVO.class);
        }
        return new OutRmatContractChangeVO();
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        OutRmatContractChangeEntity outRmatContractChangeEntity = (OutRmatContractChangeEntity)((Object)this.selectById(changeBillId));
        OutRmatContractVO outRmatContractVO = this.contractService.queryDetail(outRmatContractChangeEntity.getContractId());
        this.writeBackRecord(outRmatContractChangeEntity, outRmatContractVO);
        this.writeBackContract(outRmatContractChangeEntity, outRmatContractVO);
        outRmatContractChangeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        outRmatContractChangeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        outRmatContractChangeEntity.setCommitDate(new Date());
        if (filingFlag.booleanValue()) {
            outRmatContractChangeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            outRmatContractChangeEntity.setFilingRef(0);
        }
        this.changeService.saveOrUpdate((Object)outRmatContractChangeEntity);
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(outRmatContractChangeEntity.getChangeDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(outRmatContractChangeEntity.getChangeDraftType())) {
            this.contractFileService.getSignedFileInfo(changeBillId, "contractChange");
        }
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public void deleteByIds(List<OutRmatContractChangeVO> vos) {
        for (OutRmatContractChangeVO vo : vos) {
            OutRmatContractChangeEntity outRmatContractChangeEntity = (OutRmatContractChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            this.deleteOldCost((OutRmatContractChangeVO)BeanMapper.map((Object)((Object)outRmatContractChangeEntity), OutRmatContractChangeVO.class));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OutRmatContractChangeEntity::getContractId, (Object)outRmatContractChangeEntity.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List list = this.list((Wrapper)wrapper);
            OutRmatContractChangeVO outRmatContractChangeVO = new OutRmatContractChangeVO();
            if (ListUtil.isNotEmpty((List)list)) {
                outRmatContractChangeVO = (OutRmatContractChangeVO)BeanMapper.map(list.get(0), OutRmatContractChangeVO.class);
            } else {
                OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(outRmatContractChangeEntity.getContractId()));
                outRmatContractChangeVO = (OutRmatContractChangeVO)BeanMapper.map((Object)((Object)outRmatContractEntity), OutRmatContractChangeVO.class);
            }
            this.targetCost(outRmatContractChangeVO);
            LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
            if (outRmatContractChangeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(OutRmatContractEntity::getChangeStatus, (Object)1);
            } else {
                lambdaUpdate.set(OutRmatContractEntity::getChangeStatus, (Object)3);
            }
            lambdaUpdate.eq(BaseEntity::getId, (Object)outRmatContractChangeEntity.getContractId());
            this.contractService.update((Wrapper)lambdaUpdate);
            super.removeById((Serializable)vo.getId(), false);
            OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(outRmatContractChangeEntity.getContractId()));
            this.contractService.pushContractToRmat(JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo)), OutRmatConstant.PUSH_RMAT_OPT_TYPE_DEL, "contractChange", outRmatContractEntity.getRentType());
        }
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        OutRmatContractChangeEntity outRmatContractChangeEntity = (OutRmatContractChangeEntity)((Object)this.selectById(id));
        OutRmatContractChangeCompareVO outRmatContractChangeCompareVO = (OutRmatContractChangeCompareVO)BeanMapper.map((Object)((Object)outRmatContractChangeEntity), OutRmatContractChangeCompareVO.class);
        OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(outRmatContractChangeEntity.getContractId()));
        OutRmatContractChangeCompareVO beforeChangeVO = new OutRmatContractChangeCompareVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(outRmatContractChangeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(outRmatContractChangeEntity.getBillState())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OutRmatContractRecordEntity::getChangeId, (Object)id);
            wrapper.eq(OutRmatContractRecordEntity::getContractId, (Object)outRmatContractChangeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List recordEntityList = this.recordService.list((Wrapper)wrapper);
            if (ListUtil.isNotEmpty((List)recordEntityList)) {
                beforeChangeVO = (OutRmatContractChangeCompareVO)BeanMapper.map((Object)this.recordService.selectById(((OutRmatContractRecordEntity)((Object)recordEntityList.get(0))).getId()), OutRmatContractChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (OutRmatContractChangeCompareVO)BeanMapper.map((Object)((Object)outRmatContractEntity), OutRmatContractChangeCompareVO.class);
            flag = true;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (outRmatContractChangeCompareVO != null && beforeChangeVO != null) {
            OutRmatContractChangeDailyRentVO beforeVO;
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getDailyRentList())) {
                List dailyRentList = beforeChangeVO.getDailyRentList();
                Map<Object, Object> beforeDailyMap = new HashMap();
                beforeDailyMap = flag ? dailyRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : dailyRentList.stream().collect(Collectors.toMap(OutRmatContractChangeDailyRentVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getDailyRentList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeDailyRentVO)beforeDailyMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcUnitName(beforeVO.getUnitName());
                    vo.setBcRentDays(beforeVO.getRentDays());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                outRmatContractChangeCompareVO.setDailyRentList(outRmatContractChangeCompareVO.getDailyRentList().stream().filter(daily -> StringUtils.isNotEmpty((CharSequence)daily.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getMonthRentList())) {
                List monthRentList = beforeChangeVO.getMonthRentList();
                Map<Object, Object> beforeMonthMap = new HashMap();
                beforeMonthMap = flag ? monthRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : monthRentList.stream().collect(Collectors.toMap(OutRmatContractChangeMonthRentVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getMonthRentList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeMonthRentVO)beforeMonthMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLackMonthDayUnitTaxPrice(beforeVO.getLackMonthDayUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcUnitName(beforeVO.getUnitName());
                    vo.setBcRentMonths(beforeVO.getRentMonths());
                    vo.setBcRentDays(beforeVO.getRentDays());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                outRmatContractChangeCompareVO.setMonthRentList(outRmatContractChangeCompareVO.getMonthRentList().stream().filter(month -> StringUtils.isNotEmpty((CharSequence)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getNumRentList())) {
                List numRentList = beforeChangeVO.getNumRentList();
                Map<Object, Object> beforeNumMap = new HashMap();
                beforeNumMap = flag ? numRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : numRentList.stream().collect(Collectors.toMap(OutRmatContractChangeNumRentVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getNumRentList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeNumRentVO)beforeNumMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcUnitName(beforeVO.getUnitName());
                    vo.setBcQuantities(beforeVO.getQuantities());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                outRmatContractChangeCompareVO.setNumRentList(outRmatContractChangeCompareVO.getNumRentList().stream().filter(num -> StringUtils.isNotEmpty((CharSequence)num.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getRepairList())) {
                List repairList = beforeChangeVO.getRepairList();
                Map<Object, Object> beforeRepairMap = new HashMap();
                beforeRepairMap = flag ? repairList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : repairList.stream().collect(Collectors.toMap(OutRmatContractChangeRepairVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getRepairList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeRepairVO)beforeRepairMap.get(vo.getSourceBid());
                    vo.setBcRepairItemName(beforeVO.getRepairItemName());
                    vo.setBcRepairUnitName(beforeVO.getRepairUnitName());
                    vo.setBcRepairTaxPrice(beforeVO.getRepairTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                outRmatContractChangeCompareVO.setRepairList(outRmatContractChangeCompareVO.getRepairList().stream().filter(repair -> StringUtils.isNotEmpty((CharSequence)repair.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getScrapList())) {
                List scrapList = beforeChangeVO.getScrapList();
                Map<Object, Object> beforeScrapMap = new HashMap();
                beforeScrapMap = flag ? scrapList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : scrapList.stream().collect(Collectors.toMap(OutRmatContractChangeScrapVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getScrapList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeScrapVO)beforeScrapMap.get(vo.getSourceBid());
                    vo.setBcDamageScrapName(beforeVO.getDamageScrapName());
                    vo.setBcDamageScrapUnitName(beforeVO.getDamageScrapUnitName());
                    vo.setBcDamageScrapTaxPrice(beforeVO.getDamageScrapTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                outRmatContractChangeCompareVO.setScrapList(outRmatContractChangeCompareVO.getScrapList().stream().filter(scarp -> StringUtils.isNotEmpty((CharSequence)scarp.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getOtherList())) {
                List otherList = beforeChangeVO.getOtherList();
                Map<Object, Object> beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherList.stream().collect(Collectors.toMap(OutRmatContractChangeOtherVO::getSourceBid, Function.identity()));
                for (Object vo : outRmatContractChangeCompareVO.getOtherList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (OutRmatContractChangeOtherVO)beforeOtherMap.get(vo.getSourceBid());
                    vo.setBcCostName(beforeVO.getCostName());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                outRmatContractChangeCompareVO.setOtherList(outRmatContractChangeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty((CharSequence)other.getChangeType())).collect(Collectors.toList()));
            }
            ArrayList<OutRmatContractChangePaymentVO> newPayList = new ArrayList<OutRmatContractChangePaymentVO>();
            Map<Object, Object> beforePayMap = new HashMap();
            beforePayMap = flag ? beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2)) : beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(OutRmatContractChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getPaymentList())) {
                OutRmatContractChangePaymentVO beforeVo = null;
                for (OutRmatContractChangePaymentVO vo : outRmatContractChangeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                        continue;
                    }
                    if (!beforePayMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (OutRmatContractChangePaymentVO)beforePayMap.get(vo.getSourceBid());
                    if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                        vo.setBcPaymentName(beforeVo.getPaymentName());
                        vo.setBcPaymentScale(beforeVo.getPaymentScale());
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newPayList.add(vo);
                    }
                    beforePayMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforePayMap)) {
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newPayList.add((OutRmatContractChangePaymentVO)c);
                });
            }
            outRmatContractChangeCompareVO.setPaymentList(newPayList);
            ArrayList<OutRmatContractChangeClauseVO> newClauses = new ArrayList<OutRmatContractChangeClauseVO>();
            Map<Object, Object> beforeClauseMap = new HashMap();
            beforeClauseMap = flag ? beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2)) : beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(OutRmatContractChangeClauseVO::getSourceBid, clause -> clause, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)outRmatContractChangeCompareVO.getClauseList())) {
                OutRmatContractChangeClauseVO beforeVo = null;
                for (OutRmatContractChangeClauseVO vo : outRmatContractChangeCompareVO.getClauseList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                        continue;
                    }
                    if (!beforeClauseMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (OutRmatContractChangeClauseVO)beforeClauseMap.get(vo.getSourceBid());
                    if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                        vo.setBcClauseName(beforeVo.getClauseName());
                        vo.setBcClauseContent(beforeVo.getClauseContent());
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newClauses.add(vo);
                    }
                    beforeClauseMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforeClauseMap)) {
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newClauses.add((OutRmatContractChangeClauseVO)c);
                });
            }
            outRmatContractChangeCompareVO.setClauseList(newClauses);
            returnMap.put("newData", outRmatContractChangeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    public void writeBackRecord(OutRmatContractChangeEntity outRmatContractChangeEntity, OutRmatContractVO outRmatContractVO) {
        OutRmatContractRecordEntity outRmatContractRecordEntity = (OutRmatContractRecordEntity)((Object)BeanMapper.map((Object)outRmatContractVO, OutRmatContractRecordEntity.class));
        outRmatContractRecordEntity.setContractId(outRmatContractChangeEntity.getContractId());
        outRmatContractRecordEntity.setId(null);
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getDailyRentList())) {
            for (OutRmatContractRecordDailyRentEntity outRmatContractRecordDailyRentEntity : outRmatContractRecordEntity.getDailyRentList()) {
                outRmatContractRecordDailyRentEntity.setSourceBid(outRmatContractRecordDailyRentEntity.getId());
                outRmatContractRecordDailyRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getMonthRentList())) {
            for (OutRmatContractRecordMonthRentEntity outRmatContractRecordMonthRentEntity : outRmatContractRecordEntity.getMonthRentList()) {
                outRmatContractRecordMonthRentEntity.setSourceBid(outRmatContractRecordMonthRentEntity.getId());
                outRmatContractRecordMonthRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getNumRentList())) {
            for (OutRmatContractRecordNumRentEntity outRmatContractRecordNumRentEntity : outRmatContractRecordEntity.getNumRentList()) {
                outRmatContractRecordNumRentEntity.setSourceBid(outRmatContractRecordNumRentEntity.getId());
                outRmatContractRecordNumRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getRepairList())) {
            for (OutRmatContractRecordRepairEntity outRmatContractRecordRepairEntity : outRmatContractRecordEntity.getRepairList()) {
                outRmatContractRecordRepairEntity.setSourceBid(outRmatContractRecordRepairEntity.getId());
                outRmatContractRecordRepairEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getScrapList())) {
            for (OutRmatContractRecordScrapEntity outRmatContractRecordScrapEntity : outRmatContractRecordEntity.getScrapList()) {
                outRmatContractRecordScrapEntity.setSourceBid(outRmatContractRecordScrapEntity.getId());
                outRmatContractRecordScrapEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getOtherList())) {
            for (OutRmatContractRecordOtherEntity outRmatContractRecordOtherEntity : outRmatContractRecordEntity.getOtherList()) {
                outRmatContractRecordOtherEntity.setSourceBid(outRmatContractRecordOtherEntity.getId());
                outRmatContractRecordOtherEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getClauseList())) {
            for (OutRmatContractRecordClauseEntity outRmatContractRecordClauseEntity : outRmatContractRecordEntity.getClauseList()) {
                outRmatContractRecordClauseEntity.setSourceBid(outRmatContractRecordClauseEntity.getId());
                outRmatContractRecordClauseEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractRecordEntity.getPaymentList())) {
            for (OutRmatContractRecordPaymentEntity outRmatContractRecordPaymentEntity : outRmatContractRecordEntity.getPaymentList()) {
                outRmatContractRecordPaymentEntity.setSourceBid(outRmatContractRecordPaymentEntity.getId());
                outRmatContractRecordPaymentEntity.setId(null);
            }
        }
        this.recordService.saveOrUpdate((Object)outRmatContractRecordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(outRmatContractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c.getCode(), "arriContract", String.valueOf(outRmatContractRecordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u8bb0\u5f55.getCode(), "arriContractRecord");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(outRmatContractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c.getCode(), "arriContractFile", String.valueOf(outRmatContractRecordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u8bb0\u5f55.getCode(), "arriContractRecordFile");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)commonResponse));
    }

    public void writeBackContract(OutRmatContractChangeEntity outRmatContractChangeEntity, OutRmatContractVO outRmatContractVO) {
        List clauseList;
        List paymentList;
        List otherList;
        List scrapList;
        List repairList;
        List numRentList;
        List monthRentList;
        List dailyRentList;
        OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)BeanMapper.map((Object)outRmatContractVO, OutRmatContractEntity.class));
        outRmatContractEntity.setFirstPartyProjectManagerId(outRmatContractChangeEntity.getFirstPartyProjectManagerId());
        outRmatContractEntity.setFirstPartyProjectManagerName(outRmatContractChangeEntity.getFirstPartyProjectManagerName());
        outRmatContractEntity.setFirstPartyEmployeeId(outRmatContractChangeEntity.getFirstPartyEmployeeId());
        outRmatContractEntity.setFirstPartyEmployeeName(outRmatContractChangeEntity.getFirstPartyEmployeeName());
        outRmatContractEntity.setFirstPartyPhone(outRmatContractChangeEntity.getFirstPartyPhone());
        outRmatContractEntity.setSupplierId(outRmatContractChangeEntity.getSupplierId());
        outRmatContractEntity.setSupplierName(outRmatContractChangeEntity.getSupplierName());
        outRmatContractEntity.setSupplierEmployeeId(outRmatContractChangeEntity.getSupplierEmployeeId());
        outRmatContractEntity.setSupplierEmployeeName(outRmatContractChangeEntity.getSupplierEmployeeName());
        outRmatContractEntity.setSupplierPhone(outRmatContractChangeEntity.getSupplierPhone());
        outRmatContractEntity.setSupplierAddress(outRmatContractChangeEntity.getSupplierAddress());
        outRmatContractEntity.setFirstPartyEntrustedAgentId(outRmatContractChangeEntity.getFirstPartyEntrustedAgentId());
        outRmatContractEntity.setFirstPartyEntrustedAgentName(outRmatContractChangeEntity.getFirstPartyEntrustedAgentName());
        outRmatContractEntity.setFirstPartyPrincipalId(outRmatContractChangeEntity.getFirstPartyPrincipalId());
        outRmatContractEntity.setFirstPartyPrincipalName(outRmatContractChangeEntity.getFirstPartyPrincipalName());
        outRmatContractEntity.setFirstPartyAddress(outRmatContractChangeEntity.getFirstPartyAddress());
        outRmatContractEntity.setSupplierPrincipalId(outRmatContractChangeEntity.getSupplierPrincipalId());
        outRmatContractEntity.setSupplierPrincipalName(outRmatContractChangeEntity.getSupplierPrincipalName());
        outRmatContractEntity.setMaterialClerkOneId(outRmatContractChangeEntity.getMaterialClerkOneId());
        outRmatContractEntity.setMaterialClerkOneName(outRmatContractChangeEntity.getMaterialClerkOneName());
        outRmatContractEntity.setMaterialClerkOnePhone(outRmatContractChangeEntity.getMaterialClerkOnePhone());
        outRmatContractEntity.setMaterialClerkTwoId(outRmatContractChangeEntity.getMaterialClerkTwoId());
        outRmatContractEntity.setMaterialClerkTwoName(outRmatContractChangeEntity.getMaterialClerkTwoName());
        outRmatContractEntity.setMaterialClerkTwoPhone(outRmatContractChangeEntity.getMaterialClerkTwoPhone());
        outRmatContractEntity.setContractMny(outRmatContractChangeEntity.getContractMny());
        outRmatContractEntity.setContractTaxMny(outRmatContractChangeEntity.getContractTaxMny());
        outRmatContractEntity.setTaxRate(outRmatContractChangeEntity.getTaxRate());
        outRmatContractEntity.setTax(outRmatContractChangeEntity.getTax());
        outRmatContractEntity.setChangingMny(null);
        outRmatContractEntity.setChangingTaxMny(null);
        outRmatContractEntity.setRentCalculationType(outRmatContractChangeEntity.getRentCalculationType());
        outRmatContractEntity.setMonthSettlementDay(outRmatContractChangeEntity.getMonthSettlementDay());
        outRmatContractEntity.setContractName(outRmatContractChangeEntity.getContractName());
        outRmatContractEntity.setChangeContractName(outRmatContractChangeEntity.getContractName());
        outRmatContractEntity.setSupplyAddress(outRmatContractChangeEntity.getSupplyAddress());
        outRmatContractEntity.setSignDate(outRmatContractChangeEntity.getSignDate());
        outRmatContractEntity.setRentCalculationDate(outRmatContractChangeEntity.getRentCalculationDate());
        outRmatContractEntity.setEndRentCalculationDate(outRmatContractChangeEntity.getEndRentCalculationDate());
        outRmatContractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        outRmatContractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
        outRmatContractEntity.setChangeDraftType(outRmatContractChangeEntity.getChangeDraftType());
        outRmatContractEntity.setChangeFileId(outRmatContractChangeEntity.getChangeFileId());
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getDailyRentList())) {
            this.dailyRentService.removeByIds(outRmatContractVO.getDailyRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(dailyRentList = BeanMapper.mapList(outRmatContractChangeEntity.getDailyRentList(), OutRmatContractDailyRentEntity.class)))) {
            for (Object entity : dailyRentList) {
                ((OutRmatContractDailyRentEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractDailyRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setDailyRentList(dailyRentList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getMonthRentList())) {
            this.monthRentService.removeByIds(outRmatContractVO.getMonthRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(monthRentList = BeanMapper.mapList(outRmatContractChangeEntity.getMonthRentList(), OutRmatContractMonthRentEntity.class)))) {
            for (Object entity : monthRentList) {
                ((OutRmatContractMonthRentEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractMonthRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setMonthRentList(monthRentList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getNumRentList())) {
            this.numRentService.removeByIds(outRmatContractVO.getNumRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(numRentList = BeanMapper.mapList(outRmatContractChangeEntity.getNumRentList(), OutRmatContractNumRentEntity.class)))) {
            for (Object entity : numRentList) {
                ((OutRmatContractNumRentEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractNumRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setNumRentList(numRentList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getRepairList())) {
            this.repairService.removeByIds(outRmatContractVO.getRepairList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(repairList = BeanMapper.mapList(outRmatContractChangeEntity.getRepairList(), OutRmatContractRepairEntity.class)))) {
            for (Object entity : repairList) {
                ((OutRmatContractRepairEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractRepairEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setRepairList(repairList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getScrapList())) {
            this.scrapService.removeByIds(outRmatContractVO.getScrapList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(scrapList = BeanMapper.mapList(outRmatContractChangeEntity.getScrapList(), OutRmatContractScrapEntity.class)))) {
            for (Object entity : scrapList) {
                ((OutRmatContractScrapEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractScrapEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setScrapList(scrapList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getOtherList())) {
            this.otherService.removeByIds(outRmatContractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(otherList = BeanMapper.mapList(outRmatContractChangeEntity.getOtherList(), OutRmatContractOtherEntity.class)))) {
            for (Object entity : otherList) {
                ((OutRmatContractOtherEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractOtherEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setOtherList(otherList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getPaymentList())) {
            this.paymentService.removeByIds(outRmatContractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(paymentList = BeanMapper.mapList(outRmatContractChangeEntity.getPaymentList(), OutRmatContractPaymentEntity.class)))) {
            for (Object entity : paymentList) {
                ((OutRmatContractPaymentEntity)((Object)entity)).setChangeId(outRmatContractChangeEntity.getId());
                ((OutRmatContractPaymentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setPaymentList(paymentList);
        if (ListUtil.isNotEmpty((List)outRmatContractVO.getClauseList())) {
            this.clauseService.removeByIds(outRmatContractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(clauseList = BeanMapper.mapList(outRmatContractChangeEntity.getClauseList(), OutRmatContractClauseEntity.class)))) {
            for (OutRmatContractClauseEntity entity : clauseList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setClauseList(clauseList);
        Boolean pushResult = this.pushContract((OutRmatContractVO)BeanMapper.map((Object)((Object)outRmatContractEntity), OutRmatContractVO.class), UpdateLevelEnum.\u5168\u91cf\u8986\u76d6\u66f4\u65b0.getLevelCode());
        if (pushResult.booleanValue()) {
            outRmatContractEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            outRmatContractEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.contractService.saveOrUpdate((Object)outRmatContractEntity, false);
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(outRmatContractChangeEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u53d8\u66f4.getCode(), "arriContractChange", String.valueOf(outRmatContractEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c.getCode(), "arriContract");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
    }

    public void clearDetailList(OutRmatContractChangeEntity outRmatContractChangeEntity) {
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getDailyRentList())) {
            for (OutRmatContractChangeDailyRentEntity outRmatContractChangeDailyRentEntity : outRmatContractChangeEntity.getDailyRentList()) {
                if (outRmatContractChangeDailyRentEntity.getId() != null) {
                    outRmatContractChangeDailyRentEntity.setSourceBid(outRmatContractChangeDailyRentEntity.getId());
                }
                outRmatContractChangeDailyRentEntity.setId(null);
                outRmatContractChangeDailyRentEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getMonthRentList())) {
            for (OutRmatContractChangeMonthRentEntity outRmatContractChangeMonthRentEntity : outRmatContractChangeEntity.getMonthRentList()) {
                if (outRmatContractChangeMonthRentEntity.getId() != null) {
                    outRmatContractChangeMonthRentEntity.setSourceBid(outRmatContractChangeMonthRentEntity.getId());
                }
                outRmatContractChangeMonthRentEntity.setId(null);
                outRmatContractChangeMonthRentEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getNumRentList())) {
            for (OutRmatContractChangeNumRentEntity outRmatContractChangeNumRentEntity : outRmatContractChangeEntity.getNumRentList()) {
                if (outRmatContractChangeNumRentEntity.getId() != null) {
                    outRmatContractChangeNumRentEntity.setSourceBid(outRmatContractChangeNumRentEntity.getId());
                }
                outRmatContractChangeNumRentEntity.setId(null);
                outRmatContractChangeNumRentEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getRepairList())) {
            for (OutRmatContractChangeRepairEntity outRmatContractChangeRepairEntity : outRmatContractChangeEntity.getRepairList()) {
                if (outRmatContractChangeRepairEntity.getId() != null) {
                    outRmatContractChangeRepairEntity.setSourceBid(outRmatContractChangeRepairEntity.getId());
                }
                outRmatContractChangeRepairEntity.setId(null);
                outRmatContractChangeRepairEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getScrapList())) {
            for (OutRmatContractChangeScrapEntity outRmatContractChangeScrapEntity : outRmatContractChangeEntity.getScrapList()) {
                if (outRmatContractChangeScrapEntity.getId() != null) {
                    outRmatContractChangeScrapEntity.setSourceBid(outRmatContractChangeScrapEntity.getId());
                }
                outRmatContractChangeScrapEntity.setId(null);
                outRmatContractChangeScrapEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getOtherList())) {
            for (OutRmatContractChangeOtherEntity outRmatContractChangeOtherEntity : outRmatContractChangeEntity.getOtherList()) {
                if (outRmatContractChangeOtherEntity.getId() != null) {
                    outRmatContractChangeOtherEntity.setSourceBid(outRmatContractChangeOtherEntity.getId());
                }
                outRmatContractChangeOtherEntity.setId(null);
                outRmatContractChangeOtherEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getPaymentList())) {
            for (OutRmatContractChangePaymentEntity outRmatContractChangePaymentEntity : outRmatContractChangeEntity.getPaymentList()) {
                if (outRmatContractChangePaymentEntity.getId() != null) {
                    outRmatContractChangePaymentEntity.setSourceBid(outRmatContractChangePaymentEntity.getId());
                }
                outRmatContractChangePaymentEntity.setId(null);
                outRmatContractChangePaymentEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(outRmatContractChangeEntity.getClauseList())) {
            for (OutRmatContractChangeClauseEntity outRmatContractChangeClauseEntity : outRmatContractChangeEntity.getClauseList()) {
                if (outRmatContractChangeClauseEntity.getId() != null) {
                    outRmatContractChangeClauseEntity.setSourceBid(outRmatContractChangeClauseEntity.getId());
                }
                outRmatContractChangeClauseEntity.setId(null);
                outRmatContractChangeClauseEntity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
    }

    public void deleteOldCost(OutRmatContractChangeVO outRmatContractChangeVO) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.targetCost(outRmatContractChangeVO);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u65e7\u76ee\u6807\u6210\u672c\u5931\u8d25\uff01");
        }
    }

    public ExecutionVO targetCost(OutRmatContractChangeVO outRmatContractChangeVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(outRmatContractChangeVO.getId());
        totalVO.setTenantId(outRmatContractChangeVO.getTenantId());
        totalVO.setBillCode(outRmatContractChangeVO.getBillCode());
        totalVO.setBillType("BT220210000000005");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(outRmatContractChangeVO.getProjectId());
        totalVO.setOrgId(outRmatContractChangeVO.getOrgId());
        totalVO.setMoney(outRmatContractChangeVO.getContractMny());
        totalVO.setTaxMoney(outRmatContractChangeVO.getContractTaxMny());
        totalVO.setLinkUrl(this.baseHost + "ejc-assistrmat-frontend/#/contract/changeCard?id=" + outRmatContractChangeVO.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Boolean pushContract(OutRmatContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            this.contractService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-assistrmat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus() : "/ejc-assistrmat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            data.setPcCardUrl(url);
            OutRmatContractChangeRecordVO outRmatContractChangeRecordVO = this.queryChangeRecord(vo.getId());
            data.setTotalChangeMny(outRmatContractChangeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(outRmatContractChangeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub((BigDecimal)data.getTotalChangeTaxMny(), (BigDecimal)data.getTotalChangeMny()));
            data.setTaotalChangeScale(outRmatContractChangeRecordVO.getTotalChangeRate());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }
}

