/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractFreezeEntity;
import com.ejianc.business.assist.material.mapper.MaterialContractFreezeMapper;
import com.ejianc.business.assist.material.service.IMaterialContractFreezeService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractFreezeVO;
import com.ejianc.business.assist.material.vo.record.MaterialFreezeRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialContractFreezeService")
public class MaterialContractFreezeServiceImpl
extends BaseServiceImpl<MaterialContractFreezeMapper, MaterialContractFreezeEntity>
implements IMaterialContractFreezeService {
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_FREEZE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMaterialContractService contractService;

    @Override
    public MaterialContractFreezeVO saveOrUpdate(MaterialContractFreezeVO saveOrUpdateVO) {
        this.contractService.validateContract(saveOrUpdateVO.getContractId(), "\u51bb\u7ed3\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        MaterialContractFreezeEntity entity = (MaterialContractFreezeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialContractFreezeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (MaterialContractFreezeVO)BeanMapper.map((Object)((Object)entity), MaterialContractFreezeVO.class);
    }

    @Override
    public MaterialFreezeRecordVO queryFreezeRecord(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.contractService.selectById(id));
        MaterialFreezeRecordVO vo = new MaterialFreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialContractFreezeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, MaterialContractFreezeVO.class));
        return vo;
    }
}

