/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractFreezeEntity;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractFreezeMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFreezeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractFreezeVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractFreezeRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatContractFreezeService")
public class OutRmatContractFreezeServiceImpl
extends BaseServiceImpl<OutRmatContractFreezeMapper, OutRmatContractFreezeEntity>
implements IOutRmatContractFreezeService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PRORMAT_CONTRACT_FREEZE = "PRORMAT_CONTRACT_FREEZE";
    @Autowired
    private IOutRmatContractService contractService;

    @Override
    public OutRmatContractFreezeVO saveOrUpdate(OutRmatContractFreezeVO saveOrUpdateVO) {
        OutRmatContractFreezeEntity entity = (OutRmatContractFreezeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatContractFreezeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.addFreezeFlag(saveOrUpdateVO.getContractId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRORMAT_CONTRACT_FREEZE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.contractService.validateContract(saveOrUpdateVO.getContractId(), "\u51bb\u7ed3\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.saveOrUpdate((Object)entity, false);
        return (OutRmatContractFreezeVO)BeanMapper.map((Object)((Object)entity), OutRmatContractFreezeVO.class);
    }

    @Override
    public Boolean addFreezeFlag(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatContractFreezeEntity::getContractId, (Object)id);
        wrapper.notIn(OutRmatContractFreezeEntity::getBillState, Arrays.asList(1, 3));
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u51bb\u7ed3/\u89e3\u51bb\u5355\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u51bb\u7ed3/\u89e3\u51bb\u8bf7\u6c42\uff01");
        }
        return true;
    }

    @Override
    public OutRmatContractFreezeRecordVO queryFreezeRecord(Long id) {
        OutRmatContractEntity entity = (OutRmatContractEntity)((Object)this.contractService.selectById(id));
        OutRmatContractFreezeRecordVO vo = new OutRmatContractFreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatContractFreezeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, OutRmatContractFreezeVO.class));
        return vo;
    }
}

