/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.handler;

import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.IStoreService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.service.handler.IStoreManageHandler;
import com.ejianc.business.assist.store.util.StoreLockUtil;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.assist.store.vo.SurplusUpdateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InStoreHandler
implements IStoreManageHandler {
    @Autowired
    IFlowService flowService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        storeManageVO = this.storeService.setStoreAttr(storeManageVO);
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue() && !storeManageVO.getInOutTypeEnum().equals((Object)InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93)) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            flowVOList.forEach(flowVO -> {
                flowVO.setOutNum(BigDecimal.ZERO);
                flowVO.setOutLockNum(BigDecimal.ZERO);
                flowVO.setSurplusNum(flowVO.getNum());
                flowVO.setSurplusMny(flowVO.getMny());
                flowVO.setSurplusTaxMny(flowVO.getTaxMny());
                flowVO.setEstimatePrice(flowVO.getPrice());
                flowVO.setEstimateTaxPrice(flowVO.getTaxPrice());
            });
            List flowEntities = BeanMapper.mapList((Iterable)flowVOList, FlowEntity.class);
            boolean b = this.flowService.saveOrUpdateBatch(flowEntities);
            if (b) {
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.success((Object)storeManageVO);
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        CommonResponse<List<FlowEntity>> res = this.flowService.validateIsUse(sourceId, storeId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        List instoreList = (List)res.getData();
        List flowVOList = BeanMapper.mapList((Iterable)instoreList, FlowVO.class);
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)true);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
            storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            List delListIds = flowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.flowService.removeByIds(delListIds);
            CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
            return commonResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
    }
}

