/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.store.bean.StoreEntity;
import com.ejianc.business.assist.store.bean.SurplusEntity;
import com.ejianc.business.assist.store.service.IStoreService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"surplus"})
@Api(value="\u4ed3\u5e93\u5e93\u5b58\u8868", tags={"\u4ed3\u5e93\u5e93\u5b58\u8868"})
public class SurplusController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISurplusService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IStoreService storeService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IMaterialService materialService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SurplusVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SurplusVO saveOrUpdateVO) {
        SurplusEntity entity = (SurplusEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SurplusEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SurplusVO vo = (SurplusVO)BeanMapper.map((Object)((Object)entity), SurplusVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SurplusVO> queryDetail(@RequestParam Long id) {
        SurplusEntity entity = (SurplusEntity)((Object)this.service.selectById(id));
        SurplusVO vo = (SurplusVO)BeanMapper.map((Object)((Object)entity), SurplusVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SurplusVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SurplusVO surplusVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> queryList(@RequestBody QueryParam param) {
        Long storeId;
        Object value;
        Long cateParId;
        CommonResponse listCommonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        Long parentOrgId = null;
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("orgId", new Parameter("in", departmentIds));
        }
        Parameter materialCategoryIdPara = (Parameter)params.get("materialCategoryId");
        if (null != materialCategoryIdPara && materialCategoryIdPara.getValue() != null && (listCommonResponse = this.shareMaterialApi.queryCategoryListByPid(cateParId = Long.valueOf((value = materialCategoryIdPara.getValue()).toString()))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            List categoryIds = ((List)listCommonResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
            params.put("materialCategoryId", new Parameter("in", categoryIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List surplusVOS = BeanMapper.mapList((Iterable)page.getRecords(), SurplusVO.class);
        ArrayList<SurplusVO> surplusVOS1 = new ArrayList();
        if (surplusVOS != null && surplusVOS.size() > 0) {
            if (params.containsKey("storeId")) {
                storeId = Long.valueOf(((Parameter)params.get("storeId")).getValue().toString());
                StoreEntity storeEntity = (StoreEntity)((Object)this.storeService.selectById(storeId));
                parentOrgId = storeEntity.getParentOrgId();
            } else {
                parentOrgId = userContextCache.getOrgId();
            }
            surplusVOS1 = this.service.storeMny(surplusVOS, parentOrgId);
        }
        if (params.containsKey("storeId")) {
            storeId = Long.valueOf(((Parameter)params.get("storeId")).getValue().toString());
            this.service.getStoreNum(storeId, surplusVOS1);
        }
        surplusVOS1.forEach(t -> {
            t.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)t.getSurplusNum()));
            t.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)t.getSurplusMny(), (BigDecimal)t.getSurplusNum()));
            t.setSurplusKcNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
            t.setSurplusXzNum(ComputeUtil.safeSub((BigDecimal)t.getSurplusKcNum(), (BigDecimal)t.getRentNum()));
        });
        pageData.setRecords(surplusVOS1);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Surplus-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSurplusData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SurplusVO>> refSurplusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long storeId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"storeId")) {
                storeId = _con.getLong("storeId");
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("surplusNum", new Parameter("gt", (Object)BigDecimal.ZERO));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List surplusVOS = BeanMapper.mapList((Iterable)page.getRecords(), SurplusVO.class);
        surplusVOS.forEach(t -> {
            t.setSurplusHasOutLockNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
            t.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusMny(), (BigDecimal)t.getOutLockMny()));
            t.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)t.getOutLockTaxMny()));
        });
        if (storeId != null) {
            this.service.getStoreNum(storeId, surplusVOS);
            surplusVOS.forEach(t -> {
                t.setSurplusKcNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
                t.setSurplusXzNum(ComputeUtil.safeSub((BigDecimal)t.getSurplusKcNum(), (BigDecimal)t.getRentNum()));
                t.setSurplusNum(t.getSurplusXzNum());
            });
        } else {
            this.service.getStoreNum(surplusVOS);
            surplusVOS.forEach(t -> {
                t.setSurplusKcNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
                t.setSurplusXzNum(ComputeUtil.safeSub((BigDecimal)t.getSurplusKcNum(), (BigDecimal)t.getRentNum()));
                t.setSurplusNum(t.getSurplusXzNum());
            });
        }
        pageData.setRecords(surplusVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

