/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.start.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.start.bean.OutRmatStartEntity;
import com.ejianc.business.outrmat.start.mapper.OutRmatStartMapper;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.outrmat.start.vo.OutRmatStartDetailVO;
import com.ejianc.business.outrmat.start.vo.OutRmatStartVO;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatStartService")
public class OutRmatStartServiceImpl
extends BaseServiceImpl<OutRmatStartMapper, OutRmatStartEntity>
implements IOutRmatStartService {
    private static final String BILL_CODE = "OUTRMAT_START";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutRmatMaterialService materialService;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IReceiptsApi receiptsApi;
    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u542f\u7528\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u542f\u7528\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/start/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/start/billDel";

    @Override
    public OutRmatStartVO saveOrUpdate(OutRmatStartVO saveOrUpdateVO) {
        this.validateContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u542f\u7528\u5355.getName(), saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        this.validateNum(saveOrUpdateVO);
        OutRmatStartEntity entity = (OutRmatStartEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatStartEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        super.saveOrUpdate((Object)entity, false);
        return (OutRmatStartVO)BeanMapper.map((Object)((Object)entity), OutRmatStartVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u542f\u7528\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateTime(OutRmatStartVO outRmatStartVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", outRmatStartVO.getContractId());
        if (outRmatStartVO.getId() != null) {
            params.put("billType", "\u542f\u7528\u5355");
            params.put("billId", outRmatStartVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)outRmatStartVO.getStartTime(), (Date)lastDate, maxTimeMap, (Date)outRmatStartVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)outRmatStartVO.getStartTime()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        for (OutRmatStartDetailVO vo : outRmatStartVO.getDetailList()) {
            if (!ValidateUtil.compareDate((Date)vo.getStartTime(), (Date)lastDate, maxTimeMap, (Date)vo.getCreateTime())) continue;
            throw new BusinessException(DateUtil.formatDate((Date)vo.getStartTime()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatStartEntity entity) {
        if (entity.getRentType().equals("1")) {
            OutRmatStartEntity map = (OutRmatStartEntity)((Object)BeanMapper.map((Object)((Object)entity), OutRmatStartEntity.class));
            map.setOrgId(entity.getProjectDeptId());
            map.setOrgCode(entity.getProjectDeptCode());
            map.setOrgName(entity.getProjectDeptName());
            map.setParentOrgCode(entity.getProjectOrgCode());
            map.setParentOrgId(entity.getProjectOrgId());
            map.setParentOrgName(entity.getProjectOrgName());
            this.logger.info("\u63a8\u9001\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + JSONObject.toJSONString((Object)((Object)map)) + "----" + BILL_NAME);
            Boolean syncFlag = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)((Object)map)), BILL_NAME).isSuccess();
            return syncFlag;
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatStartEntity entity = (OutRmatStartEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatStartEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatStartEntity entity) {
        if (entity.getRentType().equals("1")) {
            this.logger.info("\u5220\u9664\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + entity.getId() + "----" + BILL_NAME);
            Boolean delSuc = this.receiptsApi.delReceipts(entity.getId(), BILL_NAME).isSuccess();
            this.logger.info("\u5220\u9664\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + delSuc);
            return delSuc;
        }
        return true;
    }

    private String validateNum(OutRmatStartVO outRmatStartVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)outRmatStartVO.getContractId()));
        List<MaterialVO> list = this.materialService.queryCheckList(param, "start");
        Map map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        for (OutRmatStartDetailVO vo : outRmatStartVO.getDetailList()) {
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getTransScale();
            if (!map.containsKey(key) || vo.getNum().compareTo(((MaterialVO)map.get(key)).getRefNum()) <= 0) continue;
            throw new BusinessException("\u5b50\u8868\u6570\u91cf\u5927\u4e8e\u53ef\u53c2\u7167\u6570\u91cf");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String updateBillSupSignSync(Map<String, String> map) {
        String billId = map.get("billId");
        OutRmatStartEntity entity = (OutRmatStartEntity)((Object)super.selectById((Serializable)Long.valueOf(billId)));
        String msg = this.pushSupUtil.updateBillSupSignSync(map, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatStartEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }
}

