package com.ejianc.business.outrmat.settle.service;

import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSettleRecordVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteOtherVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
public interface IOutRmatSettleService extends IBaseService<OutRmatSettleEntity> {

    OutRmatSettleVO saveOrUpdate(OutRmatSettleVO saveOrUpdateVO);
    
    String validateContract(Long contractId, Long billId);
    List<OutRmatCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate);
    List<OutRmatRestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate);

    List<OutRmatRestituteOtherVO> queryRestituteOtherData(Long contractId, String lastSettleDate, String settleDate);

    List<OutRmatLoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate);

    OutRmatSettleVO queryLastSettleTaxMny(Long contractId, Long billId);

    OutRmatContractSettleRecordVO querySettleRecord(Long id);

    Boolean pushBillToSupCenter(OutRmatSettleEntity entity);

    Boolean delPushBill(OutRmatSettleEntity entity);

    String updateBillSupSignSyncInfo(Map<String,String> map);
    
}
