/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.restitute.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.mapper.OutRmatRestituteMapper;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteDetailVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatRestituteService")
public class OutRmatRestituteServiceImpl
extends BaseServiceImpl<OutRmatRestituteMapper, OutRmatRestituteEntity>
implements IOutRmatRestituteService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "out-rmat-restitute";
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private StoreManageService storeManageService;
    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/outRmatRestitute/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/outRmatRestitute/billDel";

    @Override
    public List<StoreManageVO> getStoreManageVOList(OutRmatRestituteVO vo, Boolean outEffectiveON) {
        Map<Long, List<OutRmatRestituteDetailVO>> detailMap;
        ArrayList<StoreManageVO> storeManageVOList = new ArrayList<StoreManageVO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getRestituteDetailList()) && MapUtils.isNotEmpty(detailMap = vo.getRestituteDetailList().stream().filter(t -> null != t.getStoreId()).collect(Collectors.groupingBy(OutRmatRestituteDetailVO::getStoreId)))) {
            for (Long storeId : detailMap.keySet()) {
                List detailVOList = detailMap.get(storeId).stream().filter(t -> null != t.getSourceType() && 0 == t.getSourceType()).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(detailVOList)) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(storeId);
                storeManageVO.setSourceId(vo.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9000\u8d54);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
                for (OutRmatRestituteDetailVO t2 : detailVOList) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9000\u8d54, (Integer)0);
                    flowVO.setStoreId(t2.getStoreId());
                    flowVO.setStoreName(t2.getStoreName());
                    flowVO.setProjectId(vo.getProjectId());
                    flowVO.setProjectName(vo.getProjectName());
                    flowVO.setOrgId(vo.getOrgId());
                    flowVO.setOrgName(vo.getOrgName());
                    flowVO.setParentOrgId(vo.getParentOrgId());
                    flowVO.setParentOrgName(vo.getParentOrgName());
                    flowVO.setEmployeeId(vo.getEmployeeId());
                    flowVO.setEmployeeName(vo.getEmployeeName());
                    flowVO.setMaterialCategoryId(t2.getMaterialTypeId());
                    flowVO.setMaterialCategoryName(t2.getMaterialTypeName());
                    flowVO.setMaterialId(t2.getMaterialId());
                    flowVO.setMaterialName(t2.getMaterialName());
                    flowVO.setMaterialSpec(t2.getSpec());
                    flowVO.setMaterialUnitId(t2.getUnitMId());
                    flowVO.setMaterialUnitName(t2.getUnitMName());
                    flowVO.setSourceBillDetailRemark(t2.getMemo());
                    flowVO.setTaxPrice(BigDecimal.ZERO);
                    flowVO.setPrice(BigDecimal.ZERO);
                    flowVO.setNum(ComputeUtil.safeDiv((BigDecimal)t2.getScrapNum(), (BigDecimal)t2.getTransScale()));
                    flowVO.setTaxMny(BigDecimal.ZERO);
                    flowVO.setMny(BigDecimal.ZERO);
                    flowVO.setTax(BigDecimal.ZERO);
                    flowVO.setTenantId(t2.getTenantId());
                    flowVO.setSourceId(vo.getId());
                    flowVO.setSourceDetailId(t2.getId());
                    flowVO.setSourceBillCode(vo.getBillCode());
                    flowVO.setSourceBillDate(vo.getRestituteDate());
                    flowVO.setRowState(t2.getRowState());
                    flowVO.setSourceBillRemark(vo.getMemo());
                    if (BigDecimal.ZERO.compareTo(flowVO.getNum()) == 0 && outEffectiveON.booleanValue()) continue;
                    flowVOS.add(flowVO);
                }
                if (!CollectionUtils.isNotEmpty(flowVOS)) continue;
                storeManageVO.setFlowVOList(flowVOS);
                storeManageVOList.add(storeManageVO);
            }
        }
        return storeManageVOList;
    }

    @Override
    public OutRmatRestituteVO saveOrUpdate(OutRmatRestituteVO saveOrUpdateVO) {
        List<StoreManageVO> storeManageVOList;
        this.outRmatMaterialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        this.validateNum(saveOrUpdateVO);
        OutRmatRestituteEntity entity = (OutRmatRestituteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatRestituteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getRestituteDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        boolean b = super.saveOrUpdate((Object)entity, false);
        OutRmatRestituteVO map = (OutRmatRestituteVO)BeanMapper.map((Object)((Object)entity), OutRmatRestituteVO.class);
        List detailVOS = saveOrUpdateVO.getRestituteDetailList().stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            map.getRestituteDetailList().addAll(detailVOS);
        }
        if (!this.flowService.insertRestFlow((OutRmatRestituteEntity)((Object)BeanMapper.map((Object)map, OutRmatRestituteEntity.class)), BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode(), RmatCommonConsts.NO).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (b && CollectionUtils.isNotEmpty(storeManageVOList = this.getStoreManageVOList(map, false))) {
            this.logger.info("\u5e93\u5b58\u6240\u6709\u5165\u53c2\uff1a" + JSONObject.toJSONString(storeManageVOList));
            for (StoreManageVO storeManageVO : storeManageVOList) {
                this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                CommonResponse<StoreManageVO> response = this.storeManageService.inOutStore(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        OutRmatRestituteVO vo = (OutRmatRestituteVO)BeanMapper.map((Object)((Object)entity), OutRmatRestituteVO.class);
        return vo;
    }

    @Override
    public void delete(List<OutRmatRestituteVO> vos) {
        List<Long> ids;
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatRestituteVO vo : vos) {
                Map<Long, List<OutRmatRestituteDetailEntity>> detailMap;
                OutRmatRestituteEntity entity = (OutRmatRestituteEntity)((Object)super.selectById((Serializable)vo.getId()));
                if (!CollectionUtils.isNotEmpty(entity.getRestituteDetailList()) || !MapUtils.isNotEmpty(detailMap = entity.getRestituteDetailList().stream().filter(t -> null != t.getStoreId()).collect(Collectors.groupingBy(OutRmatRestituteDetailEntity::getStoreId)))) continue;
                for (Long storeId : detailMap.keySet()) {
                    List detailVOList = detailMap.get(storeId).stream().filter(t -> null != t.getSourceType() && 0 == t.getSourceType() && BigDecimal.ZERO.compareTo(ComputeUtil.safeDiv((BigDecimal)t.getScrapNum(), (BigDecimal)t.getTransScale())) != 0).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(detailVOList)) continue;
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(storeId);
                    storeManageVO.setSourceId(entity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9000\u8d54);
                    storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
                    ArrayList<Long> longs = new ArrayList<Long>();
                    longs.add(entity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                    CommonResponse<StoreManageVO> response = this.storeManageService.inOutStoreRollback(storeManageVO);
                    if (response.isSuccess()) continue;
                    throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
                }
            }
        }
        if (!this.flowService.delFlow(ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList()), BillTypeEnum.\u79df\u51fa\u9000\u8d54\u5355.getCode()).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        super.removeByIds(ids, true);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9000\u8d54\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateTime(OutRmatRestituteVO restituteVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", restituteVO.getContractId());
        if (restituteVO.getId() != null) {
            params.put("billType", "\u9000\u8d54\u5355");
            params.put("billId", restituteVO.getId());
        }
        Date lastDate = this.outRmatMaterialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.outRmatMaterialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)restituteVO.getStopDate(), (Date)lastDate, maxTimeMap, (Date)restituteVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)restituteVO.getStopDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        for (OutRmatRestituteDetailVO vo : restituteVO.getRestituteDetailList()) {
            if (!ValidateUtil.compareDate((Date)vo.getDate(), (Date)lastDate, maxTimeMap, (Date)vo.getCreateTime())) continue;
            throw new BusinessException(DateUtil.formatDate((Date)vo.getDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatRestituteEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatRestituteEntity entity = (OutRmatRestituteEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatRestituteEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatRestituteEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public String updateBillSupSignSync(Map<String, String> map) {
        String billId = map.get("billId");
        OutRmatRestituteEntity entity = (OutRmatRestituteEntity)((Object)super.selectById((Serializable)Long.valueOf(billId)));
        String msg = this.pushSupUtil.updateBillSupSignSync(map, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatRestituteEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }

    private String validateNum(OutRmatRestituteVO restituteVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)restituteVO.getContractId()));
        List<MaterialVO> list = this.outRmatMaterialService.queryCheckList(param, "rest");
        Map map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getUseStatus() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        BigDecimal num = BigDecimal.ZERO;
        for (OutRmatRestituteDetailVO vo : restituteVO.getRestituteDetailList()) {
            num = ComputeUtil.safeSub((BigDecimal)vo.getFullNum(), (BigDecimal[])new BigDecimal[]{vo.getMaintainNum(), vo.getScrapNum()});
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
            if (!map.containsKey(key) || num.compareTo(((MaterialVO)map.get(key)).getRefNum()) <= 0) continue;
            throw new BusinessException("\u5b50\u8868\u6570\u91cf\u5927\u4e8e\u53ef\u53c2\u7167\u6570\u91cf");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

