/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service;

import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.IInOutService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.service.handler.IStoreManageHandler;
import com.ejianc.business.assist.store.service.handler.StoreManageFactory;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.assist.store.vo.SurplusUpdateVO;
import com.ejianc.business.assist.store.vo.UseCalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreManageService {
    @Autowired
    private StoreManageFactory storeManageFactory;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    IFlowService flowService;

    public CommonResponse<StoreManageVO> inOutStore(StoreManageVO storeManageVO) {
        CommonResponse<StoreManageVO> validateRes = this.validateParam(storeManageVO, false);
        if (!validateRes.isSuccess()) {
            return validateRes;
        }
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        IStoreManageHandler storeManageHandler = this.storeManageFactory.getHandler(inOutTypeEnum);
        CommonResponse<StoreManageVO> handle = storeManageHandler.handle(storeManageVO);
        return handle;
    }

    public CommonResponse<StoreManageVO> inOutStoreRollback(StoreManageVO storeManageVO) {
        CommonResponse<StoreManageVO> validateRes = this.validateParam(storeManageVO, true);
        if (!validateRes.isSuccess()) {
            return validateRes;
        }
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        IStoreManageHandler storeManageHandler = this.storeManageFactory.getHandler(inOutTypeEnum);
        CommonResponse<StoreManageVO> handle = storeManageHandler.handleRollback(storeManageVO);
        return handle;
    }

    public CommonResponse<StoreManageVO> surplusMaterialPrice(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> response = this.surplusService.validateStoreSurplusByOutLock(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        UseCalculateVO useCalculateVO = this.surplusService.useCalculate(storeManageVO);
        storeManageVO.setUseMaterialPriceVOList(useCalculateVO.getUseMaterialPriceVOList());
        return CommonResponse.success((Object)storeManageVO);
    }

    public CommonResponse<StoreManageVO> updateShareMny(StoreManageVO storeManageVO) {
        storeManageVO = this.flowService.updateShareMny(storeManageVO);
        return CommonResponse.success((Object)storeManageVO);
    }

    private CommonResponse<StoreManageVO> validateParam(StoreManageVO storeManageVO, boolean isRollBack) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        List sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        if (storeId == null) {
            return CommonResponse.error((String)"\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)sourceIdsForRollBack) && sourceId == null) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5355\u636e\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (inOutTypeEnum == null) {
            return CommonResponse.error((String)"\u51fa\u5165\u5e93\u679a\u4e3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<StoreManageVO> turnSurplusMaterialPrice(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> response = this.surplusService.validateStoreSurplusByOutLock(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        UseCalculateVO useCalculateVO = this.surplusService.useTurnCalculate(storeManageVO);
        storeManageVO.setUseMaterialPriceVOList(useCalculateVO.getUseMaterialPriceVOList());
        return CommonResponse.success((Object)storeManageVO);
    }
}

