package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.OwnDetailEntity;
import com.ejianc.business.assist.material.bean.OwnEntity;
import com.ejianc.business.assist.material.mapper.OwnMapper;
import com.ejianc.business.assist.material.service.IOwnDetailService;
import com.ejianc.business.assist.material.service.IOwnService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.material.vo.OwnDetailVO;
import com.ejianc.business.assist.material.vo.OwnVO;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.pro.ownrmat.api.IAmortizationApi;
import com.ejianc.business.pro.ownrmat.vo.AmortizationVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 自有材料摊销
 *
 * @author generator
 */
@Service("ownService")
public class OwnServiceImpl extends BaseServiceImpl<OwnMapper, OwnEntity> implements IOwnService {
    private static final String BILL_CODE = "ASSIST_MATERIAL_OWN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOwnDetailService ownDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAmortizationApi amortizationApi;
    @Autowired
    private IAllotOutService allotOutService;
    @Autowired
    private IFlowService flowService;
//    @Autowired
//    private IHandleService handleService;
//    @Autowired
//    private IValidateService validateContract;

    @Override
    public OwnVO saveOrUpdate(OwnVO saveorUpdateVO) {
        //  上下文组织有未生效的摊销单、处置单、调出单时，不能新增摊销单
//        if (allotOutCheck(saveorUpdateVO.getProjectId())) {
//            throw new BusinessException("上下文组织有未生效的调出单，不能新增摊销单");
//        }
//        if (handleCheck(saveorUpdateVO.getProjectId())) {
//            throw new BusinessException("上下文组织有未生效的处置单，不能新增摊销单");
//        }
//        validateContract.validateProject(saveorUpdateVO.getProjectId(), MaterialConstant.自有材料摊销, saveorUpdateVO.getId(), MaterialConstant.保存);
//        // 校验必须大于最大单据日期
//        this.validateTime(saveorUpdateVO, MaterialConstant.保存);

        Long tenantId = InvocationInfoProxy.getTenantid();
        OwnEntity entity = null;
        String operateType = null;

        LambdaQueryWrapper<OwnEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(OwnEntity::getOrgId, saveorUpdateVO.getOrgId());
        lambd.notIn(OwnEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, OwnEntity.class);
            operateType = "edit";
            lambd.ne(OwnEntity::getId, saveorUpdateVO.getId());
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantId, saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, OwnEntity.class);
            operateType = "add";
        }
        List<OwnEntity> list = super.list(lambd);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("上下文组织有未生效的摊销单，不能新增摊销单");
        }
        List<OwnDetailVO> detailList = saveorUpdateVO.getOwnDetailList();
        String categoryName = "";
        List<String> nameList = new ArrayList<>();
        for (OwnDetailVO detailVO : detailList) {
            if (!nameList.contains(detailVO.getMaterialTypeName())) {
                if (categoryName.length() > 0) {
                    categoryName = categoryName + "," + detailVO.getMaterialTypeName();
                } else {
                    categoryName = detailVO.getMaterialTypeName();
                }
                nameList.add(detailVO.getMaterialTypeName());
                if (categoryName.length() > 100) {
                    break;
                }
            }
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByBatchId(entity.getId());
        }
        List<OwnDetailEntity> detailEntityList = BeanMapper.mapList(detailList, OwnDetailEntity.class);
        if (detailEntityList.size() > 0) {
            for (OwnDetailEntity detailEntity : detailEntityList) {
                detailEntity.setOwnId(entity.getId());
            }
            ownDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return queryDetail(entity.getId());
    }

    //周转材调出
//    private Boolean allotOutCheck(Long projectId) {
//        LambdaQueryWrapper<AllotOutEntity> lambd = new LambdaQueryWrapper<>();
//        lambd.eq(AllotOutEntity::getProjectId, projectId);
//        lambd.notIn(AllotOutEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
//        List<AllotOutEntity> list = allotOutService.list(lambd);
//        return CollectionUtils.isNotEmpty(list);
//    }

    //处置单
//    private Boolean handleCheck(Long projectId) {
//        LambdaQueryWrapper<HandleEntity> lambd = new LambdaQueryWrapper<>();
//        lambd.eq(HandleEntity::getProjectId, projectId);
//        lambd.notIn(HandleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
//        List<HandleEntity> list = handleService.list(lambd);
//        return CollectionUtils.isNotEmpty(list);
//    }
    @Override
    public String validateTime(OwnVO startVO, String type) {
//        Map<String, Object> params = new HashMap<>();
//        params.put("projectId", startVO.getProjectId());
//        if(startVO.getId() != null){
//            params.put("billType", MaterialConstant.自有材料摊销);
//            params.put("billId", startVO.getId());
//        }
//        Date lastDate = validateContract.getLastDate(params);
//        Map<Date, Date> maxTimeMap = validateContract.getMaxTime(params);
//
//        if (lastDate == null) return "未获取最大单据日期！";
//        if(ValidateUtil.compareDate(startVO.getProcessingDate(), lastDate, maxTimeMap, startVO.getCreateTime())){
//            throw new BusinessException(DateUtil.formatDate(startVO.getProcessingDate())
//                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
//        }
        return "校验通过！";
    }

    @Override
    public OwnVO queryDetail(Long id) {
        OwnEntity batchPlanEntity = super.selectById(id);
        OwnVO vo = BeanMapper.map(batchPlanEntity, OwnVO.class);
        return vo;
    }

    @Override
    public List<OwnDetailVO> refAmortizationList(QueryParam param, Long orgId, String amortizationCycle) {
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<Integer> inOutType = new ArrayList<>();
        inOutType.add(InOutTypeEnum.周转材收料入库.getInOutType());
        inOutType.add(InOutTypeEnum.周转材调拨入库.getInOutType());
        inOutType.add(InOutTypeEnum.原材料加工入库.getInOutType());
        inOutType.add(InOutTypeEnum.周转材盘盈入库.getInOutType());
        inOutType.add(InOutTypeEnum.其他入库.getInOutType());
        param.getParams().put("inOutType", new Parameter(QueryParam.IN, inOutType));
        param.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, InOutTypeEnum.周转材收料入库.getInOutFlag()));

        List<FlowEntity> flowEntityList = flowService.queryList(param);
        List<FlowVO> flowList = BeanMapper.mapList(flowEntityList, FlowVO.class);
        List<OwnDetailVO> res = new ArrayList<>();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        List<Long> materialIds = new ArrayList<>();

        for (FlowVO vo : flowList) {
            BigDecimal num = ComputeUtil.safeAdd(vo.getOutLockNum(), vo.getSurplusNum());
            if (num == null) {
                num = BigDecimal.ZERO;
            }
            // 数量大于0,净值含税大于0,上次没有摊销或者有摊销但是小于当前摊销周期
            if (num.compareTo(BigDecimal.ZERO) > 0
                    && vo.getNetTaxMny() != null
                    && vo.getNetTaxMny().compareTo(BigDecimal.ZERO) > 0
                    && ((vo.getLastShareDate() == null && DateUtil.compareDateStr(amortizationCycle, sdf.format(vo.getSourceBillDate())) >= 0)
                    || (vo.getLastShareDate() != null && DateUtil.compareDateStr(amortizationCycle, sdf.format(vo.getLastShareDate())) > 0))
                    ) {
                BigDecimal purchasePrice = vo.getPurchasePrice() == null ? BigDecimal.ZERO : vo.getPurchasePrice();
                BigDecimal purchaseTaxPrice = vo.getPurchaseTaxPrice() == null ? BigDecimal.ZERO : vo.getPurchaseTaxPrice();
                OwnDetailVO detailVO = new OwnDetailVO();
                detailVO.setId(vo.getId());
                detailVO.setSourceCode(vo.getSourceBillCode());
                detailVO.setMaterialTypeId(vo.getMaterialCategoryId());
                detailVO.setMaterialTypeCode(vo.getMaterialCategoryCode());
                detailVO.setMaterialTypeName(vo.getMaterialCategoryName());
                detailVO.setMaterialId(vo.getMaterialId());
                detailVO.setMaterialCode(vo.getMaterialCode());
                detailVO.setMaterialName(vo.getMaterialName());
                detailVO.setSpec(vo.getMaterialSpec());
                detailVO.setUnitId(vo.getMaterialUnitId());
                detailVO.setUnit(vo.getMaterialUnitName());
                detailVO.setOriginalValue(ComputeUtil.safeMultiply(vo.getSurplusNum(), purchasePrice));// 原值(无税)
                detailVO.setOriginalValueTax(ComputeUtil.safeMultiply(vo.getSurplusNum(), purchaseTaxPrice));// 原值(含税)
                detailVO.setNetWorth(vo.getNetMny() == null ? BigDecimal.ZERO : vo.getNetMny());// 净值(无税)
                detailVO.setNetWorthTax(vo.getNetTaxMny() == null ? BigDecimal.ZERO : vo.getNetTaxMny());// 净值(含税)
                detailVO.setResidualValue(null);// 残值(无税)
                detailVO.setResidualValueTax(null);// 残值(含税)
                detailVO.setOriginalValuePrice(purchasePrice);// 原值单价(无税)
                detailVO.setOriginalValuePriceTax(purchaseTaxPrice);// 原值单价(含税)
                // 税率 = (含税/无税)-1
                BigDecimal taxRate = ComputeUtil.safeSub(ComputeUtil.safeDiv(detailVO.getOriginalValueTax(), detailVO.getOriginalValue()), BigDecimal.ONE);
                if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                    taxRate = BigDecimal.ZERO;
                } else {
                    taxRate = ComputeUtil.safeMultiply(taxRate, new BigDecimal(100));
                }
                detailVO.setTaxRate(taxRate);
                detailVO.setNum(vo.getSurplusNum());// 数量
                detailVO.setLastAmortizationCycle(vo.getLastShareDate() == null ? null : sdf.format(vo.getLastShareDate()));// 上次摊销周期
                detailVO.setAmortizationRate(null);// 本次摊销比例
                detailVO.setAmortizationMny(null);// 本次摊销金额(无税)
                detailVO.setAmortizationMnyTax(null);// 本次摊销金额(含税)
                detailVO.setMemo(vo.getSourceBillDetailRemark());// 备注
                detailVO.setSourceId(vo.getId());

                int amortizationNum = 0; // 本次摊销周期数
                int usedAmortizationNum = 0; // 已生效摊销周期数
                if (vo.getLastShareDate() != null) {
                    amortizationNum = DateUtil.subMonth(sdf.format(vo.getLastShareDate()), amortizationCycle, sdf);
                    usedAmortizationNum = DateUtil.subMonth(sdf.format(vo.getSourceBillDate()), sdf.format(vo.getLastShareDate()), sdf) + 1;
                } else {
                    amortizationNum = DateUtil.subMonth(sdf.format(vo.getSourceBillDate()), amortizationCycle, sdf) + 1;
                }
                detailVO.setAmortizationNum(amortizationNum); // 摊销周期数
                detailVO.setUsedAmortizationNum(usedAmortizationNum); // 已生效摊销周期数

                detailVO.setFlowSourceId(vo.getSourceId());
                detailVO.setFlowSourceDetailId(vo.getSourceDetailId());

                res.add(detailVO);
                materialIds.add(vo.getMaterialId());
            }
        }
        if (res.size() > 0) {
            ResidualVO vo = new ResidualVO();
            vo.setOrgId(orgId);
            vo.setMaterialIds(materialIds);
            CommonResponse<Map<Long, AmortizationVO>> residualCom = amortizationApi.getResidualRate(vo);
            Map<Long, AmortizationVO> residualRate = new HashMap<>();
            if(residualCom.isSuccess()){
                residualRate = residualCom.getData();
            } else {
                throw new BusinessException("查询残值率失败！");
            }
            if (residualRate.size() > 0) {
                for (OwnDetailVO detailVO : res) {
                    if (residualRate.containsKey(detailVO.getMaterialId())) {
                        detailVO.setUsePeriod(residualRate.get(detailVO.getMaterialId()).getUsePeriod());// 使用年限（月）
                        detailVO.setResidualValueRate(residualRate.get(detailVO.getMaterialId()).getResidualValueRate());// 残值率
                        // 有设置残值率
                        // 原值 * 残值率 = 残值
                        detailVO.setResidualValue(ComputeUtil.safeMultiply(detailVO.getOriginalValue(), ComputeUtil.safeDiv(detailVO.getResidualValueRate(), new BigDecimal(100))));// 残值(无税)
                        detailVO.setResidualValueTax(ComputeUtil.safeMultiply(detailVO.getOriginalValueTax(), ComputeUtil.safeDiv(detailVO.getResidualValueRate(), new BigDecimal(100))));// 残值(含税)
                    } else {
                        detailVO.setResidualValue(BigDecimal.ZERO);// 残值(无税)
                        detailVO.setResidualValueTax(BigDecimal.ZERO);// 残值(含税)
                    }
                }
            }
        }
        return res;
    }

    @Override
    public String getLastAmortizationCycle(Long orgId, Long id) {
        String lastAmortizationCycle = baseMapper.getLastAmortizationCycle(orgId, id);
        return lastAmortizationCycle;
    }
}
