/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.bean.InOutEntity;
import com.ejianc.business.assist.store.bean.StoreCheckDetailEntity;
import com.ejianc.business.assist.store.bean.StoreCheckEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.IInOutService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeCheck")
public class StoreCheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private IInOutService iInOutService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IRmatFlowService rmatFlowService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-----");
        StoreCheckEntity storeCheckEntity = (StoreCheckEntity)((Object)this.checkService.selectById(billId));
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)storeCheckEntity.getCreateTime());
        String checkDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)storeCheckEntity.getCheckDate());
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.ne((Object)"id", (Object)storeCheckEntity.getId());
        checkWrapper.eq((Object)"store_id", (Object)storeCheckEntity.getStoreId());
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))", new Object[0]);
        List checkList = this.checkService.list((Wrapper)checkWrapper);
        if (checkList.size() > 0) {
            return CommonResponse.error((String)"\u5b58\u5728\u5927\u4e8e\u8be5\u76d8\u70b9\u5355\u76d8\u70b9\u65e5\u671f\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-----");
        StoreCheckEntity storeCheckEntity = (StoreCheckEntity)((Object)this.checkService.selectById(billId));
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)storeCheckEntity.getCreateTime());
        String checkDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)storeCheckEntity.getCheckDate());
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.ne((Object)"id", (Object)storeCheckEntity.getId());
        checkWrapper.eq((Object)"store_id", (Object)storeCheckEntity.getStoreId());
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))", new Object[0]);
        List checkList = this.checkService.list((Wrapper)checkWrapper);
        if (checkList.size() > 0) {
            return CommonResponse.error((String)"\u5b58\u5728\u5927\u4e8e\u8be5\u76d8\u70b9\u5355\u76d8\u70b9\u65e5\u671f\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.checkService.selectById(billId));
        List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        ArrayList outList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(item);
            }
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                outList.add(item);
            }
        });
        this.logger.info("\u5165\u5e93\u96c6\u5408\u4f53\uff1a" + JSONObject.toJSONString(subList));
        this.logger.info("\u51fa\u5e93\u96c6\u5408\u4f53\uff1a" + JSONObject.toJSONString(outList));
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(entity.getId());
        if (subList.size() > 0) {
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u76d8\u76c8\u5165\u5e93);
            ArrayList flowVOS = new ArrayList();
            subList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u76d8\u76c8\u5165\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setMaterialUnitId(item.getUnit());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setNum(item.getInventory());
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"store_id", (Object)entity.getStoreId());
                wrapper.eq((Object)"material_id", (Object)item.getMaterialId());
                wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
                wrapper.orderByDesc((Object)"source_bill_date");
                wrapper.last("limit 0,1");
                FlowEntity flowEntity = (FlowEntity)((Object)((Object)this.flowService.list((Wrapper)wrapper).get(0)));
                flowVO.setTaxPrice(flowEntity.getTaxPrice());
                flowVO.setPrice(flowEntity.getPrice());
                flowVO.setTaxRate(flowEntity.getTaxRate());
                flowVO.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)flowVO.getTaxPrice(), (BigDecimal)item.getInventory()));
                flowVO.setMny(ComputeUtil.safeMultiply((BigDecimal)flowVO.getPrice(), (BigDecimal)item.getInventory()));
                flowVO.setTax(ComputeUtil.safeSub((BigDecimal)flowVO.getTaxMny(), (BigDecimal)flowVO.getMny()));
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            storeManageVO.setSourceId(billId);
            storeManageVO.setSourceIdsForRollBack(longs);
            this.storeManageService.inOutStore(storeManageVO);
        }
        if (outList.size() > 0) {
            this.logger.info("id\u96c6\u5408\u4f53\uff1a" + JSONObject.toJSONString(longs));
            this.checkService.checkOut(longs);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<StoreManageVO> storeManageVOCommonResponse;
        StoreCheckEntity storeCheckEntity = (StoreCheckEntity)((Object)this.checkService.selectById(billId));
        String checkDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)storeCheckEntity.getCheckDate());
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)storeCheckEntity.getCreateTime());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_id", (Object)billId);
        wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        List list = this.flowService.list((Wrapper)wrapper);
        List inIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List inMaterialIds = list.stream().map(FlowEntity::getMaterialId).collect(Collectors.toList());
        if (inIds.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"in_bill_id", (Object)billId);
            queryWrapper.in((Object)"in_flow_id", inIds);
            List entities = this.iInOutService.list((Wrapper)queryWrapper);
            for (InOutEntity entity : entities) {
                if (entity.getOutNum().compareTo(BigDecimal.ZERO) <= 0 && entity.getOutLockNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                return CommonResponse.error((String)"\u8be5\u76d8\u70b9\u5355\u7684\u5165\u5e93\u7269\u8d44\u5df2\u88ab\u5360\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
            QueryWrapper wrapper2 = new QueryWrapper();
            wrapper2.orderByDesc((Object)"create_time");
            wrapper2.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_OUT);
            wrapper2.in((Object)"material_id", inMaterialIds);
            wrapper2.eq((Object)"store_id", (Object)storeCheckEntity.getStoreId());
            wrapper2.ne((Object)"source_id", (Object)billId);
            wrapper2.apply(" (create_time > '" + createTime + "')", new Object[0]);
            List list1 = this.flowService.list((Wrapper)wrapper2);
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                return CommonResponse.error((String)"\u7269\u8d44\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
            QueryWrapper wrapper3 = new QueryWrapper();
            wrapper3.orderByDesc((Object)"create_time");
            wrapper3.eq((Object)"bill_type_code", (Object)BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getCode());
            wrapper3.in((Object)"material_id", inMaterialIds);
            wrapper3.eq((Object)"store_id", (Object)storeCheckEntity.getStoreId());
            wrapper3.apply(" (create_time > '" + createTime + "')", new Object[0]);
            List list2 = this.rmatFlowService.list((Wrapper)wrapper3);
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                return CommonResponse.error((String)"\u7269\u6599\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
        }
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"store_id", (Object)storeCheckEntity.getStoreId());
        ArrayList<Integer> billstates = new ArrayList<Integer>();
        billstates.add(StoreCommonConsts.ZERO);
        billstates.add(StoreCommonConsts.ONE);
        billstates.add(StoreCommonConsts.THREE);
        checkWrapper.in((Object)"bill_state", billstates);
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))", new Object[0]);
        List checkList = this.checkService.list((Wrapper)checkWrapper);
        if (checkList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u76d8\u70b9\u5355\u540e\u5df2\u5b58\u5728\u76d8\u70b9\u5355\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.checkService.selectById(billId));
        List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
        Boolean checkInFlag = false;
        Boolean checkOutFlag = false;
        for (StoreCheckDetailEntity item : checkSubList) {
            if (item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                checkInFlag = true;
                if (checkOutFlag.booleanValue()) break;
            }
            if (item.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
            checkOutFlag = true;
            if (!checkInFlag.booleanValue()) continue;
            break;
        }
        SourceIds.add(billId);
        storeManageVO.setSourceId(billId);
        storeManageVO.setStoreId(entity.getStoreId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u76d8\u4e8f\u51fa\u5e93);
        storeManageVO.setSourceIdsForRollBack(SourceIds);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        if (checkOutFlag.booleanValue() && !(storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO)).isSuccess()) {
            return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
        }
        if (checkInFlag.booleanValue()) {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u76d8\u76c8\u5165\u5e93);
            storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

