package com.ejianc.business.assist.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.service.IMaterialContractFileService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping()
public class MaterialContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialContractService contractService;

    @Autowired
    private IMaterialContractFileService service;


    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/materialContractFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        MaterialContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }
    @GetMapping(value = "/materialContractFileUpdate/getBillDataJson")
    public CommonResponse<MaterialContractVO> getBillDataJson(@RequestParam Long id) {
        logger.info("-----查询合同子表合并-----合同id：{}", id);
        MaterialContractEntity materialContractEntity = contractService.selectById(id);
        MaterialContractVO vo = BeanMapper.map(materialContractEntity, MaterialContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherList())) {
            vo.getOtherList().forEach(item -> {
                item.setOtherPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> {
                item.setPaymentScaleStr(null != item.getPaymentScale() ? mnyFmt.format(item.getPaymentScale()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getClauseList())) {
            vo.getClauseList().forEach(item -> {
                /**
                 * 是否必填 0否  1是
                 */
                item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus()==1  ?  "是":"否" );
            });
        }
        return CommonResponse.success(vo);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "/material/billFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {

        return CommonResponse.success("查询成功！", service.getSignedFileInfo(billId, billType));
    }
}
