package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.contract.bean.*;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.enums.*;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractChangeMapper;
import com.ejianc.business.outrmat.contract.service.*;
import com.ejianc.business.outrmat.contract.vo.*;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractChangeRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同变更表
 * 
 * @author generator
 * 
 */
@Service("outRmatContractChangeService")
public class OutRmatContractChangeServiceImpl extends BaseServiceImpl<OutRmatContractChangeMapper, OutRmatContractChangeEntity> implements IOutRmatContractChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_CNAHGE";//此处需要根据实际修改
    
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOutRmatContractService contractService;

    @Autowired
    private IOutRmatContractRecordService recordService;
    
    @Autowired
    private IOutRmatContractChangeService changeService;

    @Autowired
    private IOutRmatContractDailyRentService dailyRentService;

    @Autowired
    private IOutRmatContractMonthRentService monthRentService;

    @Autowired
    private IOutRmatContractNumRentService numRentService;

    @Autowired
    private IOutRmatContractRepairService repairService;

    @Autowired
    private IOutRmatContractScrapService scrapService;

    @Autowired
    private IOutRmatContractOtherService otherService;

    @Autowired
    private IOutRmatContractPaymentService paymentService;

    @Autowired
    private IOutRmatContractClauseService clauseService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IOutRmatContractFileService contractFileService;

    @Override
    public OutRmatContractChangeVO saveOrUpdate(OutRmatContractChangeVO saveOrUpdateVO) {
        // 获取主合同当前合同文件Id
        OutRmatContractEntity outRmatContractEntity = contractService.selectById(saveOrUpdateVO.getMainContractId());
        // 将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getAttachIds()) &&  null != outRmatContractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(outRmatContractEntity.getContractFileId());
        }

        OutRmatContractChangeEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatContractChangeEntity.class);

        // 变更合同只能存在一条未生效的
        // 查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<OutRmatContractChangeEntity> lambdachange = Wrappers.<OutRmatContractChangeEntity>lambdaQuery();
        lambdachange.eq(OutRmatContractChangeEntity::getContractId, saveOrUpdateVO.getMainContractId());
        if(saveOrUpdateVO.getId() != null) {
            lambdachange.ne(OutRmatContractChangeEntity::getId,saveOrUpdateVO.getId());
        }
        lambdachange.and(l -> l.ne(OutRmatContractChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(OutRmatContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        
        if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
            
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                // 第一次变更
                entity.setChangeVersion(1);
            } else {
                // 版本号+1
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }

            if(entity.getChangeVersion() < 10){
                entity.setBillCode(entity.getMainContractCode() + "-1-" + "0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }

            // 清空字表id、复制sourceBid
            clearDetailList(entity);

            // 删除旧的目标成本
            deleteOldCost(BeanMapper.map(outRmatContractEntity, OutRmatContractChangeVO.class));
        }

        contractService.validateContract(saveOrUpdateVO.getMainContractId(), OutRmatConstant.变更单, saveOrUpdateVO.getId(), OutRmatConstant.保存);
        
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate(entity, false);
        
        // 回写主合同信息
        LambdaUpdateWrapper<OutRmatContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OutRmatContractEntity::getChangeId, entity.getId());
        updateWrapper.set(OutRmatContractEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(OutRmatContractEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(OutRmatContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.set(OutRmatContractEntity::getChangeVersion, entity.getChangeVersion());
        updateWrapper.set(OutRmatContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(OutRmatContractEntity::getChangeDate, entity.getChangeDate());
        updateWrapper.set(OutRmatContractEntity::getChangeDraftType, entity.getChangeDraftType());
        updateWrapper.set(OutRmatContractEntity::getChangeContractSignatureStatus, entity.getSignatureStatus());
        updateWrapper.set(OutRmatContractEntity::getChangeFileId, entity.getChangeFileId());
        updateWrapper.set(OutRmatContractEntity::getChangeContractName, entity.getContractName());
        updateWrapper.eq(OutRmatContractEntity::getId, entity.getMainContractId());
        contractService.update(updateWrapper);

        // 获取最新的合同信息，推送到周转材
        OutRmatContractEntity queryOutRmatContractEntity = contractService.selectById(entity.getMainContractId());
        // 推送变更合同到项目
        contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(entity)),
                OutRmatConstant.PUSH_RMAT_OPT_TYPE_ADD, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE,queryOutRmatContractEntity.getRentType());

        OutRmatContractChangeVO vo = BeanMapper.map(this.selectById(entity.getId()), OutRmatContractChangeVO.class);
        
        
        // 推送新目标成本
//        CommonResponse<String> response = executionApi.aggPush(targetCost(vo));
//        if (!response.isSuccess()){
//            throw new BusinessException("目标成本推送失败！");
//        }

        return BeanMapper.map(this.selectById(entity.getId()), OutRmatContractChangeVO.class);
    }

    @Override
    public OutRmatContractChangeRecordVO queryChangeRecord(Long id) {
        OutRmatContractEntity entity = contractService.selectById(id);

        OutRmatContractChangeRecordVO vo = new OutRmatContractChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询变更记录
        LambdaQueryWrapper<OutRmatContractChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatContractChangeEntity::getContractId, id);
        wrapper.orderByDesc(OutRmatContractChangeEntity::getCreateTime);
        List<OutRmatContractChangeEntity> changeList = super.list(wrapper);

        vo.setTotalChangeMny(ComputeUtil.safeSub(vo.getContractMny(), vo.getBaseMny()));
        vo.setTotalChangeTaxMny(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getBaseTaxMny()));
        vo.setTotalChangeNum(changeList.size());
        vo.setTotalChangeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalChangeMny(), vo.getBaseTaxMny()), new BigDecimal("100")));
        
        vo.setDetailList(BeanMapper.mapList(changeList, OutRmatContractChangeVO.class));

        return vo;
    }

    @Override
    public OutRmatContractChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper<OutRmatContractRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatContractRecordEntity::getChangeId, id);
        List<OutRmatContractRecordEntity> list = recordService.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            return BeanMapper.map(recordService.selectById(list.get(0).getId()), OutRmatContractChangeVO.class);
        }else {
            return new OutRmatContractChangeVO();
        }
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        // 表更表
        OutRmatContractChangeEntity outRmatContractChangeEntity = this.selectById(changeBillId);
        // 原合同数据
        OutRmatContractVO outRmatContractVO = contractService.queryDetail(outRmatContractChangeEntity.getContractId());
        
        // 回写记录表数据
        writeBackRecord(outRmatContractChangeEntity, outRmatContractVO);

        // 回写原合同数据
        writeBackContract(outRmatContractChangeEntity, outRmatContractVO);

        
        // 设置变更合同生效状态
        outRmatContractChangeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        outRmatContractChangeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        outRmatContractChangeEntity.setCommitDate(new Date());
        if (filingFlag){
            outRmatContractChangeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            outRmatContractChangeEntity.setFilingRef(0);
        }
        // 变更单更新
        changeService.saveOrUpdate(outRmatContractChangeEntity);

        if (DraftTypeEnum.线上起草.getCode().equals(outRmatContractChangeEntity.getChangeDraftType()) || DraftTypeEnum.上传合同.getCode().equals(outRmatContractChangeEntity.getChangeDraftType())){
            // 更新合同的 签章文件id
            contractFileService.getSignedFileInfo(changeBillId, "contractChange");
        }

        return CommonResponse.success("变更单生效，回写合同成功！");
        
    }

    @Override
    public void deleteByIds(List<OutRmatContractChangeVO> vos) {
        for (OutRmatContractChangeVO vo : vos) {
            OutRmatContractChangeEntity outRmatContractChangeEntity = super.selectById(vo.getId());

            // 删除当前变更单的目标成本
            deleteOldCost(BeanMapper.map(outRmatContractChangeEntity, OutRmatContractChangeVO.class));
            
            // 查询变更记录
            LambdaQueryWrapper<OutRmatContractChangeEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OutRmatContractChangeEntity::getContractId, outRmatContractChangeEntity.getContractId());
            wrapper.ne(BaseEntity::getId, vo.getId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List<OutRmatContractChangeEntity> list = this.list(wrapper);

            OutRmatContractChangeVO outRmatContractChangeVO = new OutRmatContractChangeVO();
            if (ListUtil.isNotEmpty(list)) {
                // 推送上个变更单
                outRmatContractChangeVO = BeanMapper.map(list.get(0), OutRmatContractChangeVO.class);
            }else {
                // 推送原合同
                OutRmatContractEntity outRmatContractEntity = contractService.selectById(outRmatContractChangeEntity.getContractId());
                outRmatContractChangeVO = BeanMapper.map(outRmatContractEntity, OutRmatContractChangeVO.class);
            }

            // 推送上个版本的目标成本
            targetCost(outRmatContractChangeVO);
            
            LambdaUpdateWrapper<OutRmatContractEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
            if (outRmatContractChangeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(OutRmatContractEntity::getChangeStatus, 1);
            } else {
                lambdaUpdate.set(OutRmatContractEntity::getChangeStatus, 3);
            }
            lambdaUpdate.eq(OutRmatContractEntity::getId, outRmatContractChangeEntity.getContractId());
            contractService.update(lambdaUpdate);

            super.removeById(vo.getId(), false);
            // 推送变更合同到项目
            OutRmatContractEntity outRmatContractEntity = contractService.selectById(outRmatContractChangeEntity.getContractId());
            contractService.pushContractToRmat(JSONObject.parseObject(JSONObject.toJSONString(vo)),
                    OutRmatConstant.PUSH_RMAT_OPT_TYPE_DEL, OutRmatConstant.PUSH_RMAT_OPT_BILL_CONTRACT_CHANGE,outRmatContractEntity.getRentType());

        }
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        OutRmatContractChangeEntity outRmatContractChangeEntity = this.selectById(id);
        OutRmatContractChangeCompareVO outRmatContractChangeCompareVO = BeanMapper.map(outRmatContractChangeEntity, OutRmatContractChangeCompareVO.class);
        OutRmatContractEntity outRmatContractEntity = contractService.selectById(outRmatContractChangeEntity.getContractId());

        OutRmatContractChangeCompareVO beforeChangeVO = new OutRmatContractChangeCompareVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(outRmatContractChangeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(outRmatContractChangeEntity.getBillState())) {
            // 若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<OutRmatContractRecordEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OutRmatContractRecordEntity::getChangeId, id);
            wrapper.eq(OutRmatContractRecordEntity::getContractId, outRmatContractChangeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);

            List<OutRmatContractRecordEntity> recordEntityList = recordService.list(wrapper);
            if (ListUtil.isNotEmpty(recordEntityList)) {
                beforeChangeVO = BeanMapper.map(recordService.selectById(recordEntityList.get(0).getId()), OutRmatContractChangeCompareVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(outRmatContractEntity, OutRmatContractChangeCompareVO.class);
            flag = true;
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (outRmatContractChangeCompareVO != null && beforeChangeVO != null) {
            // 日租
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getDailyRentList())) {
                List<OutRmatContractChangeDailyRentVO> dailyRentList = beforeChangeVO.getDailyRentList();
                Map<Long, OutRmatContractChangeDailyRentVO> beforeDailyMap = new HashMap<>();
                if (flag) {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(OutRmatContractChangeDailyRentVO::getId, Function.identity()));
                }else {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(OutRmatContractChangeDailyRentVO::getSourceBid, Function.identity()));
                }

                for (OutRmatContractChangeDailyRentVO vo : outRmatContractChangeCompareVO.getDailyRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeDailyRentVO beforeVO = beforeDailyMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcRentDays(beforeVO.getRentDays());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                outRmatContractChangeCompareVO.setDailyRentList(outRmatContractChangeCompareVO.getDailyRentList().stream().filter(daily -> StringUtils.isNotEmpty(daily.getChangeType())).collect(Collectors.toList()));
            }

            // 月租
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getMonthRentList())) {
                List<OutRmatContractChangeMonthRentVO> monthRentList = beforeChangeVO.getMonthRentList();
                Map<Long, OutRmatContractChangeMonthRentVO> beforeMonthMap = new HashMap<>();
                if (flag) {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(OutRmatContractChangeMonthRentVO::getId, Function.identity()));
                }else {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(OutRmatContractChangeMonthRentVO::getSourceBid, Function.identity()));
                }

                for (OutRmatContractChangeMonthRentVO vo : outRmatContractChangeCompareVO.getMonthRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeMonthRentVO beforeVO = beforeMonthMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcLackMonthDayUnitTaxPrice(beforeVO.getLackMonthDayUnitTaxPrice());
                        vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcRentMonths(beforeVO.getRentMonths());
                        vo.setBcRentDays(beforeVO.getRentDays());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                outRmatContractChangeCompareVO.setMonthRentList(outRmatContractChangeCompareVO.getMonthRentList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }

            // 工程量租
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getNumRentList())) {
                List<OutRmatContractChangeNumRentVO> numRentList = beforeChangeVO.getNumRentList();
                Map<Long, OutRmatContractChangeNumRentVO> beforeNumMap = new HashMap<>();
                if (flag) {
                    beforeNumMap = numRentList.stream().collect(Collectors.toMap(OutRmatContractChangeNumRentVO::getId, Function.identity()));
                }else {
                    beforeNumMap = numRentList.stream().collect(Collectors.toMap(OutRmatContractChangeNumRentVO::getSourceBid, Function.identity()));
                }

                for (OutRmatContractChangeNumRentVO vo : outRmatContractChangeCompareVO.getNumRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeNumRentVO beforeVO = beforeNumMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcQuantities(beforeVO.getQuantities());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                outRmatContractChangeCompareVO.setNumRentList(outRmatContractChangeCompareVO.getNumRentList().stream().filter(num -> StringUtils.isNotEmpty(num.getChangeType())).collect(Collectors.toList()));
            }

            // 维修
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getRepairList())) {
                List<OutRmatContractChangeRepairVO> repairList = beforeChangeVO.getRepairList();
                Map<Long, OutRmatContractChangeRepairVO> beforeRepairMap = new HashMap<>();
                if (flag) {
                    beforeRepairMap = repairList.stream().collect(Collectors.toMap(OutRmatContractChangeRepairVO::getId, Function.identity()));
                }else {
                    beforeRepairMap = repairList.stream().collect(Collectors.toMap(OutRmatContractChangeRepairVO::getSourceBid, Function.identity()));
                }
                for (OutRmatContractChangeRepairVO vo : outRmatContractChangeCompareVO.getRepairList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeRepairVO beforeVO = beforeRepairMap.get(vo.getSourceBid());
                        vo.setBcRepairItemName(beforeVO.getRepairItemName());
                        vo.setBcRepairUnitName(beforeVO.getRepairUnitName());
                        vo.setBcRepairTaxPrice(beforeVO.getRepairTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                outRmatContractChangeCompareVO.setRepairList(outRmatContractChangeCompareVO.getRepairList().stream().filter(repair -> StringUtils.isNotEmpty(repair.getChangeType())).collect(Collectors.toList()));
            }

            // 报废
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getScrapList())) {
                List<OutRmatContractChangeScrapVO> scrapList = beforeChangeVO.getScrapList();
                Map<Long, OutRmatContractChangeScrapVO> beforeScrapMap = new HashMap<>();
                if (flag) {
                    beforeScrapMap = scrapList.stream().collect(Collectors.toMap(OutRmatContractChangeScrapVO::getId, Function.identity()));
                }else {
                    beforeScrapMap = scrapList.stream().collect(Collectors.toMap(OutRmatContractChangeScrapVO::getSourceBid, Function.identity()));
                }
                for (OutRmatContractChangeScrapVO vo : outRmatContractChangeCompareVO.getScrapList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeScrapVO beforeVO = beforeScrapMap.get(vo.getSourceBid());
                        vo.setBcDamageScrapName(beforeVO.getDamageScrapName());
                        vo.setBcDamageScrapUnitName(beforeVO.getDamageScrapUnitName());
                        vo.setBcDamageScrapTaxPrice(beforeVO.getDamageScrapTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                outRmatContractChangeCompareVO.setScrapList(outRmatContractChangeCompareVO.getScrapList().stream().filter(scarp -> StringUtils.isNotEmpty(scarp.getChangeType())).collect(Collectors.toList()));
            }

            // 其他
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getOtherList())) {
                List<OutRmatContractChangeOtherVO> otherList = beforeChangeVO.getOtherList();
                Map<Long, OutRmatContractChangeOtherVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(OutRmatContractChangeOtherVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(OutRmatContractChangeOtherVO::getSourceBid, Function.identity()));
                }
                for (OutRmatContractChangeOtherVO vo : outRmatContractChangeCompareVO.getOtherList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRmatContractChangeOtherVO beforeVO = beforeOtherMap.get(vo.getSourceBid());
                        vo.setBcCostName(beforeVO.getCostName());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                outRmatContractChangeCompareVO.setOtherList(outRmatContractChangeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty(other.getChangeType())).collect(Collectors.toList()));
            }

            // 设置合同付款阶段
            List<OutRmatContractChangePaymentVO> newPayList = new ArrayList<>();
            Map<Long, OutRmatContractChangePaymentVO> beforePayMap = new HashMap<>();
            if (flag) {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(OutRmatContractChangePaymentVO::getId, item -> item, (v1, v2) -> v2));
            }else {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(OutRmatContractChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            }
            if (ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getPaymentList())) {
                OutRmatContractChangePaymentVO beforeVo = null;
                for (OutRmatContractChangePaymentVO vo : outRmatContractChangeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        //没有来源则说明为新增项
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                    } else if (beforePayMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforePayMap.get(vo.getSourceBid());
                        if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                            vo.setBcPaymentName(beforeVo.getPaymentName());
                            vo.setBcPaymentScale(beforeVo.getPaymentScale());
                            vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newPayList.add(vo);
                        }
                        beforePayMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforePayMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newPayList.add(c);
                });
            }
            outRmatContractChangeCompareVO.setPaymentList(newPayList);

            //设置合同条款
            List<OutRmatContractChangeClauseVO> newClauses = new ArrayList<>();
            Map<Long, OutRmatContractChangeClauseVO> beforeClauseMap = new HashMap<>();
            if (flag) {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(OutRmatContractChangeClauseVO::getId, clause -> clause, (v1,v2) ->v2));
            }else {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(OutRmatContractChangeClauseVO::getSourceBid, clause -> clause, (v1,v2) ->v2));
            }
            if(ListUtil.isNotEmpty(outRmatContractChangeCompareVO.getClauseList())) {
                OutRmatContractChangeClauseVO beforeVo = null;
                for (OutRmatContractChangeClauseVO vo : outRmatContractChangeCompareVO.getClauseList()) {
                    if(vo.getSourceBid() == null) {
                        // 没有来源则说明为新增项
                        vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                    } else if(beforeClauseMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforeClauseMap.get(vo.getSourceBid());
                        if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                            // 参照变更
                            vo.setBcClauseName(beforeVo.getClauseName());
                            vo.setBcClauseContent(beforeVo.getClauseContent());
                            vo.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newClauses.add(vo);
                        }

                        beforeClauseMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforeClauseMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(OutRmatContractChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newClauses.add(c);
                });
            }
            outRmatContractChangeCompareVO.setClauseList(newClauses);



            returnMap.put("newData", outRmatContractChangeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }

        return returnMap;
    }

    /**
     * 回写记录表数据
     * @param outRmatContractChangeEntity
     * @param outRmatContractVO
     */
    public void writeBackRecord(OutRmatContractChangeEntity outRmatContractChangeEntity, OutRmatContractVO outRmatContractVO) {
        // 同步原合同到记录表
        OutRmatContractRecordEntity outRmatContractRecordEntity = BeanMapper.map(outRmatContractVO, OutRmatContractRecordEntity.class);
        outRmatContractRecordEntity.setContractId(outRmatContractChangeEntity.getContractId());
        outRmatContractRecordEntity.setId(null);

        // 历史记录子表处理
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getDailyRentList())){
            for (OutRmatContractRecordDailyRentEntity entity : outRmatContractRecordEntity.getDailyRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getMonthRentList())){
            for (OutRmatContractRecordMonthRentEntity entity : outRmatContractRecordEntity.getMonthRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getNumRentList())){
            for (OutRmatContractRecordNumRentEntity entity : outRmatContractRecordEntity.getNumRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getRepairList())){
            for (OutRmatContractRecordRepairEntity entity : outRmatContractRecordEntity.getRepairList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getScrapList())){
            for (OutRmatContractRecordScrapEntity entity : outRmatContractRecordEntity.getScrapList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getOtherList())){
            for (OutRmatContractRecordOtherEntity entity : outRmatContractRecordEntity.getOtherList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getClauseList())){
            for (OutRmatContractRecordClauseEntity entity : outRmatContractRecordEntity.getClauseList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(outRmatContractRecordEntity.getPaymentList())){
            for (OutRmatContractRecordPaymentEntity entity : outRmatContractRecordEntity.getPaymentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }

        recordService.saveOrUpdate(outRmatContractRecordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        // 原合同附件、起草附件同步到记录单据中
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(outRmatContractVO.getId()), BillTypeEnum.辅料中心租出合同.getCode(), CommonConstant.CONTRACT_ATTACH_SOURCE_TYPE,
                String.valueOf(outRmatContractRecordEntity.getId()), BillTypeEnum.辅料中心租出合同记录.getCode(), CommonConstant.CONTRACT_RECORD_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        logger.info("同步附件");
        CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(outRmatContractVO.getId()), BillTypeEnum.辅料中心租出合同.getCode(), CommonConstant.CONTRACT_FILE_SOURCE_TYPE,
                String.valueOf(outRmatContractRecordEntity.getId()), BillTypeEnum.辅料中心租出合同记录.getCode(), CommonConstant.CONTRACT_RECORD_FILE_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response2));
        
    }

    /**
     * 回写原合同数据
     * @param outRmatContractChangeEntity
     * @param outRmatContractVO
     */
    public void writeBackContract(OutRmatContractChangeEntity outRmatContractChangeEntity, OutRmatContractVO outRmatContractVO) {
        OutRmatContractEntity outRmatContractEntity = BeanMapper.map(outRmatContractVO, OutRmatContractEntity.class);
        
        // 甲方、乙方信息
        outRmatContractEntity.setFirstPartyProjectManagerId(outRmatContractChangeEntity.getFirstPartyProjectManagerId());
        outRmatContractEntity.setFirstPartyProjectManagerName(outRmatContractChangeEntity.getFirstPartyProjectManagerName());
        outRmatContractEntity.setFirstPartyEmployeeId(outRmatContractChangeEntity.getFirstPartyEmployeeId());
        outRmatContractEntity.setFirstPartyEmployeeName(outRmatContractChangeEntity.getFirstPartyEmployeeName());
        outRmatContractEntity.setFirstPartyPhone(outRmatContractChangeEntity.getFirstPartyPhone());
        outRmatContractEntity.setSupplierId(outRmatContractChangeEntity.getSupplierId());
        outRmatContractEntity.setSupplierName(outRmatContractChangeEntity.getSupplierName());
        outRmatContractEntity.setSupplierEmployeeId(outRmatContractChangeEntity.getSupplierEmployeeId());
        outRmatContractEntity.setSupplierEmployeeName(outRmatContractChangeEntity.getSupplierEmployeeName());
        outRmatContractEntity.setSupplierPhone(outRmatContractChangeEntity.getSupplierPhone());
        outRmatContractEntity.setSupplierAddress(outRmatContractChangeEntity.getSupplierAddress());
        
        outRmatContractEntity.setFirstPartyEntrustedAgentId(outRmatContractChangeEntity.getFirstPartyEntrustedAgentId());
        outRmatContractEntity.setFirstPartyEntrustedAgentName(outRmatContractChangeEntity.getFirstPartyEntrustedAgentName());
        outRmatContractEntity.setFirstPartyPrincipalId(outRmatContractChangeEntity.getFirstPartyPrincipalId());
        outRmatContractEntity.setFirstPartyPrincipalName(outRmatContractChangeEntity.getFirstPartyPrincipalName());
        outRmatContractEntity.setFirstPartyAddress(outRmatContractChangeEntity.getFirstPartyAddress());
        outRmatContractEntity.setSupplierPrincipalId(outRmatContractChangeEntity.getSupplierPrincipalId());
        outRmatContractEntity.setSupplierPrincipalName(outRmatContractChangeEntity.getSupplierPrincipalName());
        outRmatContractEntity.setMaterialClerkOneId(outRmatContractChangeEntity.getMaterialClerkOneId());
        outRmatContractEntity.setMaterialClerkOneName(outRmatContractChangeEntity.getMaterialClerkOneName());
        outRmatContractEntity.setMaterialClerkOnePhone(outRmatContractChangeEntity.getMaterialClerkOnePhone());
        outRmatContractEntity.setMaterialClerkTwoId(outRmatContractChangeEntity.getMaterialClerkTwoId());
        outRmatContractEntity.setMaterialClerkTwoName(outRmatContractChangeEntity.getMaterialClerkTwoName());
        outRmatContractEntity.setMaterialClerkTwoPhone(outRmatContractChangeEntity.getMaterialClerkTwoPhone());
        
        
        // 合同金额
        outRmatContractEntity.setContractMny(outRmatContractChangeEntity.getContractMny());
        outRmatContractEntity.setContractTaxMny(outRmatContractChangeEntity.getContractTaxMny());
        outRmatContractEntity.setTaxRate(outRmatContractChangeEntity.getTaxRate());
        outRmatContractEntity.setTax(outRmatContractChangeEntity.getTax());
        outRmatContractEntity.setChangingMny(null);
        outRmatContractEntity.setChangingTaxMny(null);
        
        // 计租方式
        outRmatContractEntity.setRentCalculationType(outRmatContractChangeEntity.getRentCalculationType());
        outRmatContractEntity.setMonthSettlementDay(outRmatContractChangeEntity.getMonthSettlementDay());
        
        // 其他业务字段
        outRmatContractEntity.setContractName(outRmatContractChangeEntity.getContractName());
        outRmatContractEntity.setChangeContractName(outRmatContractChangeEntity.getContractName());
        outRmatContractEntity.setSupplyAddress(outRmatContractChangeEntity.getSupplyAddress());
        outRmatContractEntity.setSignDate(outRmatContractChangeEntity.getSignDate());
        outRmatContractEntity.setRentCalculationDate(outRmatContractChangeEntity.getRentCalculationDate());
        outRmatContractEntity.setEndRentCalculationDate(outRmatContractChangeEntity.getEndRentCalculationDate());
        outRmatContractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        outRmatContractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
        outRmatContractEntity.setChangeDraftType(outRmatContractChangeEntity.getChangeDraftType());
        outRmatContractEntity.setChangeFileId(outRmatContractChangeEntity.getChangeFileId());
        
        // 回写原合同子表信息
        // 日租
        if (ListUtil.isNotEmpty(outRmatContractVO.getDailyRentList())) {
            dailyRentService.removeByIds(outRmatContractVO.getDailyRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractDailyRentEntity> dailyRentList = BeanMapper.mapList(outRmatContractChangeEntity.getDailyRentList(), OutRmatContractDailyRentEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (OutRmatContractDailyRentEntity entity : dailyRentList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setDailyRentList(dailyRentList);
        
        // 月租
        if (ListUtil.isNotEmpty(outRmatContractVO.getMonthRentList())) {
            monthRentService.removeByIds(outRmatContractVO.getMonthRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractMonthRentEntity> monthRentList = BeanMapper.mapList(outRmatContractChangeEntity.getMonthRentList(), OutRmatContractMonthRentEntity.class);
        if (ListUtil.isNotEmpty(monthRentList)) {
            for (OutRmatContractMonthRentEntity entity : monthRentList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setMonthRentList(monthRentList);
        
        // 工程量租
        if (ListUtil.isNotEmpty(outRmatContractVO.getNumRentList())) {
            numRentService.removeByIds(outRmatContractVO.getNumRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractNumRentEntity> numRentList = BeanMapper.mapList(outRmatContractChangeEntity.getNumRentList(), OutRmatContractNumRentEntity.class);
        if (ListUtil.isNotEmpty(numRentList)) {
            for (OutRmatContractNumRentEntity entity : numRentList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setNumRentList(numRentList);

        // 维修
        if (ListUtil.isNotEmpty(outRmatContractVO.getRepairList())) {
            repairService.removeByIds(outRmatContractVO.getRepairList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractRepairEntity> repairList = BeanMapper.mapList(outRmatContractChangeEntity.getRepairList(), OutRmatContractRepairEntity.class);
        if (ListUtil.isNotEmpty(repairList)) {
            for (OutRmatContractRepairEntity entity : repairList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setRepairList(repairList);

        // 报废
        if (ListUtil.isNotEmpty(outRmatContractVO.getScrapList())) {
            scrapService.removeByIds(outRmatContractVO.getScrapList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractScrapEntity> scrapList = BeanMapper.mapList(outRmatContractChangeEntity.getScrapList(), OutRmatContractScrapEntity.class);
        if (ListUtil.isNotEmpty(scrapList)) {
            for (OutRmatContractScrapEntity entity : scrapList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setScrapList(scrapList);

        // 其他费用
        if (ListUtil.isNotEmpty(outRmatContractVO.getOtherList())) {
            otherService.removeByIds(outRmatContractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractOtherEntity> otherList = BeanMapper.mapList(outRmatContractChangeEntity.getOtherList(), OutRmatContractOtherEntity.class);
        if (ListUtil.isNotEmpty(otherList)) {
            for (OutRmatContractOtherEntity entity : otherList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setOtherList(otherList);

        // 付款计划
        if (ListUtil.isNotEmpty(outRmatContractVO.getPaymentList())) {
            paymentService.removeByIds(outRmatContractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractPaymentEntity> paymentList = BeanMapper.mapList(outRmatContractChangeEntity.getPaymentList(), OutRmatContractPaymentEntity.class);
        if (ListUtil.isNotEmpty(paymentList)) {
            for (OutRmatContractPaymentEntity entity : paymentList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setPaymentList(paymentList);

        // 条款
        if (ListUtil.isNotEmpty(outRmatContractVO.getClauseList())) {
            clauseService.removeByIds(outRmatContractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<OutRmatContractClauseEntity> clauseList = BeanMapper.mapList(outRmatContractChangeEntity.getClauseList(), OutRmatContractClauseEntity.class);
        if (ListUtil.isNotEmpty(clauseList)) {
            for (OutRmatContractClauseEntity entity : clauseList) {
                entity.setChangeId(outRmatContractChangeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        outRmatContractEntity.setClauseList(clauseList);

        // 更新合同池操作
        Boolean pushResult = this.pushContract(BeanMapper.map(outRmatContractEntity, OutRmatContractVO.class), UpdateLevelEnum.全量覆盖更新.getLevelCode());
        if(pushResult) {
            outRmatContractEntity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
        } else {
            outRmatContractEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        
        
        contractService.saveOrUpdate(outRmatContractEntity, false);
        
        // 同步起草方式附件（不包含变更附件管理附件）到原合同
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(outRmatContractChangeEntity.getId()), BillTypeEnum.辅料中心租出合同变更.getCode(), CommonConstant.CONTRACT_CHANGE_ATTACH_SOURCE_TYPE,
                String.valueOf(outRmatContractEntity.getId()), BillTypeEnum.辅料中心租出合同.getCode(), CommonConstant.CONTRACT_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));
    }

    public void clearDetailList(OutRmatContractChangeEntity outRmatContractChangeEntity) {
        // 日租
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getDailyRentList())){
            for (OutRmatContractChangeDailyRentEntity entity : outRmatContractChangeEntity.getDailyRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 月租
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getMonthRentList())){
            for (OutRmatContractChangeMonthRentEntity entity : outRmatContractChangeEntity.getMonthRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 工程量租
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getNumRentList())){
            for (OutRmatContractChangeNumRentEntity entity : outRmatContractChangeEntity.getNumRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 维修
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getRepairList())){
            for (OutRmatContractChangeRepairEntity entity : outRmatContractChangeEntity.getRepairList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 报废
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getScrapList())){
            for (OutRmatContractChangeScrapEntity entity : outRmatContractChangeEntity.getScrapList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 其他费用
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getOtherList())){
            for (OutRmatContractChangeOtherEntity entity : outRmatContractChangeEntity.getOtherList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 付款计划
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getPaymentList())){
            for (OutRmatContractChangePaymentEntity entity : outRmatContractChangeEntity.getPaymentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
        // 合同条款
        if(ListUtil.isNotEmpty(outRmatContractChangeEntity.getClauseList())){
            for (OutRmatContractChangeClauseEntity entity : outRmatContractChangeEntity.getClauseList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(outRmatContractChangeEntity.getMainContractId());
            }
        }
    }


    public void deleteOldCost(OutRmatContractChangeVO outRmatContractChangeVO) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        ExecutionVO executionVO = targetCost(outRmatContractChangeVO);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("删除旧目标成本失败！");
        }
        
    }
    
    public ExecutionVO targetCost(OutRmatContractChangeVO outRmatContractChangeVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        // TODO 单据编码和URL需要修改
        totalVO.setSourceId(outRmatContractChangeVO.getId());
        totalVO.setTenantId(outRmatContractChangeVO.getTenantId());
        totalVO.setBillCode(outRmatContractChangeVO.getBillCode());
        totalVO.setBillType("BT220210000000005");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(outRmatContractChangeVO.getProjectId());
        totalVO.setOrgId(outRmatContractChangeVO.getOrgId());
        totalVO.setMoney(outRmatContractChangeVO.getContractMny());
        totalVO.setTaxMoney(outRmatContractChangeVO.getContractTaxMny());
        totalVO.setLinkUrl(baseHost + "ejc-assistrmat-frontend/#/contract/changeCard?id=" + outRmatContractChangeVO.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;
    }

    /**
     * 推送(更新)合同池
     * @param vo
     * @param updateLevel
     * @return
     */
    @Override
    public Boolean pushContract(OutRmatContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        //TODO URL需要修改
        try {
            // 删除原单据
            contractService.delContractFromPool(vo.getId());
            
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.支出.getCode()));

            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-assistrmat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }else {
                url = "/ejc-assistrmat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }
            data.setPcCardUrl(url);
            
            // 合同累计变更金额
            OutRmatContractChangeRecordVO outRmatContractChangeRecordVO = queryChangeRecord(vo.getId());
            data.setTotalChangeMny(outRmatContractChangeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(outRmatContractChangeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub(data.getTotalChangeTaxMny(), data.getTotalChangeMny()));
            data.setTaotalChangeScale(outRmatContractChangeRecordVO.getTotalChangeRate());

            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return null;
    }
    
}
