/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.calculate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.MaterialStateEnum;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.DetailListUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.MaterialFlowVO;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateDailyEntity;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateMonthEntity;
import com.ejianc.business.outrmat.calculate.mapper.OutRmatCalculateMapper;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateCacheVO;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRecordMonthRentEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRecordDailyRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRecordMonthRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRecordService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRecordDailyRentVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRecordMonthRentVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatCalculateService")
public class OutRmatCalculateServiceImpl
extends BaseServiceImpl<OutRmatCalculateMapper, OutRmatCalculateEntity>
implements IOutRmatCalculateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRmatMaterialService materialService;
    @Autowired
    private IOutRmatContractService contractService;
    @Autowired
    private IOutRmatContractRecordService recordService;
    @Autowired
    private IOutRmatContractRecordDailyRentService dailyRecordService;
    @Autowired
    private IOutRmatContractRecordMonthRentService monthRecordService;
    private static final String BILL_CODE = "OUT_RMAT_RENT_CALCULATE";
    private static final String BILL_NAME = BillTypeEnum.\u79df\u51fa\u79df\u91d1\u8ba1\u7b97\u5355.getName();
    private static final String RENT_TYPE_DAY = "0";
    private static final String RENT_TYPE_MONTH = "1";

    @Override
    public OutRmatCalculateVO saveOrUpdate(OutRmatCalculateVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        OutRmatCalculateEntity entity = (OutRmatCalculateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatCalculateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (OutRmatCalculateVO)BeanMapper.map((Object)((Object)entity), OutRmatCalculateVO.class);
    }

    @Override
    public String validateTime(OutRmatCalculateVO rentVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", rentVO.getContractId());
        if (rentVO.getId() != null) {
            params.put("billType", "\u79df\u91d1\u8ba1\u7b97\u5355");
            params.put("billId", rentVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)rentVO.getRentDate(), (Date)lastDate, maxTimeMap, (Date)rentVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)rentVO.getRentDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public OutRmatCalculateVO automaticRental(OutRmatCalculateVO vo) {
        List checkList;
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long contractId = vo.getContractId();
        Date endDate = DateUtil.concatDate((Date)vo.getRentDate(), (Date)new Date());
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (null != vo.getId()) {
            param.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(param, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        Date startDate = null;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            OutRmatCalculateEntity last = (OutRmatCalculateEntity)((Object)lastList.get(0));
            startDate = DateUtil.concatDate((Date)DateUtil.dayAddOne((Date)last.getRentDate()), (Date)last.getCreateTime());
        }
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u7269\u6599\u4fe1\u606fstart");
        List<com.ejianc.business.assist.rmat.vo.MaterialVO> reportList = this.materialService.queryCalculateList(contractId, startDate, endDate);
        if (CollectionUtils.isEmpty(reportList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u7269\u6599\u5165\u573a\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reportList));
        this.logger.info(">>>>\u67e5\u8be2\u5408\u540c\u4fe1\u606fstart");
        OutRmatContractEntity contract = (OutRmatContractEntity)((Object)DetailListUtil.selectById((Long)contractId, (IBaseService)this.contractService));
        this.logger.info("\u4e3b\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contract)));
        Map<String, Map<Long, List<OutRmatCalculateCacheVO>>> contractAllMap = this.getContractRecord(contract, endDate);
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        OutRmatCalculateEntity entity = new OutRmatCalculateEntity();
        ArrayList<OutRmatCalculateDailyEntity> dailyList = new ArrayList<OutRmatCalculateDailyEntity>();
        ArrayList<OutRmatCalculateMonthEntity> monthList = new ArrayList<OutRmatCalculateMonthEntity>();
        ArrayList<OutRmatCalculateCacheVO> dailyVOList = new ArrayList<OutRmatCalculateCacheVO>();
        ArrayList<OutRmatCalculateCacheVO> monthVOList = new ArrayList<OutRmatCalculateCacheVO>();
        for (com.ejianc.business.assist.rmat.vo.MaterialVO materialVO : reportList) {
            if (RENT_TYPE_DAY.equals(materialVO.getRentCalculationType())) {
                this.packParameterDetailAndContract(dailyVOList, contractAllMap, materialVO, RENT_TYPE_DAY, contract.getMonthSettlementDay());
                continue;
            }
            if (!RENT_TYPE_MONTH.equals(materialVO.getRentCalculationType())) continue;
            this.packParameterDetailAndContract(monthVOList, contractAllMap, materialVO, RENT_TYPE_MONTH, contract.getMonthSettlementDay());
        }
        Set ids = reportList.stream().map(com.ejianc.business.assist.rmat.vo.MaterialVO::getMaterialId).collect(Collectors.toSet());
        CommonResponse resp = this.materialApi.queryMaterialByIds(new ArrayList(ids));
        Map<Long, Object> materialMap = new HashMap<Long, MaterialVO>();
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            materialMap = ((List)resp.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
        }
        this.setRentalDayDetailValue(dailyVOList, dailyList, materialMap);
        this.setRentalMonthDetailValue(monthVOList, monthList, materialMap);
        entity.setDailyList(dailyList);
        entity.setMonthList(monthList);
        this.setRentalValue(entity, contract, endDate);
        this.logger.info(">>>>\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u8f93\u51fa\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return (OutRmatCalculateVO)BeanMapper.map((Object)((Object)entity), OutRmatCalculateVO.class);
    }

    private void setRentalDayDetailValue(List<OutRmatCalculateCacheVO> resultList, List<OutRmatCalculateDailyEntity> dailyList, Map<Long, MaterialVO> materialMap) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        for (OutRmatCalculateCacheVO vo : resultList) {
            OutRmatContractRecordDailyRentVO recordVO = vo.getDailyRecord();
            OutRmatCalculateDailyEntity entity = new OutRmatCalculateDailyEntity();
            entity.setSourceId(recordVO.getSourceBid());
            entity.setMaterialTypeId(recordVO.getMaterialTypeId());
            entity.setMaterialTypeName(recordVO.getMaterialTypeName());
            entity.setMaterialId(recordVO.getMaterialId());
            entity.setMaterialCode(recordVO.getMaterialCode());
            entity.setMaterialName(recordVO.getMaterialName());
            entity.setSpec(recordVO.getSpec());
            entity.setUnitId(recordVO.getUnitId());
            entity.setUnitName(recordVO.getUnitName());
            entity.setUnitTaxPrice(recordVO.getUnitTaxPrice());
            entity.setUnitPrice(recordVO.getUnitPrice());
            entity.setStopUnitTaxPrice(recordVO.getStopUnitTaxPrice());
            entity.setStopUnitPrice(recordVO.getStopUnitPrice());
            entity.setTaxRate(recordVO.getTaxRate());
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            entity.setRentDayDate(DateUtil.getSubDay((Date)vo.getEndDate(), (Date)vo.getStartDate()));
            if (MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getStopUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            }
            entity.setDailyTax(ComputeUtil.safeSub((BigDecimal)entity.getDailyRentTaxMny(), (BigDecimal)entity.getDailyRentMny()));
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            dailyList.add(entity);
        }
        if (CollectionUtils.isNotEmpty(dailyList)) {
            dailyList.sort(Comparator.comparing(OutRmatCalculateDailyEntity::getMaterialId).thenComparing(OutRmatCalculateDailyEntity::getStartDate));
        }
    }

    private void setRentalMonthDetailValue(List<OutRmatCalculateCacheVO> resultList, List<OutRmatCalculateMonthEntity> monthList, Map<Long, MaterialVO> materialMap) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList<OutRmatCalculateMonthEntity> rstList = new ArrayList<OutRmatCalculateMonthEntity>();
        for (OutRmatCalculateCacheVO vo : resultList) {
            OutRmatContractRecordMonthRentVO recordVO = vo.getMonthRecord();
            OutRmatCalculateMonthEntity entity = new OutRmatCalculateMonthEntity();
            entity.setSourceId(recordVO.getSourceBid());
            entity.setMaterialTypeId(recordVO.getMaterialTypeId());
            entity.setMaterialTypeName(recordVO.getMaterialTypeName());
            entity.setMaterialId(recordVO.getMaterialId());
            entity.setMaterialCode(recordVO.getMaterialCode());
            entity.setMaterialName(recordVO.getMaterialName());
            entity.setSpec(recordVO.getSpec());
            entity.setUnitId(recordVO.getUnitId());
            entity.setUnitName(recordVO.getUnitName());
            entity.setUnitTaxPrice(recordVO.getUnitTaxPrice());
            entity.setUnitPrice(recordVO.getUnitPrice());
            entity.setLackMonthDayUnitTaxPrice(recordVO.getLackMonthDayUnitTaxPrice());
            entity.setLackMonthDayUnitPrice(recordVO.getLackMonthDayUnitPrice());
            entity.setStopUnitTaxPrice(recordVO.getStopUnitTaxPrice());
            entity.setStopUnitPrice(recordVO.getStopUnitPrice());
            entity.setTaxRate(recordVO.getTaxRate());
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                Integer days = DateUtil.getSubDay((Date)vo.getEndDate(), (Date)vo.getStartDate());
                entity.setMonthRentMny(this.getMny(entity.getStopUnitPrice(), days, entity.getNum()));
                entity.setMonthRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), days, entity.getNum()));
                entity.setRentDayDate(days);
                entity.setRentMonthDate(0);
            } else {
                this.monthSum(entity, vo);
            }
            entity.setMonthTax(ComputeUtil.safeSub((BigDecimal)entity.getMonthRentTaxMny(), (BigDecimal)entity.getMonthRentMny()));
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            rstList.add(entity);
        }
        rstList.sort(Comparator.comparing(OutRmatCalculateMonthEntity::getStartDate));
        this.logger.info("\u5408\u5e76\u524d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(rstList));
        monthList.addAll(rstList);
        if (CollectionUtils.isNotEmpty(monthList)) {
            monthList.sort(Comparator.comparing(OutRmatCalculateMonthEntity::getMaterialId).thenComparing(OutRmatCalculateMonthEntity::getStartDate));
        }
    }

    private void monthSum(OutRmatCalculateMonthEntity entity, OutRmatCalculateCacheVO vo) {
        Date startDate = entity.getStartDate();
        int[] mo = DateUtil.dayCompare((Date)startDate, (Date)entity.getEndDate());
        int month = mo[0];
        int day = mo[1];
        BigDecimal num = entity.getNum();
        BigDecimal monthMny = this.getMny(entity.getUnitPrice(), month, num);
        BigDecimal monthTaxMny = this.getMny(entity.getUnitTaxPrice(), month, num);
        BigDecimal dayMny = this.getMny(entity.getLackMonthDayUnitPrice(), day, num);
        BigDecimal dayTaxMny = this.getMny(entity.getLackMonthDayUnitTaxPrice(), day, num);
        entity.setMonthRentMny(ComputeUtil.safeAdd((BigDecimal)monthMny, (BigDecimal)dayMny));
        entity.setMonthRentTaxMny(ComputeUtil.safeAdd((BigDecimal)monthTaxMny, (BigDecimal)dayTaxMny));
        entity.setRentMonthDate(month);
        entity.setRentDayDate(day);
    }

    private void setRentalValue(OutRmatCalculateEntity entity, OutRmatContractEntity contract, Date date) {
        entity.setRentDate(date);
        entity.setCalculateType(RENT_TYPE_MONTH);
        entity.setSettleFlag(0);
        entity.setProjectId(contract.getProjectId());
        entity.setProjectCode(contract.getProjectCode());
        entity.setProjectName(contract.getProjectName());
        entity.setOrgId(contract.getOrgId());
        entity.setOrgCode(contract.getOrgCode());
        entity.setOrgName(contract.getOrgName());
        entity.setParentOrgId(contract.getParentOrgId());
        entity.setParentOrgCode(contract.getParentOrgCode());
        entity.setParentOrgName(contract.getParentOrgName());
        entity.setContractId(contract.getId());
        entity.setContractCode(contract.getBillCode());
        entity.setContractName(contract.getContractName());
        entity.setSupplierId(contract.getSupplierId());
        entity.setSupplierName(contract.getSupplierName());
        entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setDeptId(this.sessionManager.getUserContext().getDeptId());
        entity.setDeptName(this.sessionManager.getUserContext().getDeptName());
        entity.setRentCalculationType(contract.getRentCalculationType());
        entity.setMonthSettlementDay(contract.getMonthSettlementDay());
        BigDecimal rentMny = BigDecimal.ZERO;
        BigDecimal rentTaxMny = BigDecimal.ZERO;
        BigDecimal rentTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (OutRmatCalculateDailyEntity outRmatCalculateDailyEntity : entity.getDailyList()) {
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)outRmatCalculateDailyEntity.getDailyRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)outRmatCalculateDailyEntity.getDailyRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)outRmatCalculateDailyEntity.getDailyTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getMonthList())) {
            for (OutRmatCalculateMonthEntity outRmatCalculateMonthEntity : entity.getMonthList()) {
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)outRmatCalculateMonthEntity.getMonthRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)outRmatCalculateMonthEntity.getMonthRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)outRmatCalculateMonthEntity.getMonthTax());
            }
        }
        entity.setRentMny(rentMny);
        entity.setRentTaxMny(rentTaxMny);
        entity.setRentTax(rentTax);
    }

    private void packParameterDetailAndContract(List<OutRmatCalculateCacheVO> resultList, Map<String, Map<Long, List<OutRmatCalculateCacheVO>>> contractAllMap, com.ejianc.business.assist.rmat.vo.MaterialVO materialVO, String rentType, Integer day) {
        Map<Long, List<OutRmatCalculateCacheVO>> map = contractAllMap.get(rentType);
        if (MapUtils.isEmpty(map)) {
            return;
        }
        List<OutRmatCalculateCacheVO> cacheList = map.get(materialVO.getMaterialId());
        if (CollectionUtils.isEmpty(cacheList)) {
            return;
        }
        cacheList.sort(Comparator.comparing(OutRmatCalculateCacheVO::getStartDate));
        List flowList = materialVO.getFlowList();
        List<OutRmatCalculateCacheVO> result = new ArrayList<OutRmatCalculateCacheVO>();
        ArrayList<MaterialFlowVO> beginList = materialVO.getBeginList();
        if (CollectionUtils.isEmpty((Collection)beginList) && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO start = (MaterialFlowVO)BeanMapper.map(flowList.get(0), MaterialFlowVO.class);
            start.setNum(BigDecimal.ZERO);
            start.setStartedNum(BigDecimal.ZERO);
            start.setStopedNum(((MaterialFlowVO)flowList.get(0)).getNum());
            beginList = new ArrayList<MaterialFlowVO>(Arrays.asList(start));
            MaterialFlowVO stop = (MaterialFlowVO)BeanMapper.map((Object)start, MaterialFlowVO.class);
            stop.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
            stop.setUseStatus(RENT_TYPE_DAY);
            beginList.add(stop);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList)) {
            for (OutRmatCalculateCacheVO cache : cacheList) {
                for (MaterialFlowVO begin : beginList) {
                    this.dealFlowList(materialVO, cache, begin, CollectionUtils.isNotEmpty((Collection)flowList) ? (MaterialFlowVO)flowList.get(0) : null, result, null);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowList)) {
            flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            for (OutRmatCalculateCacheVO cache : cacheList) {
                for (MaterialFlowVO begin : beginList) {
                    for (int i = 0; i < flowList.size(); ++i) {
                        MaterialFlowVO detailVO = (MaterialFlowVO)flowList.get(i);
                        MaterialFlowVO detailVO1 = i == flowList.size() - 1 ? null : (MaterialFlowVO)flowList.get(i + 1);
                        this.dealFlowList(materialVO, cache, detailVO, detailVO1, result, RENT_TYPE_MONTH.equals(begin.getUseStatus()));
                    }
                }
            }
        }
        result = this.packResultCacheVo(result, day);
        resultList.addAll(result);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private void dealFlowList(com.ejianc.business.assist.rmat.vo.MaterialVO materialVO, OutRmatCalculateCacheVO cache, MaterialFlowVO detailVO, MaterialFlowVO detailVO1, List<OutRmatCalculateCacheVO> result, Boolean beginFlag) {
        Date startDate;
        if (detailVO1 != null) {
            this.setBeginNum(detailVO, detailVO1);
        }
        OutRmatCalculateCacheVO vo = this.transferCacheVO(materialVO, detailVO, cache, beginFlag);
        Date date = startDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO.getMaterialState()) ? DateUtil.beginOfDate((Date)DateUtil.dayAddOne((Date)detailVO.getOperationDate())) : detailVO.getOperationDate();
        if (detailVO1 == null) {
            if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getStartDate()) > 0) {
                if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    return;
                }
                this.setValue(startDate, cache.getEndDate(), vo, result);
            } else {
                this.setValue(cache.getStartDate(), cache.getEndDate(), vo, result);
            }
        } else {
            Date endDate;
            Date date2 = endDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState()) ? detailVO1.getOperationDate() : DateUtil.daySubOne((Date)detailVO1.getOperationDate());
            if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getStartDate()) > 0) {
                if (DateUtil.compareDate((Date)detailVO.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    return;
                }
                if (DateUtil.compareDate((Date)detailVO1.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                    this.setValue(startDate, cache.getEndDate(), vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate((Date)detailVO1.getOperationDate(), (Date)cache.getEndDate()) > 0) {
                this.setValue(cache.getStartDate(), cache.getEndDate(), vo, result);
            } else {
                this.setValue(cache.getStartDate(), endDate, vo, result);
            }
        }
    }

    private void setBeginNum(MaterialFlowVO detailVO, MaterialFlowVO detailVO1) {
        if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState())) {
            if (RENT_TYPE_MONTH.equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(detailVO.getStopedNum());
            } else {
                detailVO1.setStartedNum(detailVO.getStartedNum());
                detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if (RENT_TYPE_MONTH.equals(detailVO1.getUseStatus())) {
            detailVO1.setStartedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        } else {
            detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        }
    }

    private void setValue(Date startDate, Date endDate, OutRmatCalculateCacheVO vo, List<OutRmatCalculateCacheVO> result) {
        if (DateUtil.compareDate((Date)startDate, (Date)endDate) > 0) {
            return;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        if (ComputeUtil.isLessOrEqual((BigDecimal)vo.getNum(), (BigDecimal)BigDecimal.ZERO)) {
            return;
        }
        result.add(vo);
    }

    private OutRmatCalculateCacheVO transferCacheVO(com.ejianc.business.assist.rmat.vo.MaterialVO materialVO, MaterialFlowVO detailVO, OutRmatCalculateCacheVO cache, Boolean flag) {
        OutRmatCalculateCacheVO vo = new OutRmatCalculateCacheVO();
        String rentType = materialVO.getRentCalculationType();
        vo.setParameterId(materialVO.getId());
        vo.setRentType(rentType);
        if (RENT_TYPE_DAY.equals(rentType)) {
            vo.setDailyRecord(cache.getDailyRecord());
        } else if (RENT_TYPE_MONTH.equals(rentType)) {
            vo.setMonthRecord(cache.getMonthRecord());
        }
        if (flag == null) {
            vo.setNum(detailVO.getNum());
            vo.setMaterialState(detailVO.getMaterialState());
        } else if (flag.booleanValue()) {
            vo.setNum(detailVO.getStartedNum());
            vo.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
        } else {
            vo.setNum(detailVO.getStopedNum());
            vo.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
        }
        return vo;
    }

    private boolean checkCacheVoIsMerge(OutRmatCalculateCacheVO vo1, OutRmatCalculateCacheVO vo2) {
        if (!vo1.getMaterialState().equals(vo2.getMaterialState())) {
            return true;
        }
        BigDecimal price1 = null;
        BigDecimal price2 = null;
        if (RENT_TYPE_DAY.equals(vo1.getRentType())) {
            price1 = vo1.getDailyRecord().getUnitTaxPrice();
            price2 = vo2.getDailyRecord().getUnitTaxPrice();
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo1.getMaterialState())) {
                price1 = vo1.getDailyRecord().getStopUnitTaxPrice();
                price2 = vo2.getDailyRecord().getStopUnitTaxPrice();
            }
        } else if (RENT_TYPE_MONTH.equals(vo1.getRentType())) {
            price1 = vo1.getMonthRecord().getUnitTaxPrice();
            price2 = vo2.getMonthRecord().getUnitTaxPrice();
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo1.getMaterialState())) {
                price1 = vo1.getMonthRecord().getStopUnitTaxPrice();
                price2 = vo2.getMonthRecord().getStopUnitTaxPrice();
            }
        } else {
            return true;
        }
        if (price1.equals(price2)) {
            vo1.setEndDate(vo2.getEndDate());
            return false;
        }
        return true;
    }

    private List<OutRmatCalculateCacheVO> packResultCacheVo(List<OutRmatCalculateCacheVO> resultList, Integer day) {
        ArrayList<OutRmatCalculateCacheVO> rtnList = new ArrayList<OutRmatCalculateCacheVO>();
        this.logger.info("\u6839\u636e\u7ed3\u7b97\u65e5:{}\u7ec4\u88c5\u6570\u636e\u6e90\uff1a{}", (Object)day, (Object)JSONObject.toJSONString(resultList));
        for (OutRmatCalculateCacheVO vo : resultList) {
            if (RENT_TYPE_MONTH.equals(vo.getRentType()) && MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                Date endDate;
                Date endUpDate;
                Date startBeginDate = DateUtil.monthDay((Date)vo.getStartDate(), (Integer)day);
                Date startEndDate = DateUtil.monthDay((Date)DateUtil.monthAddOne((Date)vo.getStartDate()), (Integer)day);
                Date endBeginDate = DateUtil.monthDay((Date)vo.getEndDate(), (Integer)day);
                Date endEndDate = DateUtil.monthDay((Date)DateUtil.monthAddOne((Date)vo.getEndDate()), (Integer)day);
                if (DateUtil.compareDay((Date)vo.getStartDate(), (Date)startBeginDate) < 0) {
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) < 0) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        endUpDate = DateUtil.monthDay((Date)DateUtil.addMonths((Date)vo.getEndDate(), (int)-1), (Integer)day);
                        if (DateUtil.compareDay((Date)endUpDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), endUpDate, vo, rtnList);
                            endDate = endUpDate;
                        } else {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), startEndDate, vo, rtnList);
                            endDate = startEndDate;
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) > 0) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        if (DateUtil.compareDay((Date)endBeginDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), endBeginDate, vo, rtnList);
                        }
                        if (DateUtil.compareDay((Date)endBeginDate, (Date)startBeginDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                if (DateUtil.compareDay((Date)vo.getStartDate(), (Date)startBeginDate) > 0) {
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) < 0) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) < 0) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        endUpDate = DateUtil.monthDay((Date)DateUtil.addMonths((Date)vo.getEndDate(), (int)-1), (Integer)day);
                        if (DateUtil.compareDay((Date)endUpDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startEndDate), endUpDate, vo, rtnList);
                            endDate = endUpDate;
                        } else {
                            endDate = startEndDate;
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startEndDate) > 0 && DateUtil.compareDay((Date)vo.getEndDate(), (Date)endBeginDate) > 0) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        if (DateUtil.compareDay((Date)endBeginDate, (Date)startEndDate) > 0) {
                            this.setRstValue(DateUtil.dayAddOne((Date)startEndDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(DateUtil.dayAddOne((Date)endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                if (DateUtil.compareDay((Date)vo.getEndDate(), (Date)startBeginDate) <= 0) continue;
                this.setRstValue(DateUtil.dayAddOne((Date)startBeginDate), vo.getEndDate(), vo, rtnList);
                continue;
            }
            rtnList.add(vo);
        }
        rtnList.sort(Comparator.comparing(OutRmatCalculateCacheVO::getStartDate));
        return rtnList;
    }

    private void setRstValue(Date start, Date end, OutRmatCalculateCacheVO vo, List<OutRmatCalculateCacheVO> rtnList) {
        OutRmatCalculateCacheVO rstvo = new OutRmatCalculateCacheVO();
        rstvo.setStartDate(start);
        rstvo.setEndDate(end);
        rstvo.setNum(vo.getNum());
        rstvo.setMaterialState(vo.getMaterialState());
        rstvo.setRentType(vo.getRentType());
        rstvo.setMonthRecord(vo.getMonthRecord());
        rstvo.setParameterId(vo.getParameterId());
        rstvo.setContractType(vo.getContractType());
        rtnList.add(rstvo);
    }

    private Map<String, Map<Long, List<OutRmatCalculateCacheVO>>> getContractRecord(OutRmatContractEntity contract, Date endDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contract.getId()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("changeDate", new Parameter("le", (Object)endDate));
        queryParam.getOrderMap().put("changeDate", "asc");
        List recordList = this.recordService.queryList(queryParam, false);
        HashMap<String, Map<Long, List<OutRmatCalculateCacheVO>>> rtnMap = new HashMap<String, Map<Long, List<OutRmatCalculateCacheVO>>>();
        int version = 0;
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            this.packContractMap(contract, rtnMap, DateUtil.concatDate((Date)contract.getSignDate(), (Date)contract.getCreateTime()), endDate, version);
            this.logger.info("<<<<\u5408\u540c\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u8bb0\u5f55\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
            return rtnMap;
        }
        List recordIds = recordList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("recordId", new Parameter("in", recordIds));
        List dailyList = this.dailyRecordService.queryList(param, false);
        List monthList = this.monthRecordService.queryList(param, false);
        Map<Long, List<OutRmatContractRecordDailyRentEntity>> dayMap = dailyList.stream().collect(Collectors.groupingBy(OutRmatContractRecordDailyRentEntity::getRecordId));
        Map<Long, List<OutRmatContractRecordMonthRentEntity>> monthMap = monthList.stream().collect(Collectors.groupingBy(OutRmatContractRecordMonthRentEntity::getRecordId));
        Date startDate = null;
        Date changeDate = null;
        for (int i = 0; i < recordList.size(); ++i) {
            OutRmatCalculateCacheVO vo;
            Map<Long, List<Object>> detailMap;
            OutRmatContractRecordEntity record = (OutRmatContractRecordEntity)((Object)recordList.get(i));
            record.setDailyRentList(dayMap.get(record.getId()));
            record.setMonthRentList(monthMap.get(record.getId()));
            if (startDate == null) {
                startDate = DateUtil.concatDate((Date)record.getSignDate(), (Date)record.getCreateTime());
            }
            if (DateUtil.compareDate((Date)startDate, (Date)(changeDate = DateUtil.concatDate((Date)record.getChangeDate(), (Date)record.getCreateTime()))) > 0) continue;
            if (CollectionUtils.isNotEmpty(record.getDailyRentList())) {
                detailMap = (HashMap<Long, List<OutRmatCalculateCacheVO>>)rtnMap.get(RENT_TYPE_DAY);
                if (detailMap == null) {
                    detailMap = new HashMap<Long, List<OutRmatCalculateCacheVO>>();
                }
                for (OutRmatContractRecordDailyRentEntity outRmatContractRecordDailyRentEntity : record.getDailyRentList()) {
                    vo = new OutRmatCalculateCacheVO();
                    vo.setRentType(RENT_TYPE_DAY);
                    vo.setMaterialId(outRmatContractRecordDailyRentEntity.getMaterialId());
                    vo.setStartDate(startDate);
                    vo.setEndDate(DateUtil.daySubOne((Date)changeDate));
                    vo.setNum(outRmatContractRecordDailyRentEntity.getCount());
                    vo.setContractType(Integer.valueOf(1));
                    vo.setDailyRecord((OutRmatContractRecordDailyRentVO)BeanMapper.map((Object)((Object)outRmatContractRecordDailyRentEntity), OutRmatContractRecordDailyRentVO.class));
                    vo.setVersion(Integer.valueOf(version));
                    this.packCacheMap(vo, detailMap);
                }
                rtnMap.put(RENT_TYPE_DAY, detailMap);
            }
            if (CollectionUtils.isNotEmpty(record.getMonthRentList())) {
                detailMap = (Map)rtnMap.get(RENT_TYPE_MONTH);
                if (detailMap == null) {
                    detailMap = new HashMap();
                }
                for (OutRmatContractRecordMonthRentEntity outRmatContractRecordMonthRentEntity : record.getMonthRentList()) {
                    vo = new OutRmatCalculateCacheVO();
                    vo.setRentType(RENT_TYPE_MONTH);
                    vo.setMaterialId(outRmatContractRecordMonthRentEntity.getMaterialId());
                    vo.setStartDate(startDate);
                    vo.setEndDate(DateUtil.daySubOne((Date)changeDate));
                    vo.setNum(outRmatContractRecordMonthRentEntity.getCount());
                    vo.setContractType(Integer.valueOf(1));
                    vo.setMonthRecord((OutRmatContractRecordMonthRentVO)BeanMapper.map((Object)((Object)outRmatContractRecordMonthRentEntity), OutRmatContractRecordMonthRentVO.class));
                    vo.setVersion(Integer.valueOf(version));
                    this.packCacheMap(vo, detailMap);
                }
                rtnMap.put(RENT_TYPE_MONTH, detailMap);
            }
            startDate = DateUtil.concatDate((Date)record.getChangeDate(), (Date)record.getCreateTime());
            ++version;
        }
        this.packContractMap(contract, rtnMap, changeDate, endDate, version);
        this.logger.info("<<<<\u5904\u7406\u5408\u540c\u4fe1\u606f\u7ed3\u675f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
        return rtnMap;
    }

    private void packCacheMap(OutRmatCalculateCacheVO vo, Map<Long, List<OutRmatCalculateCacheVO>> map) {
        if (map == null) {
            map = new HashMap<Long, List<OutRmatCalculateCacheVO>>();
        }
        if (map.containsKey(vo.getMaterialId())) {
            map.get(vo.getMaterialId()).add(vo);
        } else {
            map.put(vo.getMaterialId(), new ArrayList<OutRmatCalculateCacheVO>(Arrays.asList(vo)));
        }
    }

    private void packContractMap(OutRmatContractEntity contract, Map<String, Map<Long, List<OutRmatCalculateCacheVO>>> rtnMap, Date startDate, Date endDate, int version) {
        OutRmatCalculateCacheVO vo;
        OutRmatContractRecordDailyRentVO record;
        Map<Long, List<OutRmatCalculateCacheVO>> detailMap;
        if (DateUtil.compareDate((Date)endDate, (Date)startDate) < 0) {
            return;
        }
        if (CollectionUtils.isNotEmpty(contract.getDailyRentList())) {
            detailMap = rtnMap.get(RENT_TYPE_DAY);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<OutRmatCalculateCacheVO>>();
            }
            record = new OutRmatContractRecordDailyRentVO();
            for (OutRmatContractDailyRentEntity outRmatContractDailyRentEntity : contract.getDailyRentList()) {
                vo = new OutRmatCalculateCacheVO();
                vo.setRentType(RENT_TYPE_DAY);
                vo.setMaterialId(outRmatContractDailyRentEntity.getMaterialId());
                vo.setStartDate(startDate);
                vo.setEndDate(endDate);
                vo.setNum(outRmatContractDailyRentEntity.getCount());
                vo.setContractType(Integer.valueOf(0));
                record = (OutRmatContractRecordDailyRentVO)BeanMapper.map((Object)((Object)outRmatContractDailyRentEntity), OutRmatContractRecordDailyRentVO.class);
                record.setSourceBid(outRmatContractDailyRentEntity.getId());
                vo.setDailyRecord(record);
                vo.setVersion(Integer.valueOf(version));
                this.packCacheMap(vo, detailMap);
            }
            rtnMap.put(RENT_TYPE_DAY, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contract.getMonthRentList())) {
            detailMap = rtnMap.get(RENT_TYPE_MONTH);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<OutRmatCalculateCacheVO>>();
            }
            record = new OutRmatContractRecordMonthRentVO();
            for (OutRmatContractMonthRentEntity outRmatContractMonthRentEntity : contract.getMonthRentList()) {
                vo = new OutRmatCalculateCacheVO();
                vo.setRentType(RENT_TYPE_MONTH);
                vo.setMaterialId(outRmatContractMonthRentEntity.getMaterialId());
                vo.setStartDate(startDate);
                vo.setEndDate(endDate);
                vo.setNum(outRmatContractMonthRentEntity.getCount());
                vo.setContractType(Integer.valueOf(0));
                record = (OutRmatContractRecordMonthRentVO)BeanMapper.map((Object)((Object)outRmatContractMonthRentEntity), OutRmatContractRecordMonthRentVO.class);
                record.setSourceBid(outRmatContractMonthRentEntity.getId());
                vo.setMonthRecord((OutRmatContractRecordMonthRentVO)record);
                vo.setVersion(Integer.valueOf(version));
                this.packCacheMap(vo, detailMap);
            }
            rtnMap.put(RENT_TYPE_MONTH, detailMap);
        }
    }

    private BigDecimal getMny(BigDecimal price, Integer days, BigDecimal num) {
        return ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal[])new BigDecimal[]{new BigDecimal(days), num});
    }
}

