package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractFreezeEntity;
import com.ejianc.business.assist.material.mapper.MaterialContractFreezeMapper;
import com.ejianc.business.assist.material.service.IMaterialContractFreezeService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractFreezeVO;
import com.ejianc.business.assist.material.vo.record.MaterialFreezeRecordVO;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 辅料中心采购合同-合同冻结
 * 
 * @author generator
 * 
 */
@Service("materialContractFreezeService")
public class MaterialContractFreezeServiceImpl extends BaseServiceImpl<MaterialContractFreezeMapper, MaterialContractFreezeEntity> implements IMaterialContractFreezeService{

    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_FREEZE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IMaterialContractService contractService;
    
    @Override
    public MaterialContractFreezeVO saveOrUpdate(MaterialContractFreezeVO saveOrUpdateVO) {
        // 合同统一校验
        contractService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.冻结单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        
        MaterialContractFreezeEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialContractFreezeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        
        this.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, MaterialContractFreezeVO.class);
    }

    @Override
    public MaterialFreezeRecordVO queryFreezeRecord(Long id) {
        MaterialContractEntity entity = contractService.selectById(id);
        MaterialFreezeRecordVO vo = new MaterialFreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询冻结单
        LambdaQueryWrapper<MaterialContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialContractFreezeEntity::getContractId, id);
        wrapper.orderByDesc(MaterialContractFreezeEntity::getCreateTime);

        List<MaterialContractFreezeEntity> list = this.list(wrapper);

        vo.setDetailList(BeanMapper.mapList(list, MaterialContractFreezeVO.class));
        
        return vo;
        
    }
}
