package com.ejianc.business.outrmat.restitute.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IRestituteService;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("outRmatRestitute") 
public class OutRmatRestituteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOutRmatRestituteService service;

	@Autowired
	private IOutRmatMaterialService outRmatMaterialService;
	@Autowired
	private StoreManageService storeManageService;

	@Autowired
	private IRmatFlowService flowService;
	@Autowired
	private IReceiptsApi receiptsApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatRestituteEntity entity = service.selectById(billId);
		entity.setSubmitTime(new Date());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutRmatRestituteEntity entity = service.selectById(billId);
		//推送供方验收单
		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(entity.getRentType())){
			//辅料中心与项目方组织转换 复制一个新对象推送，防止后面有保存/修改操作
			OutRmatRestituteEntity map = BeanMapper.map(entity, OutRmatRestituteEntity.class);
			map.setOrgId(entity.getProjectDeptId());
			map.setOrgCode(entity.getProjectDeptCode());
			map.setOrgName(entity.getProjectDeptName());
			map.setParentOrgCode(entity.getProjectOrgCode());
			map.setParentOrgId(entity.getProjectOrgId());
			map.setParentOrgName(entity.getProjectOrgName());
			logger.info("推送辅料中心数据"+JSONObject.toJSONString(map)+"----");
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(map), ReceiptsEnum.退赔单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
		}

//		//单据协同推送
//		boolean pushResult = service.pushBillToSupCenter(entity);
//		if(pushResult) {
//			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//		} else {
//			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.退赔单.getName(), billId);
//			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//		}
		entity.setSubmitTime(new Date());
		// 推送流水生效
		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		//更新流水
		OutRmatRestituteVO outRmatRestituteVO = BeanMapper.map(entity, OutRmatRestituteVO.class);
		List<StoreManageVO> storeManageVOList = service.getStoreManageVOList(outRmatRestituteVO, true);
		if(CollectionUtils.isNotEmpty(storeManageVOList)){
			logger.info("库存所有入参："+ JSONObject.toJSONString(storeManageVOList));
			for (StoreManageVO storeManageVO : storeManageVOList) {
				logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
				CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStore(storeManageVO);
				if(!storeManageVOCommonResponse.isSuccess()) {
					throw new BusinessException("调用库存管理失败,错误信息：" + storeManageVOCommonResponse.getMsg());
				}
			}
		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutRmatRestituteEntity entity = service.selectById(billId);
		//检测单据是否供应商已签字，
		if(SupplierSignStatusEnum.乙方已签字.getCode().equals(entity.getSupplierSignStatus())) {
			return CommonResponse.error("供应商已签字，无法执行此操作！");
		}
		// 同一个合同只能存在一个自由态或审批中的单据
		outRmatMaterialService.validateContract(entity.getContractId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		service.validateTime(BeanMapper.map(entity, OutRmatRestituteVO.class), MaterialConstant.弃审);
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
//		//将推送至供方的单据作废
//		if (BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
//			boolean pushResult = service.delPushBill(entity);
//			if (!pushResult) {
//				return CommonResponse.error("弃审前回调失败，单据作废协同服务失败！");
//			} else {
//				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//			}
//		}
		entity.setSubmitTime(null);
		service.saveOrUpdate(entity, false);
		// 推送流水未生效
		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("弃审前回调失败，单据推送流水失败！");
		}
		return CommonResponse.success("弃审前回调成功！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatRestituteEntity outRmatRestituteEntity = service.selectById(billId);
		// 内阻推送供方
		if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(outRmatRestituteEntity.getRentType())){
			//将推送至供方的单据作废
			if (BillPushStatusEnum.推送成功.getStatus().equals(outRmatRestituteEntity.getBillPushFlag())) {
				CommonResponse<String> response = receiptsApi.delReceipts(outRmatRestituteEntity.getId(), ReceiptsEnum.退赔单.getName());
				if(!response.isSuccess()){
					throw new BusinessException(response.getMsg());
				} else {
					outRmatRestituteEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
				}
			}
		}
		//更新流水
		OutRmatRestituteVO outRmatRestituteVO = BeanMapper.map(outRmatRestituteEntity, OutRmatRestituteVO.class);
		if (CollectionUtils.isNotEmpty(outRmatRestituteEntity.getRestituteDetailList())){
			Map<Long, List<OutRmatRestituteDetailEntity>> detailMap = outRmatRestituteEntity.getRestituteDetailList().stream().filter(t->null!=t.getStoreId()).collect(Collectors.groupingBy(OutRmatRestituteDetailEntity::getStoreId));
			if(MapUtils.isNotEmpty(detailMap)) {
				for (Long storeId : detailMap.keySet()) {//材料来源,0-自购,1-租赁
					List<OutRmatRestituteDetailEntity> detailVOList = detailMap.get(storeId).stream().filter(t ->null!= t.getSourceType() && 0== t.getSourceType() && (BigDecimal.ZERO.compareTo(ComputeUtil.safeDiv(t.getScrapNum(), t.getTransScale()))!=0) ).collect(Collectors.toList());
					//调用库存
					if (CollectionUtils.isNotEmpty(detailVOList)) {
						StoreManageVO storeManageVO = new StoreManageVO();
						storeManageVO.setStoreId(storeId);
						storeManageVO.setSourceId(outRmatRestituteEntity.getId());
						storeManageVO.setInOutTypeEnum(InOutTypeEnum.辅料中心租出退赔);
						storeManageVO.setOutEffectiveON(true);
						ArrayList<Long> longs = new ArrayList<>();
						longs.add(outRmatRestituteEntity.getId());
						storeManageVO.setSourceIdsForRollBack(longs);
						logger.info("库存入参："+JSONObject.toJSONString(storeManageVO));
						CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
						if(!response.isSuccess()) {
							throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
						}

					}
				}
			}
		}
		service.saveOrUpdate(outRmatRestituteEntity, false);
		return CommonResponse.success();
	}

}
