/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.enums.RequireFlagEnum;
import com.ejianc.business.outrmat.delivery.enums.WeighFlagEnum;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatDelivery")
public class OutRmatDeliveryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOutRmatDeliveryService service;
    @Autowired
    private IOutRmatContractService contractService;
    @Autowired
    private IReceiptsApi receiptsApi;
    @Autowired
    private IRmatFlowService flowService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatDeliveryEntity outRmatDeliveryEntity = (OutRmatDeliveryEntity)((Object)this.service.selectById(billId));
        if (outRmatDeliveryEntity.getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outRmatDeliveryEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatDeliveryEntity outRmatDeliveryEntity;
        if (state == 0 && (outRmatDeliveryEntity = (OutRmatDeliveryEntity)((Object)this.service.selectById(billId))).getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outRmatDeliveryEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatDeliveryEntity outRmatDeliveryEntity = (OutRmatDeliveryEntity)((Object)this.service.selectById(billId));
        if (!this.flowService.insertCheckFlow(outRmatDeliveryEntity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if ("1".equals(String.valueOf(outRmatDeliveryEntity.getRentType()))) {
            OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.contractService.selectById(outRmatDeliveryEntity.getContractId()));
            OutRmatDeliveryVO map = (OutRmatDeliveryVO)BeanMapper.map((Object)((Object)outRmatDeliveryEntity), OutRmatDeliveryVO.class);
            map.setSupplierId(outRmatContractEntity.getSupplierId());
            map.setSupplierName(outRmatContractEntity.getSupplierName());
            map.setOrgId(outRmatDeliveryEntity.getProjectDeptId());
            map.setOrgCode(outRmatDeliveryEntity.getProjectDeptCode());
            map.setOrgName(outRmatDeliveryEntity.getProjectDeptName());
            map.setParentOrgCode(outRmatDeliveryEntity.getProjectOrgCode());
            map.setParentOrgId(outRmatDeliveryEntity.getProjectOrgId());
            map.setParentOrgName(outRmatDeliveryEntity.getProjectOrgName());
            this.logger.info("\u63a8\u9001\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + JSONObject.toJSONString((Object)map) + "----");
            CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)map), ReceiptsEnum.\u9a8c\u6536\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatDeliveryEntity outRmatDeliveryEntity = (OutRmatDeliveryEntity)((Object)this.service.selectById(billId));
        if (null != outRmatDeliveryEntity.getSupplierSignStatus() && outRmatDeliveryEntity.getSupplierSignStatus() == 1) {
            return CommonResponse.error((String)"\u5df2\u7b7e\u5b57\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        OutRmatDeliveryEntity outRmatDeliveryEntity = (OutRmatDeliveryEntity)((Object)this.service.selectById(billId));
        if (!this.flowService.insertCheckFlow(outRmatDeliveryEntity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if ("1".equals(String.valueOf(outRmatDeliveryEntity.getRentType())) && !(response = this.receiptsApi.delReceipts(outRmatDeliveryEntity.getId(), ReceiptsEnum.\u9a8c\u6536\u5355.getName())).isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success();
    }
}

