package com.ejianc.business.outrmat.restitute.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.assist.rmat.bean.RestituteDetailEntity;
import com.ejianc.business.assist.rmat.bean.RestituteMaintainEntity;
import com.ejianc.business.assist.rmat.bean.RestituteOtherEntity;
import com.ejianc.business.assist.rmat.bean.RestituteScrapEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteDetailEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteMaintainEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteScrapEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteOtherEntity;
/**
 * out-退赔单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outrmat_restitute")
public class OutRmatRestituteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="stop_date")
    private Date stopDate; // 止租日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 部门
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供方主键
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="confirm_state")
    private String confirmState; // 是否确认
    @TableField(value="supplier_sign_status")
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    @TableField(value="sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(value="restitute_date")
    private Date restituteDate; // 退赔日期
    @TableField(value="material_type_names")
    private String materialTypeNames; // 材料分类
    @TableField(exist = false)
    private Long supOperateFileId;// 供方经办人签字文件id
    @TableField(exist = false)
    private String sourceSystemId;// 来源业务系统id
    @TableField(value="first_party_id")
    private Long firstPartyId;//甲方Id
    @TableField(value="first_party_name")
    private String firstPartyName;//甲方名称
    @TableField(value = "bill_push_flag")
    private String billPushFlag;// 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value = "submit_time")
    private Date submitTime;//单据提交时间
    @TableField(value = "settle_flag")
    private Integer settleFlag;//是否结算
    @TableField(value = "total_maintain_tax_mny")
    private BigDecimal totalMaintainTaxMny; // 本次维修金额汇总
    @TableField(value = "total_maintain_mny")
    private BigDecimal totalMaintainMny; // 本次维修金额汇总(无税)
    @TableField(value = "total_maintain_tax")
    private BigDecimal totalMaintainTax; // 维修税额
    @TableField(value = "total_scrap_tax_mny")
    private BigDecimal totalScrapTaxMny; // 损坏赔偿金额(含税)
    @TableField(value = "total_scrap_mny")
    private BigDecimal totalScrapMny; // 损坏赔偿金额
    @TableField(value = "total_scrap_tax")
    private BigDecimal totalScrapTax; // 损坏赔偿税额
    @TableField(value="restitute_unit")
    private Long restituteUnit;//退赔单位Id
    @TableField(value="restitute_unit_name")
    private String restituteUnitName;//退赔单位名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="rent_type")
    private String rentType; // 租赁方式：0-外租，1-内租
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; //
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_org_id")
    private Long projectOrgId; // 项目组织id
    @TableField(value="project_org_code")
    private String projectOrgCode; // 项目组织code
    @TableField(value="project_org_name")
    private String projectOrgName; // 项目组织name
    @TableField(value="project_dept_id")
    private Long projectDeptId; // 项目部门id
    @TableField(value="project_dept_code")
    private String projectDeptCode; // 项目部门code
    @TableField(value="project_dept_name")
    private String projectDeptName; // 项目部门name

    @TableField(exist=false)
    @SubEntity(serviceName="outRmatRestituteDetailService",pidName = "restituteId")
    private List<OutRmatRestituteDetailEntity> restituteDetailList = new ArrayList<>(); // 退赔单材料明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="outRmatRestituteMaintainService",pidName = "restituteId")
    private List<OutRmatRestituteMaintainEntity> restituteMaintainList = new ArrayList<>(); // 退赔单维修清单明细
    @TableField(exist=false)
    @SubEntity(serviceName="outRmatRestituteScrapService",pidName = "restituteId")
    private List<OutRmatRestituteScrapEntity> restituteScrapList = new ArrayList<>(); // 退赔单报废清单明细
    @TableField(exist=false)
    @SubEntity(serviceName="outRmatRestituteOtherService",pidName = "restituteId")
    private List<OutRmatRestituteOtherEntity> otherList = new ArrayList<>(); // 退赔单其他费用明细

    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }

    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }

    public Long getProjectDeptId() {
        return projectDeptId;
    }

    public void setProjectDeptId(Long projectDeptId) {
        this.projectDeptId = projectDeptId;
    }

    public String getProjectDeptCode() {
        return projectDeptCode;
    }

    public void setProjectDeptCode(String projectDeptCode) {
        this.projectDeptCode = projectDeptCode;
    }

    public String getProjectDeptName() {
        return projectDeptName;
    }

    public void setProjectDeptName(String projectDeptName) {
        this.projectDeptName = projectDeptName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getStopDate() {
        return stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getConfirmState() {
        return confirmState;
    }

    public void setConfirmState(String confirmState) {
        this.confirmState = confirmState;
    }
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getRestituteDate() {
        return restituteDate;
    }

    public void setRestituteDate(Date restituteDate) {
        this.restituteDate = restituteDate;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public BigDecimal getTotalMaintainTaxMny() {
        return totalMaintainTaxMny;
    }

    public void setTotalMaintainTaxMny(BigDecimal totalMaintainTaxMny) {
        this.totalMaintainTaxMny = totalMaintainTaxMny;
    }

    public BigDecimal getTotalMaintainMny() {
        return totalMaintainMny;
    }

    public void setTotalMaintainMny(BigDecimal totalMaintainMny) {
        this.totalMaintainMny = totalMaintainMny;
    }

    public BigDecimal getTotalMaintainTax() {
        return totalMaintainTax;
    }

    public void setTotalMaintainTax(BigDecimal totalMaintainTax) {
        this.totalMaintainTax = totalMaintainTax;
    }

    public BigDecimal getTotalScrapTaxMny() {
        return totalScrapTaxMny;
    }

    public void setTotalScrapTaxMny(BigDecimal totalScrapTaxMny) {
        this.totalScrapTaxMny = totalScrapTaxMny;
    }

    public BigDecimal getTotalScrapMny() {
        return totalScrapMny;
    }

    public void setTotalScrapMny(BigDecimal totalScrapMny) {
        this.totalScrapMny = totalScrapMny;
    }

    public BigDecimal getTotalScrapTax() {
        return totalScrapTax;
    }

    public void setTotalScrapTax(BigDecimal totalScrapTax) {
        this.totalScrapTax = totalScrapTax;
    }


    public List<OutRmatRestituteDetailEntity> getRestituteDetailList() {
        return restituteDetailList;
    }

    public void setRestituteDetailList(List<OutRmatRestituteDetailEntity> restituteDetailList) {
        this.restituteDetailList = restituteDetailList;
    }

    public List<OutRmatRestituteMaintainEntity> getRestituteMaintainList() {
        return restituteMaintainList;
    }

    public void setRestituteMaintainList(List<OutRmatRestituteMaintainEntity> restituteMaintainList) {
        this.restituteMaintainList = restituteMaintainList;
    }

    public List<OutRmatRestituteScrapEntity> getRestituteScrapList() {
        return restituteScrapList;
    }

    public void setRestituteScrapList(List<OutRmatRestituteScrapEntity> restituteScrapList) {
        this.restituteScrapList = restituteScrapList;
    }

    public List<OutRmatRestituteOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<OutRmatRestituteOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public Long getRestituteUnit() {
        return restituteUnit;
    }

    public void setRestituteUnit(Long restituteUnit) {
        this.restituteUnit = restituteUnit;
    }

    public String getRestituteUnitName() {
        return restituteUnitName;
    }

    public void setRestituteUnitName(String restituteUnitName) {
        this.restituteUnitName = restituteUnitName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
}
