package com.ejianc.business.outrmat.stop.service;



import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.stop.vo.OutRmatStopVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 停用单实体
 * 
 * @author generator
 * 
 */
public interface IOutRmatStopService extends IBaseService<OutRmatStopEntity> {

    OutRmatStopVO saveOrUpdate(OutRmatStopVO saveOrUpdateVO);

    String validateContract(Long contractId, Long billId);

    String validateTime(OutRmatStopVO outRmatStopVO, String type);

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(OutRmatStopEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(OutRmatStopEntity entity);

    String updateBillSupSignSync(Map<String,String> map);

}
