/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="process")
public class ProcessBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessService service;
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private IRmatFlowService rmatFlowService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        block7: {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateProcessIn", (int)1000);
            this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
            try {
                if (locked) {
                    break block7;
                }
                CommonResponse commonResponse = CommonResponse.success((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return commonResponse;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateProcessIn");
                }
                jedis.close();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(billId);
        this.service.processInOut(longs, true);
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(billId));
        ArrayList<ProcessProductEntity> productList = new ArrayList<ProcessProductEntity>();
        List<ProcessProductEntity> proceeProductList = entity.getProcessProductList();
        for (ProcessProductEntity detailEntity : proceeProductList) {
            if (detailEntity.getProcessNum() == null || detailEntity.getProcessNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            productList.add(detailEntity);
        }
        if (productList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93);
            ArrayList flowVOS = new ArrayList();
            productList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialTypeId());
                flowVO.setMaterialCategoryName(item.getMaterialTypeName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialCode(item.getMaterialCode());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setMaterialUnitId(item.getUnitId());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setNum(item.getProcessNum());
                flowVO.setTaxPrice(item.getTaxPrice());
                flowVO.setTaxMny(item.getTaxMny());
                flowVO.setPrice(item.getPrice());
                flowVO.setMny(item.getMny());
                flowVO.setTax(item.getTax());
                flowVO.setTaxRate(item.getTaxRate());
                flowVO.setNetMny(flowVO.getMny());
                flowVO.setNetTaxMny(flowVO.getTaxMny());
                flowVO.setPurchasePrice(flowVO.getPrice());
                flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getProcessDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error((String)commonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse;
        ProcessEntity processEntity = (ProcessEntity)((Object)this.service.selectById(billId));
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)processEntity.getCreateTime());
        if (processEntity != null && !(commonResponse = this.checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)processEntity.getProcessDate()))).isSuccess()) {
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(billId));
        Boolean checkFlag = false;
        List<ProcessProductEntity> processProductList = entity.getProcessProductList();
        List inMaterialIds = processProductList.stream().map(ProcessProductEntity::getMaterialId).collect(Collectors.toList());
        for (ProcessProductEntity item : processProductList) {
            if (item.getProcessNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            QueryWrapper wrapper2 = new QueryWrapper();
            wrapper2.orderByDesc((Object)"create_time");
            wrapper2.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_OUT);
            wrapper2.in((Object)"material_id", inMaterialIds);
            wrapper2.eq((Object)"store_id", (Object)entity.getStoreId());
            wrapper2.ne((Object)"source_id", (Object)billId);
            wrapper2.apply(" (create_time > '" + createTime + "')", new Object[0]);
            List list1 = this.flowService.list((Wrapper)wrapper2);
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                return CommonResponse.error((String)"\u7269\u8d44\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
            QueryWrapper wrapper3 = new QueryWrapper();
            wrapper3.orderByDesc((Object)"create_time");
            wrapper3.eq((Object)"bill_type_code", (Object)BillTypeEnum.\u79df\u51fa\u51fa\u5e93\u5355.getCode());
            wrapper3.in((Object)"material_id", inMaterialIds);
            wrapper3.eq((Object)"store_id", (Object)entity.getStoreId());
            wrapper3.apply(" (create_time > '" + createTime + "')", new Object[0]);
            List list2 = this.rmatFlowService.list((Wrapper)wrapper3);
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                return CommonResponse.error((String)"\u7269\u6599\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
            }
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        List<ProcessRawEntity> processRawList = entity.getProcessRawList();
        ArrayList<Long> storeList = new ArrayList<Long>();
        for (ProcessRawEntity item : processRawList) {
            if (item.getRawNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            storeList.add(item.getStoreId());
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId((Long)storeList.get(0));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

