/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.lose.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.IInOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseDetailEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.mapper.OutRmatLoseMapper;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.outrmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatLoseService")
public class OutRmatLoseServiceImpl
extends BaseServiceImpl<OutRmatLoseMapper, OutRmatLoseEntity>
implements IOutRmatLoseService {
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IReceiptsApi receiptsApi;
    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getName();
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FLZX_ZCYSD_CODE";
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private IInOutService inOutService;

    @Override
    public List<StoreManageVO> getStoreManageVOList(OutRmatLoseVO vo, Boolean outEffectiveON) {
        ArrayList<StoreManageVO> storeManageVOList = new ArrayList<StoreManageVO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getLoseDetailList())) {
            List collect = vo.getLoseDetailList().stream().map(t -> t.getId()).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(FlowEntity::getSourceId, (Object)vo.getId());
            queryWrapper.in(FlowEntity::getSourceDetailId, collect);
            queryWrapper.eq(FlowEntity::getEffectiveState, (Object)StoreCommonConsts.NO);
            List inOutEntityList = this.flowService.list((Wrapper)queryWrapper);
            Map inOutMap = inOutEntityList.stream().collect(Collectors.toMap(FlowEntity::getSourceDetailId, Function.identity(), (k1, k2) -> k2));
            Map<Long, List<OutRmatLoseDetailVO>> detailMap = vo.getLoseDetailList().stream().filter(t -> null != t.getStoreId()).collect(Collectors.groupingBy(OutRmatLoseDetailVO::getStoreId));
            if (MapUtils.isNotEmpty(detailMap)) {
                for (Long storeId : detailMap.keySet()) {
                    List detailVOList = detailMap.get(storeId).stream().filter(t -> null != t.getSourceType() && 0 == t.getSourceType()).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(detailVOList)) continue;
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(storeId);
                    storeManageVO.setSourceId(vo.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9057\u5931);
                    storeManageVO.setOutEffectiveON(outEffectiveON);
                    ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
                    for (OutRmatLoseDetailVO t2 : detailVOList) {
                        FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9057\u5931, (Integer)0);
                        flowVO.setStoreId(t2.getStoreId());
                        flowVO.setStoreName(t2.getStoreName());
                        flowVO.setProjectId(vo.getProjectId());
                        flowVO.setProjectName(vo.getProjectName());
                        flowVO.setOrgId(vo.getOrgId());
                        flowVO.setOrgName(vo.getOrgName());
                        flowVO.setParentOrgId(vo.getParentOrgId());
                        flowVO.setParentOrgName(vo.getParentOrgName());
                        flowVO.setEmployeeId(vo.getEmployeeId());
                        flowVO.setEmployeeName(vo.getEmployeeName());
                        flowVO.setMaterialCategoryId(t2.getMaterialTypeId());
                        flowVO.setMaterialCategoryName(t2.getMaterialTypeName());
                        flowVO.setMaterialId(t2.getMaterialId());
                        flowVO.setMaterialName(t2.getMaterialName());
                        flowVO.setMaterialSpec(t2.getSpec());
                        flowVO.setMaterialUnitId(t2.getUnitMId());
                        flowVO.setMaterialUnitName(t2.getUnitMName());
                        flowVO.setSourceBillDetailRemark(t2.getMemo());
                        flowVO.setTaxPrice(ComputeUtil.safeAdd((BigDecimal)t2.getLoseTaxPrice(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setPrice(ComputeUtil.safeAdd((BigDecimal)t2.getLosePrice(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setNum(t2.getNumM());
                        flowVO.setTaxMny(ComputeUtil.safeAdd((BigDecimal)t2.getCompensationTaxMny(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setMny(ComputeUtil.safeAdd((BigDecimal)t2.getCompensationMny(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setTax(ComputeUtil.safeAdd((BigDecimal)t2.getTax(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setOutNetMny(ComputeUtil.safeAdd((BigDecimal)t2.getCompensationMny(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setOutNetTaxMny(ComputeUtil.safeAdd((BigDecimal)t2.getCompensationTaxMny(), (BigDecimal)BigDecimal.ZERO));
                        flowVO.setTenantId(t2.getTenantId());
                        flowVO.setSourceId(vo.getId());
                        flowVO.setSourceDetailId(t2.getId());
                        flowVO.setSourceBillCode(vo.getBillCode());
                        flowVO.setSourceBillDate(vo.getBillDate());
                        flowVO.setRowState(t2.getRowState());
                        flowVO.setSourceBillRemark(vo.getMemo());
                        if (BigDecimal.ZERO.compareTo(flowVO.getNum()) == 0 && (outEffectiveON.booleanValue() || !inOutMap.containsKey(t2.getId()))) continue;
                        flowVOS.add(flowVO);
                    }
                    if (!CollectionUtils.isNotEmpty(flowVOS)) continue;
                    storeManageVO.setFlowVOList(flowVOS);
                    storeManageVOList.add(storeManageVO);
                }
            }
        }
        return storeManageVOList;
    }

    @Override
    public OutRmatLoseVO saveOrUpdate(OutRmatLoseVO saveOrUpdateVO) {
        List<StoreManageVO> storeManageVOList;
        this.outRmatMaterialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        this.validateNum(saveOrUpdateVO);
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatLoseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getLoseDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        boolean b = super.saveOrUpdate((Object)entity, false);
        OutRmatLoseVO map = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        List detailVOS = saveOrUpdateVO.getLoseDetailList().stream().filter(t -> "del".equals(t.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            map.getLoseDetailList().addAll(detailVOS);
        }
        if (!this.rmatFlowService.insertLoseFlow((OutRmatLoseEntity)((Object)BeanMapper.map((Object)map, OutRmatLoseEntity.class)), BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode(), RmatCommonConsts.NO).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (b && CollectionUtils.isNotEmpty(storeManageVOList = this.getStoreManageVOList(map, false))) {
            this.logger.info("\u5e93\u5b58\u6240\u6709\u5165\u53c2\uff1a" + JSONObject.toJSONString(storeManageVOList));
            for (StoreManageVO storeManageVO : storeManageVOList) {
                this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                CommonResponse<StoreManageVO> response = this.storeManageService.inOutStore(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        OutRmatLoseVO vo = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        return vo;
    }

    @Override
    public void delete(List<OutRmatLoseVO> vos) {
        List<Long> ids;
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatLoseVO vo : vos) {
                Map<Long, List<OutRmatLoseDetailEntity>> detailMap;
                OutRmatLoseEntity outRmatLoseEntity = (OutRmatLoseEntity)((Object)super.selectById((Serializable)vo.getId()));
                if (!CollectionUtils.isNotEmpty(outRmatLoseEntity.getLoseDetailList()) || !MapUtils.isNotEmpty(detailMap = outRmatLoseEntity.getLoseDetailList().stream().filter(t -> null != t.getStoreId()).collect(Collectors.groupingBy(OutRmatLoseDetailEntity::getStoreId)))) continue;
                for (Long storeId : detailMap.keySet()) {
                    List detailVOList = detailMap.get(storeId).stream().filter(t -> null != t.getSourceType() && 0 == t.getSourceType() && BigDecimal.ZERO.compareTo(t.getNumM()) != 0).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(detailVOList)) continue;
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(storeId);
                    storeManageVO.setSourceId(outRmatLoseEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9057\u5931);
                    storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
                    ArrayList<Long> longs = new ArrayList<Long>();
                    longs.add(outRmatLoseEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                    CommonResponse<StoreManageVO> response = this.storeManageService.inOutStoreRollback(storeManageVO);
                    if (response.isSuccess()) continue;
                    throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
                }
            }
        }
        if (!this.rmatFlowService.delFlow(ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList()), BillTypeEnum.\u79df\u51fa\u9057\u5931\u5355.getCode()).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        super.removeByIds(ids, true);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9057\u5931\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateTime(OutRmatLoseVO outRmatLoseVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", outRmatLoseVO.getContractId());
        if (outRmatLoseVO.getId() != null) {
            params.put("billType", "\u9057\u5931\u5355");
            params.put("billId", outRmatLoseVO.getId());
        }
        Date lastDate = this.outRmatMaterialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.outRmatMaterialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate((Date)outRmatLoseVO.getStopDate(), (Date)lastDate, maxTimeMap, (Date)outRmatLoseVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate((Date)outRmatLoseVO.getStopDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        for (OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()) {
            if (!ValidateUtil.compareDate((Date)vo.getDate(), (Date)lastDate, maxTimeMap, (Date)vo.getCreateTime())) continue;
            throw new BusinessException(DateUtil.formatDate((Date)vo.getDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate((Date)lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatLoseEntity entity) {
        OutRmatLoseEntity map = (OutRmatLoseEntity)((Object)BeanMapper.map((Object)((Object)entity), OutRmatLoseEntity.class));
        map.setOrgId(entity.getProjectDeptId());
        map.setOrgCode(entity.getProjectDeptCode());
        map.setOrgName(entity.getProjectDeptName());
        map.setParentOrgCode(entity.getProjectOrgCode());
        map.setParentOrgId(entity.getProjectOrgId());
        map.setParentOrgName(entity.getProjectOrgName());
        this.logger.info("\u63a8\u9001\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + JSONObject.toJSONString((Object)((Object)map)) + "----");
        CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)((Object)map)), ReceiptsEnum.\u9057\u5931\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(Map<String, String> map) {
        String billId = map.get("billId");
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)super.selectById((Serializable)Long.valueOf(billId)));
        String msg = this.pushSupUtil.updateBillSupSignSync(map, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatLoseEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatLoseEntity entity) {
        CommonResponse response = this.receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.\u9057\u5931\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    private String validateNum(OutRmatLoseVO outRmatLoseVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)outRmatLoseVO.getContractId()));
        List<MaterialVO> list = this.outRmatMaterialService.queryCheckList(param, "lose");
        Map map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId() + "|" + x.getRentCalculationType() + "|" + x.getUseStatus() + "|" + x.getTransScale(), Function.identity()));
        String key = null;
        for (OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()) {
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
            if (!map.containsKey(key) || vo.getLoseNum().compareTo(((MaterialVO)map.get(key)).getRefNum()) <= 0) continue;
            throw new BusinessException("\u5b50\u8868\u6570\u91cf\u5927\u4e8e\u53ef\u53c2\u7167\u6570\u91cf");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

