/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.vo.StoreNumVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractNumRentEntity;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractDailyRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractMonthRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractNumRentService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRentRefVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSupplementRecordVO;
import com.ejianc.business.outrmat.utils.PageUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRmatContract"})
public class OutRmatContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IOutRmatContractService service;
    @Autowired
    private IOutRmatContractDailyRentService dailyRentService;
    @Autowired
    private IOutRmatContractMonthRentService monthRentService;
    @Autowired
    private IOutRmatContractNumRentService numRentService;
    @Autowired
    private IOutRmatContractRelieveService relieveService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IShareMaterialApi materialApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatContractVO> saveOrUpdate(@RequestBody OutRmatContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO, authority));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatContractVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatContractVO> vos) {
        return CommonResponse.success((String)this.service.delete(vos));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.pageList(param));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List list = (List)((JSONObject)commonResponse.getData()).get((Object)"records");
        List returnList = BeanMapper.mapList((Iterable)list, OutRmatContractVO.class);
        if (ListUtil.isNotEmpty((List)returnList)) {
            for (OutRmatContractVO vo : returnList) {
                if (StringUtils.isBlank((CharSequence)vo.getPerformanceStatus())) {
                    vo.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode((String)vo.getPerformanceStatus()).getDescription());
                }
                if (vo.getSignatureStatus() == null) {
                    vo.setSignatureStatusName(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode((Integer)vo.getSignatureStatus()).getDescription());
                }
                vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode((String)vo.getPerformanceStatus()).getDescription());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", returnList);
        ExcelExport.getInstance().export("out-arri-contract-export.xlsx", beans, response);
    }

    @GetMapping(value={"/outRmatContractRef"})
    @ResponseBody
    public CommonResponse<IPage<ContractPoolVO>> outRmatContractRef(@RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize, String searchText, String searchObject, String condition, String relyCondition) throws Exception {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchObject(searchObject);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("billCode", "contractName", "projectName", "firstPartyName", "supplierName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String performanceStatusParam;
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            String rentType = conditionJson.getString("rentType");
            if (StringUtils.isBlank((CharSequence)projectId) && StringUtils.isBlank((CharSequence)orgId) && StringUtils.isBlank((CharSequence)orgType)) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570projectId\u6216\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId,orgType\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                this.logger.info("condition\u4e2dprojectId\uff1a{}", (Object)projectId);
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.valueOf(projectId)));
            } else {
                if (StringUtils.isBlank((CharSequence)orgId)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId\uff01");
                }
                if (StringUtils.isBlank((CharSequence)orgType)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgType\uff01");
                }
                if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    param.getParams().put("orgId", new Parameter("eq", (Object)Long.valueOf(orgId)));
                } else {
                    CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if (!orgResp.isSuccess()) {
                        this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)rentType)) {
                param.getParams().put("rentType", new Parameter("eq", (Object)rentType));
            }
            if (StringUtils.isNotBlank((CharSequence)(performanceStatusParam = conditionJson.getString("performanceStatus")))) {
                param.getParams().put("performanceStatus", new Parameter("in", (Object)performanceStatusParam.split(",")));
            } else {
                param.getParams().put("performanceStatus", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
            }
            param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        }
        IPage page = this.service.queryPage(param, false);
        ArrayList<ContractPoolVO> contractLists = new ArrayList<ContractPoolVO>();
        ContractPoolVO tmp = null;
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            for (OutRmatContractEntity c : page.getRecords()) {
                tmp = (ContractPoolVO)BeanConvertorUtil.convert((Object)BeanMapper.map((Object)((Object)c), OutRmatContractVO.class), ContractPoolVO.class);
                tmp.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u51fa\u5408\u540c.getTypeCode());
                contractLists.add(tmp);
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(contractLists);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/arriContractRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractVO>> arriContractRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("performanceStatus", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getParams().put("changeStatus", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            if (condition.contains("rentType")) {
                param.getParams().put("rentType", new Parameter("eq", conditionMap.get("rentType")));
            }
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), OutRmatContractVO.class);
        Iterator iterator = voList.iterator();
        while (iterator.hasNext()) {
            OutRmatContractVO vo;
            vo.setRentTypeName("0".equals((vo = (OutRmatContractVO)iterator.next()).getRentType()) ? "\u5916\u79df" : "\u5185\u79df");
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/arriContractRentRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractRentRefVO>> arriContractRentRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("materialId", new Parameter("ne", null));
        Long contractId = null;
        Long storeId = null;
        Long orgId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("contractId")) {
                return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
            }
            contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            if (null != conditionMap.get("storeId")) {
                storeId = Long.valueOf(conditionMap.get("storeId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage dailyRentEntityIPage = this.dailyRentService.queryPage(param, false);
        List dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }
        IPage monthRentEntityIPage = this.monthRentService.queryPage(param, false);
        List monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }
        IPage numRentEntityIPage = this.numRentService.queryPage(param, false);
        List numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }
        List<Object> rentRefVOList = new ArrayList();
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)dailyRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)monthRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)numRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
        rentRefVOList.forEach(e -> e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType())));
        List resultList = PageUtil.listToPage(rentRefVOList, (int)pageNumber, (int)pageSize);
        this.getStoreNum(storeId, orgId, resultList);
        Page page = new Page();
        page.setRecords(resultList);
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        page.setTotal((long)resultList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/arriContractRentTypeRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractRentRefVO>> arriContractRentTypeRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List listType;
        CommonResponse respType;
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("materialId", new Parameter("eq", null));
        Long contractId = null;
        Long storeId = null;
        Long orgId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("contractId")) {
                return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
            }
            contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            if (null != conditionMap.get("storeId")) {
                storeId = Long.valueOf(conditionMap.get("storeId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        param.getOrderMap().put("createTime", "desc");
        ArrayList<Long> typrList = new ArrayList<Long>();
        HashMap<Long, Object> mapType = new HashMap<Long, Object>();
        ArrayList rentRefVOList = new ArrayList();
        IPage dailyRentEntityIPage = this.dailyRentService.queryPage(param, false);
        List dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
            typrList.add(entity.getMaterialTypeId());
            if (mapType.containsKey(entity.getMaterialTypeId())) continue;
            mapType.put(entity.getMaterialTypeId(), BeanMapper.map((Object)((Object)entity), OutRmatContractRentRefVO.class));
        }
        IPage monthRentEntityIPage = this.monthRentService.queryPage(param, false);
        List monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
            typrList.add(entity.getMaterialTypeId());
            if (mapType.containsKey(entity.getMaterialTypeId())) continue;
            mapType.put(entity.getMaterialTypeId(), BeanMapper.map((Object)((Object)entity), OutRmatContractRentRefVO.class));
        }
        IPage numRentEntityIPage = this.numRentService.queryPage(param, false);
        List numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
            typrList.add(entity.getMaterialTypeId());
            if (mapType.containsKey(entity.getMaterialTypeId())) continue;
            mapType.put(entity.getMaterialTypeId(), BeanMapper.map((Object)((Object)entity), OutRmatContractRentRefVO.class));
        }
        if (CollectionUtils.isNotEmpty(typrList) && (respType = this.materialApi.queryMaterialByCategoryId(typrList)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)respType.getData())) && CollectionUtils.isNotEmpty((Collection)(listType = (List)respType.getData()))) {
            listType.forEach(e -> {
                OutRmatContractRentRefVO outRmatContractRentRefVO = (OutRmatContractRentRefVO)BeanMapper.map(mapType.get(e.getCategoryId()), OutRmatContractRentRefVO.class);
                outRmatContractRentRefVO.setId(e.getId());
                outRmatContractRentRefVO.setMaterialId(e.getId());
                outRmatContractRentRefVO.setMaterialCode(e.getCode());
                outRmatContractRentRefVO.setSpec(e.getSpec());
                outRmatContractRentRefVO.setUnitMId(e.getUnitId());
                outRmatContractRentRefVO.setUnitMName(e.getUnitName());
                outRmatContractRentRefVO.setMaterialName(e.getName());
                rentRefVOList.add(outRmatContractRentRefVO);
            });
        }
        rentRefVOList.forEach(e -> e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType())));
        List resultList = PageUtil.listToPage(rentRefVOList, (int)pageNumber, (int)pageSize);
        this.getStoreNum(storeId, orgId, resultList);
        Page page = new Page();
        page.setRecords(resultList);
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        page.setTotal((long)rentRefVOList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private void getStoreNum(Long storeId, Long orgId, List<OutRmatContractRentRefVO> list) {
        List<StoreNumVO> vos = new ArrayList<StoreNumVO>();
        for (OutRmatContractRentRefVO detail : list) {
            StoreNumVO vo = new StoreNumVO();
            vo.setOrgId(orgId);
            vo.setMaterialId(detail.getMaterialId());
            vo.setUnitMId(detail.getUnitMId());
            vo.setUnitId(detail.getUnitId());
            vo.setStoreId(orgId);
            vo.setSourceType(RmatCommonConsts.RENT_OUT);
            if (storeId != null) {
                vo.setStoreId(storeId);
                vo.setSourceType(RmatCommonConsts.PURCHASE_OUT);
            }
            vos.add(vo);
        }
        vos = this.materialService.getStoreNum(vos);
        Map<String, StoreNumVO> storeMap = vos.stream().collect(Collectors.toMap(x -> x.getStoreId() + "|" + x.getMaterialId(), x -> x));
        for (OutRmatContractRentRefVO detail : list) {
            String key = storeId != null ? storeId + "|" + detail.getMaterialId() : orgId + "|" + detail.getMaterialId();
            if (!storeMap.containsKey(key)) continue;
            detail.setSurplusCount(storeMap.get(key).getAssistNum());
            detail.setSurplusM(storeMap.get(key).getStoreNum());
            detail.setTransScale(storeMap.get(key).getTransScale());
            detail.setDeviationRate(storeMap.get(key).getDeviationRate());
        }
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse billTypeResp = this.billTypeApi.getByRefCode("out_arri_contract");
        if (!billTypeResp.isSuccess()) {
            this.logger.error("\u6839\u636erefCode-{}\u67e5\u8be2\u5bf9\u5e94\u5143\u6570\u636e\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)"out_arri_contract", (Object)billTypeResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        }
        OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(outRmatContractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)outRmatContractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)outRmatContractEntity.getId());
        resp.put("contractBillTypeCode", (Object)((BillTypeVO)billTypeResp.getData()).getBillCode());
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatContractSupplementRecordVO> querySupplementRecord(@RequestParam Long id) {
        OutRmatContractSupplementRecordVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addRelieveFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = this.relieveService.addRelieveFlag(id);
        return CommonResponse.success((String)"\u6821\u9a8c\u8be5\u5408\u540c\u65b0\u589e\u5408\u540c\u89e3\u9664\u5355\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @RequestMapping(value={"/arriContractCategoryRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OutRmatContractRentRefVO>> arriContractCategoryRef(@RequestParam(value="contractId") Long contractId, @RequestParam(value="storeId", required=false) Long storeId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("row_type", new Parameter("eq", (Object)0));
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("createTime", "desc");
        IPage dailyRentEntityIPage = this.dailyRentService.queryPage(param, false);
        List dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }
        IPage monthRentEntityIPage = this.monthRentService.queryPage(param, false);
        List monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }
        IPage numRentEntityIPage = this.numRentService.queryPage(param, false);
        List numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }
        List<Object> rentRefVOList = new ArrayList<OutRmatContractRentRefVO>();
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)dailyRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)monthRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList((Iterable)numRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList = this.getMaterialByCategory(rentRefVOList);
        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
        rentRefVOList.forEach(e -> e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType())));
        this.getStoreNum(storeId, contractId, rentRefVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", rentRefVOList);
    }

    private List<OutRmatContractRentRefVO> getMaterialByCategory(List<OutRmatContractRentRefVO> rentRefVOList) {
        CommonResponse materialResp;
        Map<Long, OutRmatContractRentRefVO> rentRefVOMap = rentRefVOList.stream().collect(Collectors.toMap(OutRmatContractRentRefVO::getMaterialTypeId, x -> x));
        rentRefVOList = new ArrayList<OutRmatContractRentRefVO>();
        if (CollectionUtils.isNotEmpty(rentRefVOMap.keySet()) && (materialResp = this.materialApi.queryMaterialByCategoryId(new ArrayList<Long>(rentRefVOMap.keySet()))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)materialResp.getData()))) {
            for (MaterialVO item : (List)materialResp.getData()) {
                OutRmatContractRentRefVO vo = new OutRmatContractRentRefVO();
                vo.setId(item.getId());
                vo.setMaterialId(item.getId());
                vo.setMaterialCode(item.getCode());
                vo.setSpec(item.getSpec());
                vo.setMaterialTypeId(item.getCategoryId());
                vo.setMaterialTypeName(item.getCategoryName());
                vo.setMaterialName(item.getName());
                vo.setCreateTime(item.getCreateTime());
                vo.setUnitMId(item.getUnitId());
                vo.setUnitMName(item.getUnitName());
                OutRmatContractRentRefVO category = rentRefVOMap.get(item.getCategoryId());
                vo.setUnitId(category.getUnitId());
                vo.setUnitName(category.getUnitName());
                vo.setRentCalculationType(category.getRentCalculationType());
                vo.setCount(category.getCount());
            }
        }
        return rentRefVOList;
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billType", required=false) String billType, @RequestParam(value="billId", required=false) Long billId, @RequestParam(value="type", required=false) String type) {
        String msg = this.service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }
}

