/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.contract.enums.StatusTypeEnum;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.outrmat.stop.service.IOutRmatStopService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/outRmat/"})
@Api(value="\u8f85\u6599\u4e2d\u5fc3\u79df\u51faAPI\u63a5\u53e3", tags={"\u8f85\u6599\u4e2d\u5fc3\u79df\u51faAPI\u63a5\u53e3"})
public class OutRmatApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderService outRmatOrderService;
    @Autowired
    private IOutRmatSettleService outRmatSettleService;
    @Autowired
    private IOutRmatLoseService outRmatLoseService;
    @Autowired
    private IOutRmatStartService outRmatStartService;
    @Autowired
    private IOutRmatStopService outRmatStopService;
    @Autowired
    private IOutRmatDeliveryService outRmatDeliveryService;
    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;

    @ApiOperation(value="\u4fdd\u5b58\u63a8\u9001\u7684\u8ba2\u5355\u6570\u636e")
    @RequestMapping(value={"/saveOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        this.logger.info("\u8ba2\u5355\u6570\u636e--" + JSONObject.toJSONString((Object)saveOrUpdateVO));
        this.outRmatOrderService.saveOrder(saveOrUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5220\u9664\u63a8\u9001\u7684\u8ba2\u5355\u6570\u636e")
    @RequestMapping(value={"/deleteOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        this.logger.info("\u8ba2\u5355\u6570\u636e--" + JSONObject.toJSONString((Object)saveOrUpdateVO));
        this.outRmatOrderService.deleteOrder(saveOrUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u8ba2\u5355\u5173\u95ed")
    @RequestMapping(value={"/updateOrderCloseFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateOrderCloseFlag(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        this.logger.info("\u8ba2\u5355\u6570\u636e--" + JSONObject.toJSONString((Object)saveOrUpdateVO));
        String s = this.outRmatOrderService.updateOrderCloseFlag(saveOrUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)s);
    }

    @ApiOperation(value="\u516c\u5171\u7b7e\u5b57\u63a5\u53e3")
    @RequestMapping(value={"/updateBillSupSignSyncInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateBillSupSignSyncInfo(@RequestBody Map<String, String> map, String type) {
        this.logger.info("\u5355\u636e\u540d\u79f0\uff1a" + type + "\u6570\u636e\u4fe1\u606f--" + JSONObject.toJSONString(map));
        String msg = "\u8be5\u5355\u636e\u672a\u5b9a\u4e49\uff01";
        switch (StatusTypeEnum.getEnumByName((String)type)) {
            case \u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u7ed3\u7b97\u5355: {
                msg = this.outRmatSettleService.updateBillSupSignSyncInfo(map);
                break;
            }
            case \u79df\u51fa\u9057\u5931\u5355: {
                msg = this.outRmatLoseService.updateBillSupSignSyncInfo(map);
                break;
            }
            case \u79df\u51fa\u542f\u7528\u5355: {
                msg = this.outRmatStartService.updateBillSupSignSync(map);
                break;
            }
            case \u79df\u51fa\u505c\u7528\u5355: {
                msg = this.outRmatStopService.updateBillSupSignSync(map);
                break;
            }
            case \u79df\u51fa\u51fa\u5e93\u5355: {
                msg = this.outRmatDeliveryService.updateBillSupSignSync(map);
                break;
            }
            case \u79df\u51fa\u9000\u8d54\u5355: {
                msg = this.outRmatRestituteService.updateBillSupSignSync(map);
                break;
            }
            default: {
                return CommonResponse.error((String)("\u5355\u636e\u540d\u79f0\uff1a" + type + "\u7b7e\u5b57\u672a\u5b9a\u4e49\uff01"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }
}

