/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.service.IMaterialContractFileService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class MaterialContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialContractService contractService;
    @Autowired
    private IMaterialContractFileService service;

    @PostMapping(value={"/materialContractFileUpdate/updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/materialContractFileUpdate/getBillDataJson"})
    public CommonResponse<MaterialContractVO> getBillDataJson(@RequestParam Long id) {
        this.logger.info("-----\u67e5\u8be2\u5408\u540c\u5b50\u8868\u5408\u5e76-----\u5408\u540cid\uff1a{}", (Object)id);
        MaterialContractEntity materialContractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(id));
        MaterialContractVO vo = (MaterialContractVO)BeanMapper.map((Object)((Object)materialContractEntity), MaterialContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherList())) {
            vo.getOtherList().forEach(item -> {
                item.setOtherPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> item.setPaymentScaleStr(null != item.getPaymentScale() ? mnyFmt.format(item.getPaymentScale()) : mnyFmt.format(BigDecimal.ZERO)));
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getClauseList())) {
            vo.getClauseList().forEach(item -> item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus() == 1 ? "\u662f" : "\u5426"));
        }
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/material/billFileUpdate/getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getSignedFileInfo(billId, billType));
    }
}

